/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.swagger.converter.api;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.Path;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Rule;
import io.gravitee.management.model.api.SwaggerApiEntity;
import io.gravitee.management.service.impl.swagger.converter.api.SwaggerToApiConverter;
import io.gravitee.management.service.impl.swagger.visitor.v3.OAIDescriptorVisitor;
import io.gravitee.management.service.impl.swagger.visitor.v3.OAIOperationVisitor;
import io.gravitee.management.service.swagger.OAIDescriptor;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class OAIToAPIConverter
implements SwaggerToApiConverter<OAIDescriptor>,
OAIDescriptorVisitor<SwaggerApiEntity> {
    private final Collection<? extends OAIOperationVisitor> visitors;

    public OAIToAPIConverter(Collection<? extends OAIOperationVisitor> visitors) {
        this.visitors = visitors;
    }

    @Override
    public SwaggerApiEntity convert(OAIDescriptor descriptor) {
        if (descriptor == null || descriptor.getSpecification() == null) {
            return null;
        }
        return this.visit(descriptor.getSpecification());
    }

    @Override
    public SwaggerApiEntity visit(final OpenAPI oai) {
        SwaggerApiEntity apiEntity = new SwaggerApiEntity();
        apiEntity.setName(oai.getInfo().getTitle());
        String contextPath = null;
        if (!oai.getServers().isEmpty()) {
            List<String> evaluatedServerUrl = this.mapServersToEndpoint(oai.getServers());
            apiEntity.setEndpoint(evaluatedServerUrl);
            contextPath = evaluatedServerUrl.get(0);
            contextPath = URI.create(contextPath).getPath();
        }
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = apiEntity.getName().replaceAll("\\s+", "").toLowerCase();
        }
        apiEntity.setContextPath(contextPath);
        apiEntity.setDescription(oai.getInfo().getDescription() == null ? "Description of " + apiEntity.getName() : oai.getInfo().getDescription());
        apiEntity.setVersion(oai.getInfo().getVersion());
        apiEntity.setPaths(oai.getPaths().entrySet().stream().map(entry -> {
            Path path = new Path();
            path.setPath(((String)entry.getKey()).replaceAll("\\{(.[^/]*)\\}", ":$1"));
            Map operations = ((PathItem)entry.getValue()).readOperationsMap();
            final ArrayList rules = new ArrayList();
            operations.forEach(new BiConsumer<PathItem.HttpMethod, Operation>(){

                @Override
                public void accept(final PathItem.HttpMethod httpMethod, final Operation operation) {
                    OAIToAPIConverter.this.visitors.forEach(new Consumer<OAIOperationVisitor>(){

                        @Override
                        public void accept(OAIOperationVisitor oaiOperationVisitor) {
                            Optional policy = (Optional)oaiOperationVisitor.visit(oai, operation);
                            if (policy.isPresent()) {
                                Rule rule = new Rule();
                                rule.setEnabled(true);
                                rule.setDescription(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary());
                                rule.setMethods(Collections.singleton(HttpMethod.valueOf((String)httpMethod.name())));
                                Policy defPolicy = new Policy();
                                defPolicy.setName(((io.gravitee.policy.api.swagger.Policy)policy.get()).getName());
                                defPolicy.setConfiguration(((io.gravitee.policy.api.swagger.Policy)policy.get()).getConfiguration());
                                rule.setPolicy(defPolicy);
                                rules.add(rule);
                            }
                        }
                    });
                }
            });
            path.setRules(rules);
            return path;
        }).collect(Collectors.toMap(Path::getPath, path -> path)));
        if (apiEntity.getPaths() != null) {
            apiEntity.setPathMappings(apiEntity.getPaths().keySet());
        }
        return apiEntity;
    }

    private List<String> mapServersToEndpoint(List<Server> servers) {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Server server : servers) {
            ServerVariables serverVariables = server.getVariables();
            String serverUrl = server.getUrl();
            if (CollectionUtils.isEmpty((Map)serverVariables)) {
                endpoints.add(serverUrl);
                continue;
            }
            List<String> evaluatedUrls = Collections.singletonList(serverUrl);
            for (Map.Entry serverVar : serverVariables.entrySet()) {
                evaluatedUrls = this.evaluateServerUrlsForOneVar((String)serverVar.getKey(), (ServerVariable)serverVar.getValue(), evaluatedUrls);
            }
            endpoints.addAll(evaluatedUrls);
        }
        return endpoints;
    }

    private List<String> evaluateServerUrlsForOneVar(String varName, ServerVariable serverVar, List<String> templateUrls) {
        ArrayList<String> evaluatedUrls = new ArrayList<String>();
        for (String templateUrl : templateUrls) {
            Matcher matcher = Pattern.compile("\\{" + varName + "\\}").matcher(templateUrl);
            if (!matcher.find()) continue;
            if (CollectionUtils.isEmpty((Collection)serverVar.getEnum()) && serverVar.getDefault() != null) {
                evaluatedUrls.add(templateUrl.replace(matcher.group(0), serverVar.getDefault()));
                continue;
            }
            for (String enumValue : serverVar.getEnum()) {
                evaluatedUrls.add(templateUrl.replace(matcher.group(0), enumValue));
            }
        }
        return evaluatedUrls;
    }
}

