/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.transformer;

import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.lucene.DocumentTransformer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserDocumentTransformer
implements DocumentTransformer<UserEntity> {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_TYPE_VALUE = "user";
    private static final String FIELD_FIRSTNAME = "firstname";
    private static final String FIELD_LASTNAME = "lastname";
    private static final String FIELD_DISPLAYNAME = "displayname";
    private static final String FIELD_DISPLAYNAME_SPLIT = "displayname_split";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_REFERENCE = "reference";
    private final Logger logger = LoggerFactory.getLogger(UserDocumentTransformer.class);

    @Override
    public Document transform(UserEntity user) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(FIELD_ID, user.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_TYPE, FIELD_TYPE_VALUE, Field.Store.YES));
        if (user.getSource() != null) {
            doc.add((IndexableField)new StringField(FIELD_SOURCE, user.getSource(), Field.Store.NO));
        }
        if (user.getSourceId() != null) {
            String sourceId = user.getSourceId().contains("@") ? user.getSourceId().substring(0, user.getSourceId().indexOf(64)) : user.getSourceId();
            doc.add((IndexableField)new StringField(FIELD_REFERENCE, sourceId, Field.Store.NO));
        }
        if (user.getDisplayName() != null) {
            doc.add((IndexableField)new StringField(FIELD_DISPLAYNAME, user.getDisplayName(), Field.Store.NO));
            doc.add((IndexableField)new TextField(FIELD_DISPLAYNAME_SPLIT, user.getDisplayName(), Field.Store.NO));
        }
        if (user.getFirstname() != null) {
            doc.add((IndexableField)new StringField(FIELD_FIRSTNAME, user.getFirstname(), Field.Store.NO));
        }
        if (user.getLastname() != null) {
            doc.add((IndexableField)new StringField(FIELD_LASTNAME, user.getLastname(), Field.Store.NO));
        }
        if (user.getEmail() != null) {
            if (user.getEmail().indexOf(64) < 0) {
                this.logger.warn("Email of the user %s is not valid", (Object)user.getId());
            } else {
                doc.add((IndexableField)new StringField(FIELD_EMAIL, user.getEmail().substring(0, user.getEmail().indexOf(64)), Field.Store.NO));
            }
        }
        return doc;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return UserEntity.class.isAssignableFrom(source);
    }
}

