/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.searcher;

import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.repository.exceptions.TechnicalException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class PageDocumentSearcher
extends AbstractDocumentSearcher {
    protected static final String FIELD_TYPE_VALUE = "page";

    @Override
    public SearchResult search(io.gravitee.management.service.search.query.Query query) throws TechnicalException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"name", "name_lowercase", "content"}, this.analyzer);
        parser.setFuzzyMinSim(0.6f);
        try {
            Query parse = parser.parse(QueryParserBase.escape((String)query.getQuery()));
            BooleanQuery.Builder pageQuery = new BooleanQuery.Builder();
            BooleanQuery.Builder pageFieldsQuery = new BooleanQuery.Builder();
            pageFieldsQuery.add(parse, BooleanClause.Occur.SHOULD);
            pageFieldsQuery.add((Query)new WildcardQuery(new Term("name", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            pageFieldsQuery.add((Query)new WildcardQuery(new Term("name_lowercase", '*' + query.getQuery().toLowerCase() + '*')), BooleanClause.Occur.SHOULD);
            pageFieldsQuery.add((Query)new WildcardQuery(new Term("content", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            pageQuery.add((Query)pageFieldsQuery.build(), BooleanClause.Occur.MUST);
            pageQuery.add((Query)new TermQuery(new Term("type", FIELD_TYPE_VALUE)), BooleanClause.Occur.MUST);
            return this.search((Query)pageQuery.build());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for page documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for page documents", (Throwable)pe);
        }
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(PageEntity.class);
    }
}

