/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.configuration;

import io.gravitee.management.service.impl.search.lucene.SearchEngineIndexer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SearchEngineConfiguration {
    @Value(value="${search.data:${gravitee.home}/data}")
    private String indexDirectory;

    @Bean
    public SearchEngineIndexer searchEngineIndexer() {
        return new SearchEngineIndexer();
    }

    @Bean
    public Directory indexDirectory() throws IOException {
        Path path = Paths.get(this.indexDirectory, new String[0]);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        return FSDirectory.open((Path)path);
    }

    @Bean
    public IndexWriter indexWriter(Directory directory, Analyzer analyzer) throws IOException {
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        return new IndexWriter(directory, iwc);
    }

    @Bean
    public Analyzer analyzer() {
        return new StandardAnalyzer();
    }
}

