/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.configuration.identity;

import io.gravitee.management.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.management.model.configuration.identity.IdentityProviderType;
import io.gravitee.management.model.configuration.identity.SocialIdentityProviderEntity;
import io.gravitee.management.model.configuration.identity.am.AMIdentityProviderEntity;
import io.gravitee.management.model.configuration.identity.github.GitHubIdentityProviderEntity;
import io.gravitee.management.model.configuration.identity.google.GoogleIdentityProviderEntity;
import io.gravitee.management.model.configuration.identity.oidc.OIDCIdentityProviderEntity;
import io.gravitee.management.service.SocialIdentityProviderService;
import io.gravitee.management.service.configuration.identity.IdentityProviderService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.impl.configuration.identity.IdentityProviderNotFoundException;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SocialIdentityProviderImpl
extends AbstractService
implements SocialIdentityProviderService {
    private final Logger LOGGER = LoggerFactory.getLogger(SocialIdentityProviderImpl.class);
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(http:|https:))[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    @Autowired
    private IdentityProviderService identityProviderService;

    @Override
    public Set<SocialIdentityProviderEntity> findAll() {
        try {
            return this.identityProviderService.findAll().stream().filter(IdentityProviderEntity::isEnabled).map(this::convert).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to retrieve identity providers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve identity providers", ex);
        }
    }

    @Override
    public SocialIdentityProviderEntity findById(String id) {
        try {
            this.LOGGER.debug("Find identity provider by ID: {}", (Object)id);
            IdentityProviderEntity identityProvider = this.identityProviderService.findById(id);
            if (!identityProvider.isEnabled()) {
                throw new IdentityProviderNotFoundException(identityProvider.getId());
            }
            return this.convert(identityProvider);
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to find an identity provider using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete an identity provider using its ID " + id, ex);
        }
    }

    private SocialIdentityProviderEntity convert(IdentityProviderEntity identityProvider) {
        GoogleIdentityProviderEntity provider = null;
        if (identityProvider.getType() == IdentityProviderType.GOOGLE) {
            provider = new GoogleIdentityProviderEntity();
        } else if (identityProvider.getType() == IdentityProviderType.GITHUB) {
            provider = new GitHubIdentityProviderEntity();
        } else if (identityProvider.getType() == IdentityProviderType.OIDC) {
            provider = new OIDCIdentityProviderEntity();
            ((OIDCIdentityProviderEntity)provider).setColor((String)identityProvider.getConfiguration().get("color"));
            ((OIDCIdentityProviderEntity)provider).setDiscoveryEndpoint((String)identityProvider.getConfiguration().get("discoveryEndpoint"));
            ((OIDCIdentityProviderEntity)provider).setTokenEndpoint((String)identityProvider.getConfiguration().get("tokenEndpoint"));
            ((OIDCIdentityProviderEntity)provider).setAuthorizationEndpoint((String)identityProvider.getConfiguration().get("authorizeEndpoint"));
            ((OIDCIdentityProviderEntity)provider).setTokenIntrospectionEndpoint((String)identityProvider.getConfiguration().get("tokenIntrospectionEndpoint"));
            ((OIDCIdentityProviderEntity)provider).setUserInfoEndpoint((String)identityProvider.getConfiguration().get("userInfoEndpoint"));
            ((OIDCIdentityProviderEntity)provider).setUserLogoutEndpoint((String)identityProvider.getConfiguration().get("userLogoutEndpoint"));
            ((OIDCIdentityProviderEntity)provider).setScopes((List)identityProvider.getConfiguration().get("scopes"));
            ((OIDCIdentityProviderEntity)provider).setUserProfileMapping(identityProvider.getUserProfileMapping());
        } else if (identityProvider.getType() == IdentityProviderType.GRAVITEEIO_AM) {
            String serverBaseUrl = (String)identityProvider.getConfiguration().get("serverURL");
            String domain = (String)identityProvider.getConfiguration().get("domain");
            String serverUrl = DUPLICATE_SLASH_REMOVER.matcher(serverBaseUrl + '/' + domain).replaceAll(URI_PATH_SEPARATOR);
            if (serverUrl.lastIndexOf(URI_PATH_SEPARATOR) == serverUrl.length() - 1) {
                serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
            }
            provider = new AMIdentityProviderEntity(serverUrl);
            ((AMIdentityProviderEntity)provider).setColor((String)identityProvider.getConfiguration().get("color"));
            ((AMIdentityProviderEntity)provider).setDiscoveryEndpoint((String)identityProvider.getConfiguration().get("discoveryEndpoint"));
            ((AMIdentityProviderEntity)provider).setScopes((List)identityProvider.getConfiguration().get("scopes"));
            ((AMIdentityProviderEntity)provider).setUserProfileMapping(identityProvider.getUserProfileMapping());
        }
        if (provider != null) {
            provider.setId(identityProvider.getId());
            provider.setName(identityProvider.getName());
            provider.setDescription(identityProvider.getDescription());
            provider.setClientId((String)identityProvider.getConfiguration().get(CLIENT_ID));
            provider.setClientSecret((String)identityProvider.getConfiguration().get(CLIENT_SECRET));
            provider.setGroupMappings(identityProvider.getGroupMappings());
            provider.setRoleMappings(identityProvider.getRoleMappings());
            provider.setRoleMappings(identityProvider.getRoleMappings());
            provider.setEmailRequired(identityProvider.isEmailRequired());
            provider.setSyncMappings(identityProvider.isSyncMappings());
            return provider;
        }
        return null;
    }
}

