/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.configuration.identity;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.management.model.configuration.identity.GroupMappingEntity;
import io.gravitee.management.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.management.model.configuration.identity.NewIdentityProviderEntity;
import io.gravitee.management.model.configuration.identity.RoleMappingEntity;
import io.gravitee.management.model.configuration.identity.UpdateIdentityProviderEntity;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.configuration.identity.IdentityProviderService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.impl.configuration.identity.ClientIdRequiredException;
import io.gravitee.management.service.impl.configuration.identity.ClientSecretRequiredException;
import io.gravitee.management.service.impl.configuration.identity.IdentityProviderAlreadyExistsException;
import io.gravitee.management.service.impl.configuration.identity.IdentityProviderNotFoundException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IdentityProviderRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.IdentityProviderType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdentityProviderServiceImpl
extends AbstractService
implements IdentityProviderService {
    private final Logger LOGGER = LoggerFactory.getLogger(IdentityProviderServiceImpl.class);
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    @Autowired
    private IdentityProviderRepository identityProviderRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private RoleService roleService;

    @Override
    public IdentityProviderEntity create(NewIdentityProviderEntity newIdentityProviderEntity) {
        try {
            this.LOGGER.debug("Create identity provider {}", (Object)newIdentityProviderEntity);
            Optional optIdentityProvider = this.identityProviderRepository.findById((Object)IdGenerator.generate((String)newIdentityProviderEntity.getName()));
            if (optIdentityProvider.isPresent()) {
                throw new IdentityProviderAlreadyExistsException(newIdentityProviderEntity.getName());
            }
            IdentityProvider identityProvider = this.convert(newIdentityProviderEntity);
            if (identityProvider.getType() == IdentityProviderType.GOOGLE || identityProvider.getType() == IdentityProviderType.GITHUB) {
                this.checkSocialProvider(identityProvider);
            }
            identityProvider.setCreatedAt(new Date());
            identityProvider.setUpdatedAt(identityProvider.getCreatedAt());
            IdentityProvider createdIdentityProvider = (IdentityProvider)this.identityProviderRepository.create((Object)identityProvider);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, createdIdentityProvider.getId()), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_CREATED, createdIdentityProvider.getUpdatedAt(), null, createdIdentityProvider);
            return this.convert(createdIdentityProvider);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create identity provider {}", (Object)newIdentityProviderEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create " + newIdentityProviderEntity, ex);
        }
    }

    @Override
    public IdentityProviderEntity update(String id, UpdateIdentityProviderEntity updateIdentityProvider) {
        try {
            this.LOGGER.debug("Update identity provider {}", (Object)updateIdentityProvider);
            Optional optIdentityProvider = this.identityProviderRepository.findById((Object)id);
            if (!optIdentityProvider.isPresent()) {
                throw new IdentityProviderNotFoundException(updateIdentityProvider.getName());
            }
            IdentityProvider identityProvider = this.convert(updateIdentityProvider);
            IdentityProvider idpToUpdate = (IdentityProvider)optIdentityProvider.get();
            identityProvider.setId(id);
            identityProvider.setType(idpToUpdate.getType());
            identityProvider.setCreatedAt(idpToUpdate.getCreatedAt());
            identityProvider.setUpdatedAt(new Date());
            IdentityProvider updatedIdentityProvider = (IdentityProvider)this.identityProviderRepository.update((Object)identityProvider);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, id), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_UPDATED, identityProvider.getUpdatedAt(), idpToUpdate, updatedIdentityProvider);
            return this.convert(updatedIdentityProvider);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update identity provider {}", (Object)updateIdentityProvider, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update " + updateIdentityProvider, ex);
        }
    }

    @Override
    public IdentityProviderEntity findById(String id) {
        try {
            this.LOGGER.debug("Find identity provider by ID: {}", (Object)id);
            Optional identityProvider = this.identityProviderRepository.findById((Object)id);
            if (identityProvider.isPresent()) {
                return this.convert((IdentityProvider)identityProvider.get());
            }
            throw new IdentityProviderNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an identity provider using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete an identity provider using its ID " + id, ex);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.LOGGER.debug("Delete identity provider: {}", (Object)id);
            Optional identityProvider = this.identityProviderRepository.findById((Object)id);
            if (!identityProvider.isPresent()) {
                throw new IdentityProviderNotFoundException(id);
            }
            this.identityProviderRepository.delete((Object)id);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, id), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_DELETED, new Date(), identityProvider.get(), null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete an identity provider using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete an identity provider using its ID " + id, ex);
        }
    }

    private void checkSocialProvider(IdentityProvider identityProvider) {
        Map providerConfiguration = identityProvider.getConfiguration();
        String clientId = (String)providerConfiguration.get(CLIENT_ID);
        if (clientId == null || clientId.isEmpty()) {
            throw new ClientIdRequiredException(identityProvider.getName());
        }
        String clientSecret = (String)providerConfiguration.get(CLIENT_SECRET);
        if (clientSecret == null || clientSecret.isEmpty()) {
            throw new ClientSecretRequiredException(identityProvider.getName());
        }
    }

    @Override
    public Set<IdentityProviderEntity> findAll() {
        try {
            return this.identityProviderRepository.findAll().stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to retrieve identity providers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve identity providers", ex);
        }
    }

    private IdentityProvider convert(NewIdentityProviderEntity newIdentityProviderEntity) {
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setId(IdGenerator.generate((String)newIdentityProviderEntity.getName()));
        identityProvider.setName(newIdentityProviderEntity.getName());
        identityProvider.setDescription(newIdentityProviderEntity.getDescription());
        identityProvider.setConfiguration(newIdentityProviderEntity.getConfiguration());
        identityProvider.setType(IdentityProviderType.valueOf((String)newIdentityProviderEntity.getType().name().toUpperCase()));
        identityProvider.setEnabled(newIdentityProviderEntity.isEnabled());
        identityProvider.setUserProfileMapping(newIdentityProviderEntity.getUserProfileMapping());
        identityProvider.setEmailRequired(Boolean.valueOf(newIdentityProviderEntity.isEmailRequired()));
        identityProvider.setSyncMappings(Boolean.valueOf(newIdentityProviderEntity.isSyncMappings()));
        return identityProvider;
    }

    private IdentityProviderEntity convert(IdentityProvider identityProvider) {
        IdentityProviderEntity identityProviderEntity = new IdentityProviderEntity();
        identityProviderEntity.setId(identityProvider.getId());
        identityProviderEntity.setName(identityProvider.getName());
        identityProviderEntity.setDescription(identityProvider.getDescription());
        identityProviderEntity.setEnabled(identityProvider.isEnabled());
        identityProviderEntity.setType(io.gravitee.management.model.configuration.identity.IdentityProviderType.valueOf((String)identityProvider.getType().name().toUpperCase()));
        identityProviderEntity.setConfiguration(identityProvider.getConfiguration());
        if (identityProvider.getGroupMappings() != null && !identityProvider.getGroupMappings().isEmpty()) {
            identityProviderEntity.setGroupMappings(identityProvider.getGroupMappings().entrySet().stream().map(entry -> {
                GroupMappingEntity groupMapping = new GroupMappingEntity();
                groupMapping.setCondition((String)entry.getKey());
                if (entry.getValue() != null) {
                    groupMapping.setGroups(Arrays.asList((Object[])entry.getValue()));
                }
                return groupMapping;
            }).collect(Collectors.toList()));
        }
        if (identityProvider.getRoleMappings() != null && !identityProvider.getRoleMappings().isEmpty()) {
            identityProviderEntity.setRoleMappings(identityProvider.getRoleMappings().entrySet().stream().map(new Function<Map.Entry<String, String[]>, RoleMappingEntity>(){

                @Override
                public RoleMappingEntity apply(Map.Entry<String, String[]> entry) {
                    RoleMappingEntity roleMapping = new RoleMappingEntity();
                    roleMapping.setCondition(entry.getKey());
                    if (entry.getValue() != null) {
                        for (String role : entry.getValue()) {
                            if (role.startsWith(RoleScope.MANAGEMENT.getId() + ":")) {
                                roleMapping.setManagement(role.split(":")[1]);
                                continue;
                            }
                            if (!role.startsWith(RoleScope.PORTAL.getId() + ":")) continue;
                            roleMapping.setPortal(role.split(":")[1]);
                        }
                    }
                    return roleMapping;
                }
            }).collect(Collectors.toList()));
        }
        identityProviderEntity.setConfiguration(identityProvider.getConfiguration());
        identityProviderEntity.setCreatedAt(identityProvider.getCreatedAt());
        identityProviderEntity.setUpdatedAt(identityProvider.getUpdatedAt());
        identityProviderEntity.setUserProfileMapping(identityProvider.getUserProfileMapping());
        if (identityProvider.getEmailRequired() == null) {
            identityProviderEntity.setEmailRequired(true);
        } else {
            identityProviderEntity.setEmailRequired(identityProvider.getEmailRequired().booleanValue());
        }
        identityProviderEntity.setSyncMappings(identityProvider.getSyncMappings() == null ? false : identityProvider.getSyncMappings());
        return identityProviderEntity;
    }

    private IdentityProvider convert(UpdateIdentityProviderEntity updateIdentityProvider) {
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setName(updateIdentityProvider.getName());
        identityProvider.setDescription(updateIdentityProvider.getDescription());
        identityProvider.setEnabled(updateIdentityProvider.isEnabled());
        identityProvider.setConfiguration(updateIdentityProvider.getConfiguration());
        identityProvider.setUserProfileMapping(updateIdentityProvider.getUserProfileMapping());
        identityProvider.setEmailRequired(Boolean.valueOf(updateIdentityProvider.isEmailRequired()));
        identityProvider.setSyncMappings(Boolean.valueOf(updateIdentityProvider.isSyncMappings()));
        if (updateIdentityProvider.getGroupMappings() != null && !updateIdentityProvider.getGroupMappings().isEmpty()) {
            identityProvider.setGroupMappings(updateIdentityProvider.getGroupMappings().stream().collect(Collectors.toMap(GroupMappingEntity::getCondition, groupMappingEntity -> {
                String[] groups = new String[groupMappingEntity.getGroups().size()];
                return groupMappingEntity.getGroups().toArray(groups);
            })));
        }
        if (updateIdentityProvider.getRoleMappings() != null && !updateIdentityProvider.getRoleMappings().isEmpty()) {
            identityProvider.setRoleMappings(updateIdentityProvider.getRoleMappings().stream().collect(Collectors.toMap(RoleMappingEntity::getCondition, roleMapping -> {
                ArrayList<String> lstRoles = new ArrayList<String>();
                if (roleMapping.getPortal() != null) {
                    this.roleService.findById(RoleScope.PORTAL, roleMapping.getPortal());
                    lstRoles.add(RoleScope.PORTAL.getId() + ":" + roleMapping.getPortal());
                }
                if (roleMapping.getManagement() != null) {
                    this.roleService.findById(RoleScope.MANAGEMENT, roleMapping.getManagement());
                    lstRoles.add(RoleScope.MANAGEMENT.getId() + ":" + roleMapping.getManagement());
                }
                String[] roles = new String[lstRoles.size()];
                return lstRoles.toArray(roles);
            })));
        }
        return identityProvider;
    }
}

