/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.configuration.application.registration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.el.TemplateEngine;
import io.gravitee.management.model.NewApplicationEntity;
import io.gravitee.management.model.UpdateApplicationEntity;
import io.gravitee.management.model.configuration.application.registration.ClientRegistrationProviderEntity;
import io.gravitee.management.model.configuration.application.registration.InitialAccessTokenType;
import io.gravitee.management.model.configuration.application.registration.NewClientRegistrationProviderEntity;
import io.gravitee.management.model.configuration.application.registration.UpdateClientRegistrationProviderEntity;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.configuration.application.ClientRegistrationService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.impl.configuration.application.registration.ClientRegistrationProviderAlreadyExistsException;
import io.gravitee.management.service.impl.configuration.application.registration.ClientRegistrationProviderNotFoundException;
import io.gravitee.management.service.impl.configuration.application.registration.EmptyInitialAccessTokenException;
import io.gravitee.management.service.impl.configuration.application.registration.InvalidClientRegistrationProviderException;
import io.gravitee.management.service.impl.configuration.application.registration.InvalidRenewClientSecretException;
import io.gravitee.management.service.impl.configuration.application.registration.MissingDynamicClientRegistrationProviderException;
import io.gravitee.management.service.impl.configuration.application.registration.RegisteredClientNotUpdatableException;
import io.gravitee.management.service.impl.configuration.application.registration.client.DiscoveryBasedDynamicClientRegistrationProviderClient;
import io.gravitee.management.service.impl.configuration.application.registration.client.DynamicClientRegistrationProviderClient;
import io.gravitee.management.service.impl.configuration.application.registration.client.register.ClientRegistrationRequest;
import io.gravitee.management.service.impl.configuration.application.registration.client.register.ClientRegistrationResponse;
import io.gravitee.management.service.impl.configuration.application.registration.client.token.ClientCredentialsInitialAccessTokenProvider;
import io.gravitee.management.service.impl.configuration.application.registration.client.token.InitialAccessTokenProvider;
import io.gravitee.management.service.impl.configuration.application.registration.client.token.PlainInitialAccessTokenProvider;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ClientRegistrationProviderRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.ClientRegistrationProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClientRegistrationServiceImpl
extends AbstractService
implements ClientRegistrationService {
    private final Logger LOGGER = LoggerFactory.getLogger(ClientRegistrationServiceImpl.class);
    @Autowired
    private ClientRegistrationProviderRepository clientRegistrationProviderRepository;
    @Autowired
    private AuditService auditService;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Cache<String, DynamicClientRegistrationProviderClient> clients = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    @Override
    public Set<ClientRegistrationProviderEntity> findAll() {
        try {
            return this.clientRegistrationProviderRepository.findAll().stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to retrieve client registration providers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve client registration providers", ex);
        }
    }

    @Override
    public ClientRegistrationProviderEntity create(NewClientRegistrationProviderEntity newClientRegistrationProvider) {
        try {
            this.LOGGER.debug("Create client registration provider {}", (Object)newClientRegistrationProvider);
            Set<ClientRegistrationProviderEntity> clientRegistrationProviders = this.findAll();
            if (clientRegistrationProviders.size() == 1) {
                throw new IllegalStateException("Until now, supports only a single client registration provider. Please update the existing one: " + clientRegistrationProviders.iterator().next().getName());
            }
            Optional optClientRegistrationProvider = this.clientRegistrationProviderRepository.findById((Object)IdGenerator.generate((String)newClientRegistrationProvider.getName()));
            if (optClientRegistrationProvider.isPresent()) {
                throw new ClientRegistrationProviderAlreadyExistsException(newClientRegistrationProvider.getName());
            }
            if (newClientRegistrationProvider.getInitialAccessTokenType() == InitialAccessTokenType.INITIAL_ACCESS_TOKEN && (newClientRegistrationProvider.getInitialAccessToken() == null || newClientRegistrationProvider.getInitialAccessToken().isEmpty())) {
                throw new EmptyInitialAccessTokenException();
            }
            ClientRegistrationProvider clientRegistrationProvider = this.convert(newClientRegistrationProvider);
            this.renewClientSecretSupport(clientRegistrationProvider);
            clientRegistrationProvider.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
            DynamicClientRegistrationProviderClient registrationProviderClient = this.getDCRClient(true, this.convert(clientRegistrationProvider));
            registrationProviderClient.getInitialAccessToken();
            this.LOGGER.debug("Found a DCR Client for provider: {}", (Object)clientRegistrationProvider.getName(), (Object)registrationProviderClient);
            clientRegistrationProvider.setCreatedAt(new Date());
            clientRegistrationProvider.setUpdatedAt(clientRegistrationProvider.getCreatedAt());
            ClientRegistrationProvider createdClientRegistrationProvider = (ClientRegistrationProvider)this.clientRegistrationProviderRepository.create((Object)clientRegistrationProvider);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.CLIENT_REGISTRATION_PROVIDER, createdClientRegistrationProvider.getId()), (Audit.AuditEvent)ClientRegistrationProvider.AuditEvent.CLIENT_REGISTRATION_PROVIDER_CREATED, createdClientRegistrationProvider.getUpdatedAt(), null, createdClientRegistrationProvider);
            return this.convert(createdClientRegistrationProvider);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create client registration provider {}", (Object)newClientRegistrationProvider, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create " + newClientRegistrationProvider, ex);
        }
    }

    @Override
    public ClientRegistrationProviderEntity update(String id, UpdateClientRegistrationProviderEntity updateClientRegistrationProvider) {
        try {
            this.LOGGER.debug("Update client registration provider {}", (Object)updateClientRegistrationProvider);
            Optional optClientRegistrationProvider = this.clientRegistrationProviderRepository.findById((Object)id);
            if (!optClientRegistrationProvider.isPresent()) {
                throw new ClientRegistrationProviderNotFoundException(updateClientRegistrationProvider.getName());
            }
            if (updateClientRegistrationProvider.getInitialAccessTokenType() == InitialAccessTokenType.INITIAL_ACCESS_TOKEN && (updateClientRegistrationProvider.getInitialAccessToken() == null || updateClientRegistrationProvider.getInitialAccessToken().isEmpty())) {
                throw new EmptyInitialAccessTokenException();
            }
            ClientRegistrationProvider clientRegistrationProvider = this.convert(updateClientRegistrationProvider);
            this.renewClientSecretSupport(clientRegistrationProvider);
            clientRegistrationProvider.setId(id);
            DynamicClientRegistrationProviderClient registrationProviderClient = this.getDCRClient(true, this.convert(clientRegistrationProvider));
            registrationProviderClient.getInitialAccessToken();
            this.LOGGER.debug("Found a DCR Client for provider: {}", (Object)clientRegistrationProvider.getName(), (Object)registrationProviderClient);
            ClientRegistrationProvider clientProviderToUpdate = (ClientRegistrationProvider)optClientRegistrationProvider.get();
            clientRegistrationProvider.setId(id);
            clientRegistrationProvider.setCreatedAt(clientProviderToUpdate.getCreatedAt());
            clientRegistrationProvider.setUpdatedAt(new Date());
            ClientRegistrationProvider updatedClientRegistrationProvider = (ClientRegistrationProvider)this.clientRegistrationProviderRepository.update((Object)clientRegistrationProvider);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.CLIENT_REGISTRATION_PROVIDER, id), (Audit.AuditEvent)ClientRegistrationProvider.AuditEvent.CLIENT_REGISTRATION_PROVIDER_CREATED, clientRegistrationProvider.getUpdatedAt(), clientProviderToUpdate, updatedClientRegistrationProvider);
            return this.convert(updatedClientRegistrationProvider);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update client registration provider {}", (Object)updateClientRegistrationProvider, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update " + updateClientRegistrationProvider, ex);
        }
    }

    private void renewClientSecretSupport(ClientRegistrationProvider provider) {
        if (provider.isRenewClientSecretSupport()) {
            HttpMethod method = HttpMethod.valueOf((String)provider.getRenewClientSecretMethod().toUpperCase());
            if (method != HttpMethod.POST && method != HttpMethod.PUT && method != HttpMethod.PATCH) {
                throw new InvalidRenewClientSecretException();
            }
            if (provider.getRenewClientSecretEndpoint() == null || !provider.getRenewClientSecretEndpoint().startsWith("http://") && !provider.getRenewClientSecretEndpoint().startsWith("https://")) {
                throw new InvalidRenewClientSecretException();
            }
        }
    }

    @Override
    public ClientRegistrationProviderEntity findById(String id) {
        try {
            this.LOGGER.debug("Find client registration provider by ID: {}", (Object)id);
            Optional clientRegistrationProvider = this.clientRegistrationProviderRepository.findById((Object)id);
            if (clientRegistrationProvider.isPresent()) {
                return this.convert((ClientRegistrationProvider)clientRegistrationProvider.get());
            }
            throw new ClientRegistrationProviderNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find a client registration provider using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a client registration provider using its ID " + id, ex);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.LOGGER.debug("Delete client registration provider: {}", (Object)id);
            Optional clientRegistrationProvider = this.clientRegistrationProviderRepository.findById((Object)id);
            if (!clientRegistrationProvider.isPresent()) {
                throw new ClientRegistrationProviderNotFoundException(id);
            }
            this.clientRegistrationProviderRepository.delete((Object)id);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.CLIENT_REGISTRATION_PROVIDER, id), (Audit.AuditEvent)ClientRegistrationProvider.AuditEvent.CLIENT_REGISTRATION_PROVIDER_DELETED, new Date(), clientRegistrationProvider.get(), null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete a client registration provider using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a client registration provider using its ID " + id, ex);
        }
    }

    @Override
    public ClientRegistrationResponse register(NewApplicationEntity application) {
        Set<ClientRegistrationProviderEntity> providers = this.findAll();
        if (providers == null || providers.isEmpty()) {
            throw new MissingDynamicClientRegistrationProviderException();
        }
        ClientRegistrationProviderEntity provider = providers.iterator().next();
        DynamicClientRegistrationProviderClient registrationProviderClient = this.getDCRClient(false, provider);
        ClientRegistrationRequest clientRegistrationRequest = this.convert(application);
        if (provider.getSoftwareId() != null && !provider.getSoftwareId().isEmpty()) {
            clientRegistrationRequest.setSoftwareId(provider.getSoftwareId());
        }
        return registrationProviderClient.register(clientRegistrationRequest);
    }

    private DynamicClientRegistrationProviderClient getDCRClient(boolean forceRefresh, ClientRegistrationProviderEntity clientRegistrationProvider) {
        try {
            InitialAccessTokenProvider atProvider = clientRegistrationProvider.getInitialAccessTokenType() == InitialAccessTokenType.CLIENT_CREDENTIALS ? new ClientCredentialsInitialAccessTokenProvider(clientRegistrationProvider.getClientId(), clientRegistrationProvider.getClientSecret(), clientRegistrationProvider.getScopes()) : new PlainInitialAccessTokenProvider(clientRegistrationProvider.getInitialAccessToken());
            if (forceRefresh) {
                DiscoveryBasedDynamicClientRegistrationProviderClient registrationProviderClient = new DiscoveryBasedDynamicClientRegistrationProviderClient(clientRegistrationProvider.getDiscoveryEndpoint(), atProvider);
                if (clientRegistrationProvider.getId() != null) {
                    this.clients.put((Object)clientRegistrationProvider.getId(), (Object)registrationProviderClient);
                }
                return registrationProviderClient;
            }
            return (DynamicClientRegistrationProviderClient)this.clients.get((Object)clientRegistrationProvider.getId(), () -> new DiscoveryBasedDynamicClientRegistrationProviderClient(clientRegistrationProvider.getDiscoveryEndpoint(), atProvider));
        }
        catch (Exception ex) {
            this.LOGGER.error("Unexpected error while getting a dynamic client registration client", (Throwable)ex);
            throw new InvalidClientRegistrationProviderException();
        }
    }

    @Override
    public ClientRegistrationResponse update(String previousRegistrationResponse, UpdateApplicationEntity application) {
        try {
            ClientRegistrationResponse registrationResponse = (ClientRegistrationResponse)this.mapper.readValue(previousRegistrationResponse, ClientRegistrationResponse.class);
            if (registrationResponse.getRegistrationAccessToken() == null || registrationResponse.getRegistrationAccessToken().isEmpty() || registrationResponse.getRegistrationClientUri() == null || registrationResponse.getRegistrationClientUri().isEmpty()) {
                throw new RegisteredClientNotUpdatableException();
            }
            Set<ClientRegistrationProviderEntity> providers = this.findAll();
            if (providers == null || providers.isEmpty()) {
                throw new MissingDynamicClientRegistrationProviderException();
            }
            ClientRegistrationProviderEntity provider = providers.iterator().next();
            DynamicClientRegistrationProviderClient registrationProviderClient = this.getDCRClient(false, provider);
            ClientRegistrationRequest registrationRequest = (ClientRegistrationRequest)this.mapper.readValue(previousRegistrationResponse, ClientRegistrationRequest.class);
            registrationRequest.setSoftwareId(provider.getSoftwareId());
            return registrationProviderClient.update(registrationResponse.getRegistrationAccessToken(), registrationResponse.getRegistrationClientUri(), this.convert(registrationRequest, application), application.getSettings().getoAuthClient().getClientId());
        }
        catch (Exception ex) {
            this.LOGGER.error("Unexpected error while updating a client", (Throwable)ex);
            return null;
        }
    }

    @Override
    public ClientRegistrationResponse renewClientSecret(String previousRegistrationResponse) {
        try {
            ClientRegistrationResponse registrationResponse = (ClientRegistrationResponse)this.mapper.readValue(previousRegistrationResponse, ClientRegistrationResponse.class);
            if (registrationResponse.getRegistrationAccessToken() == null || registrationResponse.getRegistrationAccessToken().isEmpty() || registrationResponse.getRegistrationClientUri() == null || registrationResponse.getRegistrationClientUri().isEmpty()) {
                throw new RegisteredClientNotUpdatableException();
            }
            Set<ClientRegistrationProviderEntity> providers = this.findAll();
            if (providers == null || providers.isEmpty()) {
                throw new MissingDynamicClientRegistrationProviderException();
            }
            ClientRegistrationProviderEntity provider = providers.iterator().next();
            DynamicClientRegistrationProviderClient registrationProviderClient = this.getDCRClient(false, provider);
            String renewClientSecretEndpoint = provider.getRenewClientSecretEndpoint();
            TemplateEngine templateEngine = TemplateEngine.templateEngine();
            templateEngine.getTemplateContext().setVariable("client_id", (Object)registrationResponse.getClientId());
            if (registrationProviderClient instanceof DiscoveryBasedDynamicClientRegistrationProviderClient) {
                ((DiscoveryBasedDynamicClientRegistrationProviderClient)registrationProviderClient).getMetadata().forEach((s, o) -> templateEngine.getTemplateContext().setVariable(s, o));
            }
            return registrationProviderClient.renewClientSecret(provider.getRenewClientSecretMethod(), (String)templateEngine.getValue(renewClientSecretEndpoint, String.class), registrationResponse.getRegistrationAccessToken());
        }
        catch (IOException ioe) {
            this.LOGGER.error("Unexpected error while updating a client", (Throwable)ioe);
            return null;
        }
    }

    private ClientRegistrationRequest convert(ClientRegistrationRequest request, UpdateApplicationEntity application) {
        request.setClientName(application.getName());
        request.setApplicationType(application.getSettings().getoAuthClient().getApplicationType());
        request.setClientUri(application.getSettings().getoAuthClient().getClientUri());
        request.setGrantTypes(application.getSettings().getoAuthClient().getGrantTypes());
        request.setLogoUri(application.getSettings().getoAuthClient().getLogoUri());
        request.setRedirectUris(application.getSettings().getoAuthClient().getRedirectUris());
        request.setResponseTypes(application.getSettings().getoAuthClient().getResponseTypes());
        return request;
    }

    private ClientRegistrationRequest convert(NewApplicationEntity application) {
        ClientRegistrationRequest request = new ClientRegistrationRequest();
        request.setClientName(application.getName());
        request.setApplicationType(application.getSettings().getoAuthClient().getApplicationType());
        request.setClientUri(application.getSettings().getoAuthClient().getClientUri());
        request.setGrantTypes(application.getSettings().getoAuthClient().getGrantTypes());
        request.setLogoUri(application.getSettings().getoAuthClient().getLogoUri());
        request.setRedirectUris(application.getSettings().getoAuthClient().getRedirectUris());
        request.setResponseTypes(application.getSettings().getoAuthClient().getResponseTypes());
        return request;
    }

    private ClientRegistrationProviderEntity convert(ClientRegistrationProvider clientRegistrationProvider) {
        ClientRegistrationProviderEntity entity = new ClientRegistrationProviderEntity();
        entity.setId(clientRegistrationProvider.getId());
        entity.setName(clientRegistrationProvider.getName());
        entity.setDescription(clientRegistrationProvider.getDescription());
        entity.setDiscoveryEndpoint(clientRegistrationProvider.getDiscoveryEndpoint());
        entity.setRenewClientSecretSupport(clientRegistrationProvider.isRenewClientSecretSupport());
        entity.setRenewClientSecretMethod(clientRegistrationProvider.getRenewClientSecretMethod());
        entity.setRenewClientSecretEndpoint(clientRegistrationProvider.getRenewClientSecretEndpoint());
        entity.setSoftwareId(clientRegistrationProvider.getSoftwareId());
        if (clientRegistrationProvider.getInitialAccessTokenType() == null || clientRegistrationProvider.getInitialAccessTokenType() == ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS) {
            entity.setInitialAccessTokenType(InitialAccessTokenType.CLIENT_CREDENTIALS);
            entity.setClientId(clientRegistrationProvider.getClientId());
            entity.setClientSecret(clientRegistrationProvider.getClientSecret());
            entity.setScopes(clientRegistrationProvider.getScopes());
        } else {
            entity.setInitialAccessTokenType(InitialAccessTokenType.INITIAL_ACCESS_TOKEN);
            entity.setInitialAccessToken(clientRegistrationProvider.getInitialAccessToken());
        }
        entity.setCreatedAt(clientRegistrationProvider.getCreatedAt());
        entity.setUpdatedAt(clientRegistrationProvider.getUpdatedAt());
        return entity;
    }

    private ClientRegistrationProvider convert(NewClientRegistrationProviderEntity newClientRegistrationProvider) {
        ClientRegistrationProvider provider = new ClientRegistrationProvider();
        provider.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        provider.setName(newClientRegistrationProvider.getName());
        provider.setDescription(newClientRegistrationProvider.getDescription());
        provider.setDiscoveryEndpoint(newClientRegistrationProvider.getDiscoveryEndpoint());
        provider.setRenewClientSecretSupport(newClientRegistrationProvider.isRenewClientSecretSupport());
        provider.setRenewClientSecretMethod(newClientRegistrationProvider.getRenewClientSecretMethod());
        provider.setRenewClientSecretEndpoint(newClientRegistrationProvider.getRenewClientSecretEndpoint());
        provider.setSoftwareId(newClientRegistrationProvider.getSoftwareId());
        if (newClientRegistrationProvider.getInitialAccessTokenType() == InitialAccessTokenType.CLIENT_CREDENTIALS) {
            provider.setInitialAccessTokenType(ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS);
            provider.setClientId(newClientRegistrationProvider.getClientId());
            provider.setClientSecret(newClientRegistrationProvider.getClientSecret());
            provider.setScopes(newClientRegistrationProvider.getScopes());
        } else {
            provider.setInitialAccessTokenType(ClientRegistrationProvider.InitialAccessTokenType.INITIAL_ACCESS_TOKEN);
            provider.setInitialAccessToken(newClientRegistrationProvider.getInitialAccessToken());
        }
        return provider;
    }

    private ClientRegistrationProvider convert(UpdateClientRegistrationProviderEntity updateClientRegistrationProvider) {
        ClientRegistrationProvider provider = new ClientRegistrationProvider();
        provider.setName(updateClientRegistrationProvider.getName());
        provider.setDescription(updateClientRegistrationProvider.getDescription());
        provider.setDiscoveryEndpoint(updateClientRegistrationProvider.getDiscoveryEndpoint());
        provider.setRenewClientSecretSupport(updateClientRegistrationProvider.isRenewClientSecretSupport());
        provider.setRenewClientSecretMethod(updateClientRegistrationProvider.getRenewClientSecretMethod());
        provider.setRenewClientSecretEndpoint(updateClientRegistrationProvider.getRenewClientSecretEndpoint());
        provider.setSoftwareId(updateClientRegistrationProvider.getSoftwareId());
        if (updateClientRegistrationProvider.getInitialAccessTokenType() == InitialAccessTokenType.CLIENT_CREDENTIALS) {
            provider.setInitialAccessTokenType(ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS);
            provider.setClientId(updateClientRegistrationProvider.getClientId());
            provider.setClientSecret(updateClientRegistrationProvider.getClientSecret());
            provider.setScopes(updateClientRegistrationProvider.getScopes());
        } else {
            provider.setInitialAccessTokenType(ClientRegistrationProvider.InitialAccessTokenType.INITIAL_ACCESS_TOKEN);
            provider.setInitialAccessToken(updateClientRegistrationProvider.getInitialAccessToken());
        }
        return provider;
    }
}

