/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.service.VirtualHostService;
import io.gravitee.management.service.exceptions.ApiContextPathAlreadyExistsException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualHostServiceImpl
extends TransactionalService
implements VirtualHostService {
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private static final char URI_PATH_SEPARATOR_CHAR = '/';
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualHostServiceImpl.class);
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public void validate(Collection<VirtualHost> virtualHosts, String apiId) {
        virtualHosts = virtualHosts.stream().map(this::sanitize).collect(Collectors.toList());
        Set apis = this.apiRepository.search(null).stream().filter(api -> !api.getId().equals(apiId)).map(this::convert).collect(Collectors.toSet());
        Map registeredVirtualHosts = apis.stream().flatMap(new Function<ApiEntity, Stream<VirtualHost>>(){

            @Override
            public Stream<VirtualHost> apply(ApiEntity api) {
                return api.getProxy().getVirtualHosts().stream().filter(virtualHost -> virtualHost.getHost() != null && !virtualHost.getHost().isEmpty());
            }
        }).collect(Collectors.groupingBy(VirtualHost::getHost, Collectors.mapping(VirtualHost::getPath, Collectors.toList())));
        List registeredContextPaths = apis.stream().flatMap(new Function<ApiEntity, Stream<String>>(){

            @Override
            public Stream<String> apply(ApiEntity api) {
                return api.getProxy().getVirtualHosts().stream().filter(virtualHost -> virtualHost.getHost() == null).map(VirtualHost::getPath);
            }
        }).collect(Collectors.toList());
        if (!registeredVirtualHosts.isEmpty()) {
            virtualHosts.stream().filter(virtualHost -> virtualHost.getHost() != null && !virtualHost.getHost().isEmpty()).forEach(virtualHost -> this.compare(virtualHost.getPath(), (List)registeredVirtualHosts.get(virtualHost.getHost())));
        }
        if (!registeredContextPaths.isEmpty()) {
            virtualHosts.stream().filter(virtualHost -> virtualHost.getHost() == null).forEach(virtualHost -> this.compare(virtualHost.getPath(), registeredContextPaths));
        }
    }

    private VirtualHost sanitize(VirtualHost virtualHost) {
        String path = virtualHost.getPath();
        if (path == null || path.isEmpty()) {
            path = URI_PATH_SEPARATOR;
        }
        if (path.lastIndexOf(47) != path.length() - 1) {
            path = path + URI_PATH_SEPARATOR;
        }
        path = DUPLICATE_SLASH_REMOVER.matcher(path).replaceAll(URI_PATH_SEPARATOR);
        return new VirtualHost(virtualHost.getHost(), path);
    }

    private void compare(String path, List<String> paths) {
        boolean match;
        boolean bl = match = paths != null && paths.stream().anyMatch(registeredPath -> path.startsWith((String)registeredPath) || registeredPath.startsWith(path));
        if (match) {
            throw new ApiContextPathAlreadyExistsException(path);
        }
    }

    private ApiEntity convert(Api api) {
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        if (api.getDefinition() != null) {
            try {
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.getProxy().setVirtualHosts(apiEntity.getProxy().getVirtualHosts().stream().map(this::sanitize).collect(Collectors.toList()));
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while getting API definition", (Throwable)ioe);
            }
        }
        return apiEntity;
    }
}

