/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.management.model.InlinePictureEntity;
import io.gravitee.management.model.NewViewEntity;
import io.gravitee.management.model.UpdateViewEntity;
import io.gravitee.management.model.ViewEntity;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.ViewService;
import io.gravitee.management.service.exceptions.DuplicateViewNameException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.ViewNotFoundException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ViewRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.View;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ViewServiceImpl
extends TransactionalService
implements ViewService {
    private final Logger LOGGER = LoggerFactory.getLogger(ViewServiceImpl.class);
    @Value(value="${configuration.default-icon:${gravitee.home}/assets/default_api_logo.png}")
    private String defaultIcon;
    @Autowired
    private ViewRepository viewRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private AuditService auditService;

    @Override
    public List<ViewEntity> findAll() {
        try {
            this.LOGGER.debug("Find all views");
            return this.viewRepository.findAll().stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all views", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all views", ex);
        }
    }

    @Override
    public ViewEntity findById(String id) {
        try {
            this.LOGGER.debug("Find view by id : {}", (Object)id);
            Optional view = this.viewRepository.findById((Object)id);
            if (!view.isPresent()) {
                view = this.viewRepository.findByKey(id);
            }
            if (view.isPresent()) {
                return this.convert((View)view.get());
            }
            throw new ViewNotFoundException(id);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find a view using its id: " + id;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public ViewEntity create(NewViewEntity viewEntity) {
        Optional<ViewEntity> optionalView = this.findAll().stream().filter(v -> v.getName().equals(viewEntity.getName())).findAny();
        if (optionalView.isPresent()) {
            throw new DuplicateViewNameException(optionalView.get().getName());
        }
        try {
            View view = this.convert(viewEntity);
            ViewEntity createdView = this.convert((View)this.viewRepository.create((Object)view));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.VIEW, view.getId()), (Audit.AuditEvent)View.AuditEvent.VIEW_CREATED, new Date(), null, view);
            return createdView;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create view {}", (Object)viewEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create view " + viewEntity.getName(), ex);
        }
    }

    @Override
    public ViewEntity update(String viewId, UpdateViewEntity viewEntity) {
        try {
            this.LOGGER.debug("Update View {}", (Object)viewId);
            Optional optViewToUpdate = this.viewRepository.findById((Object)viewId);
            if (!optViewToUpdate.isPresent()) {
                throw new ViewNotFoundException(viewId);
            }
            View view = this.convert(viewEntity);
            if (viewEntity.getPicture() == null && viewEntity.getPictureUrl() != null && viewEntity.getPictureUrl().indexOf("?hash") > 0) {
                view.setPicture(((View)optViewToUpdate.get()).getPicture());
            }
            ViewEntity updatedView = this.convert((View)this.viewRepository.update((Object)view));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.VIEW, view.getId()), (Audit.AuditEvent)View.AuditEvent.VIEW_UPDATED, new Date(), optViewToUpdate.get(), view);
            return updatedView;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update view {}", (Object)viewEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update view " + viewEntity.getName(), ex);
        }
    }

    @Override
    public List<ViewEntity> update(List<UpdateViewEntity> viewEntities) {
        ArrayList<ViewEntity> savedViews = new ArrayList<ViewEntity>(viewEntities.size());
        viewEntities.forEach(viewEntity -> {
            try {
                View view = this.convert((UpdateViewEntity)viewEntity);
                Optional viewOptional = this.viewRepository.findById((Object)view.getId());
                if (viewOptional.isPresent()) {
                    if (view.getPicture() == null) {
                        view.setPicture(((View)viewOptional.get()).getPicture());
                    }
                    savedViews.add(this.convert((View)this.viewRepository.update((Object)view)));
                    this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.VIEW, view.getId()), (Audit.AuditEvent)View.AuditEvent.VIEW_UPDATED, new Date(), viewOptional.get(), view);
                }
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to update view {}", (Object)viewEntity.getName(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update view " + viewEntity.getName(), ex);
            }
        });
        return savedViews;
    }

    @Override
    public void delete(String viewId) {
        if ("all".equals(viewId)) {
            this.LOGGER.error("Delete the default view is forbidden");
            throw new TechnicalManagementException("Delete the default view is forbidden");
        }
        try {
            Optional viewOptional = this.viewRepository.findById((Object)viewId);
            if (viewOptional.isPresent()) {
                this.viewRepository.delete((Object)viewId);
                this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.VIEW, viewId), (Audit.AuditEvent)View.AuditEvent.VIEW_DELETED, new Date(), null, viewOptional.get());
                this.apiService.deleteViewFromAPIs(viewId);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete view {}", (Object)viewId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete view " + viewId, ex);
        }
    }

    @Override
    public void createDefaultView() {
        View view = new View();
        view.setId("all");
        view.setName("All");
        view.setKey(IdGenerator.generate((String)view.getName()));
        view.setDefaultView(true);
        view.setOrder(0);
        view.setCreatedAt(new Date());
        view.setUpdatedAt(view.getCreatedAt());
        try {
            this.viewRepository.create((Object)view);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create view {}", (Object)view.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create view " + view.getName(), ex);
        }
    }

    @Override
    public InlinePictureEntity getPicture(String viewId) {
        ViewEntity viewEntity = this.findById(viewId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (viewEntity.getPicture() == null) {
            imageEntity.setType("image/png");
            imageEntity.setContent(this.getDefaultPicture());
        } else {
            String[] parts = viewEntity.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = viewEntity.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    private byte[] getDefaultPicture() {
        try {
            return IOUtils.toByteArray((InputStream)new FileInputStream(this.defaultIcon));
        }
        catch (IOException ioe) {
            this.LOGGER.error("Default icon for View does not exist", (Throwable)ioe);
            return null;
        }
    }

    private View convert(NewViewEntity viewEntity) {
        View view = new View();
        view.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        view.setKey(IdGenerator.generate((String)viewEntity.getName()));
        view.setName(viewEntity.getName());
        view.setDescription(viewEntity.getDescription());
        view.setOrder(viewEntity.getOrder());
        view.setHidden(viewEntity.isHidden());
        view.setHighlightApi(viewEntity.getHighlightApi());
        view.setPicture(viewEntity.getPicture());
        return view;
    }

    private View convert(UpdateViewEntity viewEntity) {
        View view = new View();
        view.setId(viewEntity.getId());
        view.setKey(IdGenerator.generate((String)viewEntity.getName()));
        view.setName(viewEntity.getName());
        view.setDescription(viewEntity.getDescription());
        view.setDefaultView(viewEntity.isDefaultView());
        view.setOrder(viewEntity.getOrder());
        view.setHidden(viewEntity.isHidden());
        view.setHighlightApi(viewEntity.getHighlightApi());
        view.setPicture(viewEntity.getPicture());
        return view;
    }

    private ViewEntity convert(View view) {
        ViewEntity viewEntity = new ViewEntity();
        viewEntity.setId(view.getId());
        viewEntity.setKey(view.getKey());
        viewEntity.setName(view.getName());
        viewEntity.setDescription(view.getDescription());
        viewEntity.setDefaultView(view.isDefaultView());
        viewEntity.setOrder(view.getOrder());
        viewEntity.setHidden(view.isHidden());
        viewEntity.setHighlightApi(view.getHighlightApi());
        viewEntity.setPicture(view.getPicture());
        viewEntity.setUpdatedAt(view.getUpdatedAt());
        viewEntity.setCreatedAt(view.getCreatedAt());
        return viewEntity;
    }
}

