/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.SubscriptionEntity;
import io.gravitee.management.model.SubscriptionStatus;
import io.gravitee.management.model.TaskEntity;
import io.gravitee.management.model.TaskType;
import io.gravitee.management.model.WorkflowReferenceType;
import io.gravitee.management.model.WorkflowState;
import io.gravitee.management.model.WorkflowType;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.pagedresult.Metadata;
import io.gravitee.management.model.permissions.ApiPermission;
import io.gravitee.management.model.subscription.SubscriptionQuery;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.SubscriptionService;
import io.gravitee.management.service.TaskService;
import io.gravitee.management.service.WorkflowService;
import io.gravitee.management.service.exceptions.RoleNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UnauthorizedAccessException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.repository.management.model.Workflow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskServiceImpl
extends AbstractService
implements TaskService {
    private final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    private ApiService apiService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PlanService planService;
    @Autowired
    private WorkflowService workflowService;

    @Override
    public List<TaskEntity> findAll(String userId) {
        if (userId == null) {
            throw new UnauthorizedAccessException();
        }
        try {
            ArrayList<TaskEntity> tasks;
            Set<String> apiIds = this.getApisForAPermission(userId, ApiPermission.SUBSCRIPTION.getName());
            if (apiIds.isEmpty()) {
                tasks = new ArrayList();
            } else {
                SubscriptionQuery query = new SubscriptionQuery();
                query.setStatuses(Collections.singleton(SubscriptionStatus.PENDING));
                query.setApis(apiIds);
                tasks = this.subscriptionService.search(query).stream().map(this::convert).collect(Collectors.toList());
            }
            apiIds = this.getApisForAPermission(userId, ApiPermission.REVIEWS.getName());
            if (!apiIds.isEmpty()) {
                apiIds.forEach(apiId -> {
                    List<Workflow> workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, (String)apiId, WorkflowType.REVIEW);
                    if (workflows != null && !workflows.isEmpty()) {
                        Workflow currentWorkflow = workflows.get(0);
                        if (WorkflowState.IN_REVIEW.name().equals(currentWorkflow.getState())) {
                            tasks.add(this.convert(currentWorkflow));
                        }
                    }
                });
            }
            if (!(apiIds = this.getApisForAPermission(userId, ApiPermission.DEFINITION.getName())).isEmpty()) {
                apiIds.forEach(apiId -> {
                    List<Workflow> workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, (String)apiId, WorkflowType.REVIEW);
                    if (workflows != null && !workflows.isEmpty()) {
                        Workflow currentWorkflow = workflows.get(0);
                        if (WorkflowState.REQUEST_FOR_CHANGES.name().equals(currentWorkflow.getState())) {
                            tasks.add(this.convert(currentWorkflow));
                        }
                    }
                });
            }
            return tasks;
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error retreiving user tasks {}", (Object)e.getMessage());
            throw new TechnicalManagementException("Error retreiving user tasks", e);
        }
    }

    private Set<String> getApisForAPermission(String userId, String permission) throws TechnicalException {
        Set memberships = this.membershipRepository.findByUserAndReferenceType(userId, MembershipReferenceType.GROUP);
        memberships.addAll(this.membershipRepository.findByUserAndReferenceType(userId, MembershipReferenceType.API));
        HashMap<String, RoleEntity> roleNameToEntity = new HashMap<String, RoleEntity>();
        HashSet<String> apiIds = new HashSet<String>();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Membership membership : memberships) {
            char[] rights;
            String roleName = (String)membership.getRoles().get(RoleScope.API.getId());
            if (roleName == null) continue;
            RoleEntity roleEntity = (RoleEntity)roleNameToEntity.get(roleName);
            if (roleEntity == null) {
                try {
                    roleEntity = this.roleService.findById(RoleScope.API, roleName);
                    roleNameToEntity.put(roleName, roleEntity);
                }
                catch (RoleNotFoundException rnfe) {
                    this.LOGGER.debug("Role not found", (Throwable)rnfe);
                    continue;
                }
            }
            if ((rights = (char[])roleEntity.getPermissions().get(permission)) == null) continue;
            block7: for (char c : rights) {
                if (c != 'U') continue;
                switch (membership.getReferenceType()) {
                    case GROUP: {
                        groupIds.add(membership.getReferenceId());
                        continue block7;
                    }
                    case API: {
                        apiIds.add(membership.getReferenceId());
                        continue block7;
                    }
                }
            }
        }
        if (!groupIds.isEmpty()) {
            apiIds.addAll(this.apiRepository.search(new ApiCriteria.Builder().groups(groupIds.toArray(new String[0])).build()).stream().map(Api::getId).collect(Collectors.toSet()));
        }
        return apiIds;
    }

    @Override
    public Metadata getMetadata(List<TaskEntity> tasks) {
        Metadata metadata = new Metadata();
        tasks.forEach(task -> {
            Object data = task.getData();
            if (data instanceof SubscriptionEntity) {
                SubscriptionEntity subscription = (SubscriptionEntity)data;
                if (!metadata.containsKey(subscription.getApplication())) {
                    ApplicationEntity applicationEntity = this.applicationService.findById(subscription.getApplication());
                    metadata.put(subscription.getApplication(), "name", (Object)applicationEntity.getName());
                }
                if (!metadata.containsKey(subscription.getPlan())) {
                    PlanEntity planEntity = this.planService.findById(subscription.getPlan());
                    String apiId = (String)planEntity.getApis().iterator().next();
                    ApiEntity api = this.apiService.findById(apiId);
                    metadata.put(subscription.getPlan(), "name", (Object)planEntity.getName());
                    metadata.put(subscription.getPlan(), "api", (Object)apiId);
                    metadata.put(apiId, "name", (Object)api.getName());
                }
            } else if (data instanceof Workflow) {
                Workflow workflow = (Workflow)data;
                if (WorkflowReferenceType.API.name().equals(workflow.getReferenceType()) && !metadata.containsKey(workflow.getReferenceId())) {
                    ApiEntity api = this.apiService.findById(workflow.getReferenceId());
                    metadata.put(api.getId(), "name", (Object)api.getName());
                }
            }
        });
        return metadata;
    }

    private TaskEntity convert(SubscriptionEntity subscription) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.SUBSCRIPTION_APPROVAL);
            taskEntity.setCreatedAt(subscription.getCreatedAt());
            taskEntity.setData((Object)subscription);
        }
        catch (Exception e) {
            this.LOGGER.error("Error converting subscription {} to a Task", (Object)subscription.getId());
            throw new TechnicalManagementException("Error converting subscription " + subscription.getId() + " to a Task", e);
        }
        return taskEntity;
    }

    private TaskEntity convert(ApiEntity api) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.valueOf((String)api.getWorkflowState().name()));
            taskEntity.setCreatedAt(api.getCreatedAt());
            taskEntity.setData((Object)api);
        }
        catch (Exception e) {
            String error = "Error converting api " + api.getId() + " to a Task";
            this.LOGGER.error(error);
            throw new TechnicalManagementException(error, e);
        }
        return taskEntity;
    }

    private TaskEntity convert(Workflow workflow) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.valueOf((String)workflow.getState()));
            taskEntity.setCreatedAt(workflow.getCreatedAt());
            taskEntity.setData((Object)workflow);
        }
        catch (Exception e) {
            String error = "Error converting workflow " + workflow.getId() + " to a Task";
            this.LOGGER.error(error);
            throw new TechnicalManagementException(error, e);
        }
        return taskEntity;
    }
}

