/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ImportSwaggerDescriptorEntity;
import io.gravitee.management.model.api.SwaggerApiEntity;
import io.gravitee.management.service.SwaggerService;
import io.gravitee.management.service.exceptions.SwaggerDescriptorException;
import io.gravitee.management.service.impl.swagger.converter.api.OAIToAPIConverter;
import io.gravitee.management.service.impl.swagger.parser.OAIParser;
import io.gravitee.management.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.management.service.impl.swagger.transformer.SwaggerTransformer;
import io.gravitee.management.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.management.service.spring.ImportConfiguration;
import io.gravitee.management.service.swagger.OAIDescriptor;
import io.gravitee.management.service.swagger.SwaggerDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SwaggerServiceImpl
implements SwaggerService {
    private final Logger logger = LoggerFactory.getLogger(SwaggerServiceImpl.class);
    @Value(value="${swagger.scheme:https}")
    private String defaultScheme;
    @Autowired
    private PolicyOperationVisitorManager policyOperationVisitorManager;
    @Autowired
    private ImportConfiguration importConfiguration;

    @Override
    public SwaggerApiEntity createAPI(ImportSwaggerDescriptorEntity swaggerDescriptor) {
        SwaggerDescriptor descriptor = this.parse(swaggerDescriptor.getPayload());
        if (descriptor != null) {
            List visitors = this.policyOperationVisitorManager.getPolicyVisitors().stream().filter(operationVisitor -> swaggerDescriptor.getWithPolicies() != null && swaggerDescriptor.getWithPolicies().contains(operationVisitor.getId())).map(operationVisitor -> this.policyOperationVisitorManager.getOAIOperationVisitor(operationVisitor.getId())).collect(Collectors.toList());
            return new OAIToAPIConverter(visitors).convert((OAIDescriptor)descriptor);
        }
        throw new SwaggerDescriptorException();
    }

    @Override
    public <Y, T extends SwaggerDescriptor<Y>> void transform(T descriptor, Collection<SwaggerTransformer<T>> transformers) {
        if (transformers != null) {
            transformers.forEach(transformer -> transformer.transform(descriptor));
        }
    }

    @Override
    public SwaggerDescriptor parse(String content) {
        OAIDescriptor oaiDescriptor;
        if (this.isUrl(content)) {
            UrlSanitizerUtils.checkAllowed(content, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
        }
        if ((oaiDescriptor = new OAIParser().parse(content)) == null || oaiDescriptor.getSpecification() == null) {
            throw new SwaggerDescriptorException();
        }
        return oaiDescriptor;
    }

    private boolean isUrl(String content) {
        try {
            new URL(content);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

