/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.management.model.ApiKeyEntity;
import io.gravitee.management.model.ApiModelEntity;
import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.NewSubscriptionEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.PlanSecurityType;
import io.gravitee.management.model.PlanStatus;
import io.gravitee.management.model.PlanValidationType;
import io.gravitee.management.model.PrimaryOwnerEntity;
import io.gravitee.management.model.ProcessSubscriptionEntity;
import io.gravitee.management.model.SubscriptionEntity;
import io.gravitee.management.model.SubscriptionStatus;
import io.gravitee.management.model.TransferSubscriptionEntity;
import io.gravitee.management.model.UpdateSubscriptionEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.application.ApplicationListItem;
import io.gravitee.management.model.common.Pageable;
import io.gravitee.management.model.pagedresult.Metadata;
import io.gravitee.management.model.subscription.SubscriptionQuery;
import io.gravitee.management.service.ApiKeyService;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.GroupService;
import io.gravitee.management.service.NotifierService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.SubscriptionService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.exceptions.ApiKeyNotFoundException;
import io.gravitee.management.service.exceptions.ApplicationArchivedException;
import io.gravitee.management.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.management.service.exceptions.PlanAlreadySubscribedException;
import io.gravitee.management.service.exceptions.PlanNotSubscribableException;
import io.gravitee.management.service.exceptions.PlanNotYetPublishedException;
import io.gravitee.management.service.exceptions.PlanRestrictedException;
import io.gravitee.management.service.exceptions.SubscriptionAlreadyProcessedException;
import io.gravitee.management.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.management.service.exceptions.SubscriptionNotFoundException;
import io.gravitee.management.service.exceptions.SubscriptionNotPausableException;
import io.gravitee.management.service.exceptions.SubscriptionNotPausedException;
import io.gravitee.management.service.exceptions.SubscriptionNotUpdatableException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.TransferNotAllowedException;
import io.gravitee.management.service.exceptions.UserNotFoundException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.notification.ApiHook;
import io.gravitee.management.service.notification.ApplicationHook;
import io.gravitee.management.service.notification.NotificationParamsBuilder;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Subscription;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionServiceImpl
extends AbstractService
implements SubscriptionService {
    private final Logger logger = LoggerFactory.getLogger(SubscriptionServiceImpl.class);
    private static final String SUBSCRIPTION_SYSTEM_VALIDATOR = "system";
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final char separator = ';';
    @Autowired
    private PlanService planService;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private AuditService auditService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private UserService userService;

    @Override
    public SubscriptionEntity findById(String subscription) {
        try {
            this.logger.debug("Find subscription by id : {}", (Object)subscription);
            Optional optSubscription = this.subscriptionRepository.findById((Object)subscription);
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(subscription);
            }
            return this.convert((Subscription)optSubscription.get());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a subscription using its ID: {}", (Object)subscription, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a subscription using its ID: %s", subscription), ex);
        }
    }

    @Override
    public Collection<SubscriptionEntity> findByApplicationAndPlan(String application, String plan) {
        this.logger.debug("Find subscriptions by application {} and plan {}", (Object)application, (Object)plan);
        SubscriptionQuery query = new SubscriptionQuery();
        if (plan != null) {
            query.setPlan(plan);
        }
        if (application != null && !application.trim().isEmpty()) {
            query.setApplication(application);
        } else if (this.isAuthenticated()) {
            Set<ApplicationListItem> applications = this.applicationService.findByUser(this.getAuthenticatedUsername());
            query.setApplications((Collection)applications.stream().map(ApplicationListItem::getId).collect(Collectors.toList()));
        }
        return this.search(query);
    }

    @Override
    public Collection<SubscriptionEntity> findByApi(String api) {
        this.logger.debug("Find subscriptions by api {}", (Object)api);
        SubscriptionQuery query = new SubscriptionQuery();
        query.setApi(api);
        return this.search(query);
    }

    @Override
    public Collection<SubscriptionEntity> findByPlan(String plan) {
        this.logger.debug("Find subscriptions by plan {}", (Object)plan);
        SubscriptionQuery query = new SubscriptionQuery();
        query.setPlan(plan);
        return this.search(query);
    }

    @Override
    public SubscriptionEntity create(NewSubscriptionEntity newSubscriptionEntity) {
        String plan = newSubscriptionEntity.getPlan();
        String application = newSubscriptionEntity.getApplication();
        try {
            String clientId;
            boolean userAuthorizedToAccessApiData;
            this.logger.debug("Create a new subscription for plan {} and application {}", (Object)plan, (Object)application);
            PlanEntity planEntity = this.planService.findById(plan);
            if (planEntity.getStatus() == PlanStatus.DEPRECATED) {
                throw new PlanNotSubscribableException(plan);
            }
            if (planEntity.getStatus() == PlanStatus.CLOSED) {
                throw new PlanAlreadyClosedException(plan);
            }
            if (planEntity.getStatus() == PlanStatus.STAGING) {
                throw new PlanNotYetPublishedException(plan);
            }
            if (planEntity.getSecurity() == PlanSecurityType.KEY_LESS) {
                throw new PlanNotSubscribableException("A key_less plan is not subscribable !");
            }
            if (!(planEntity.getExcludedGroups() == null || planEntity.getExcludedGroups().isEmpty() || (userAuthorizedToAccessApiData = this.groupService.isUserAuthorizedToAccessApiData(this.apiService.findById((String)planEntity.getApis().iterator().next()), planEntity.getExcludedGroups(), this.getAuthenticatedUsername())) || this.isAdmin())) {
                throw new PlanRestrictedException(plan);
            }
            ApplicationEntity applicationEntity = this.applicationService.findById(application);
            if (ApplicationStatus.ARCHIVED.name().equals(applicationEntity.getStatus())) {
                throw new ApplicationArchivedException(applicationEntity.getName());
            }
            List subscriptions = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().applications(Collections.singleton(application)).apis((Collection)planEntity.getApis()).build());
            if (!subscriptions.isEmpty()) {
                long count;
                Predicate<Subscription> onlyValidSubs = subscription -> subscription.getStatus() != Subscription.Status.REJECTED && subscription.getStatus() != Subscription.Status.CLOSED;
                long subscriptionCount = subscriptions.stream().filter(onlyValidSubs).filter(subscription -> subscription.getPlan().equals(plan)).count();
                if (subscriptionCount > 0L) {
                    throw new PlanAlreadySubscribedException(plan);
                }
                if ((planEntity.getSecurity() == PlanSecurityType.OAUTH2 || planEntity.getSecurity() == PlanSecurityType.JWT) && (count = subscriptions.stream().filter(onlyValidSubs).map(Subscription::getPlan).distinct().map(plan1 -> this.planService.findById((String)plan1)).filter(subPlan -> subPlan.getSecurity() == PlanSecurityType.OAUTH2 || subPlan.getSecurity() == PlanSecurityType.JWT).count()) > 0L) {
                    throw new PlanNotSubscribableException("An other OAuth2 or JWT plan is already subscribed by the same application.");
                }
            }
            if (ApplicationType.SIMPLE.name().equals(applicationEntity.getType())) {
                clientId = applicationEntity.getSettings() != null && applicationEntity.getSettings().getApp() != null ? applicationEntity.getSettings().getApp().getClientId() : null;
            } else {
                String string = clientId = applicationEntity.getSettings() != null && applicationEntity.getSettings().getoAuthClient() != null ? applicationEntity.getSettings().getoAuthClient().getClientId() : null;
            }
            if (!(planEntity.getSecurity() != PlanSecurityType.OAUTH2 && planEntity.getSecurity() != PlanSecurityType.JWT || clientId != null && !clientId.trim().isEmpty())) {
                throw new PlanNotSubscribableException("A client_id is required to subscribe to an OAuth2 or JWT plan.");
            }
            Subscription subscription2 = new Subscription();
            subscription2.setPlan(plan);
            subscription2.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
            subscription2.setApplication(application);
            subscription2.setCreatedAt(new Date());
            subscription2.setUpdatedAt(subscription2.getCreatedAt());
            subscription2.setStatus(Subscription.Status.PENDING);
            subscription2.setRequest(newSubscriptionEntity.getRequest());
            subscription2.setSubscribedBy(this.getAuthenticatedUser().getUsername());
            subscription2.setClientId(clientId);
            String apiId = (String)planEntity.getApis().iterator().next();
            subscription2.setApi(apiId);
            subscription2 = (Subscription)this.subscriptionRepository.create((Object)subscription2);
            this.createAudit(apiId, application, (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_CREATED, subscription2.getCreatedAt(), null, subscription2);
            ApiModelEntity api = this.apiService.findByIdForTemplates(apiId);
            PrimaryOwnerEntity apiOwner = api.getPrimaryOwner();
            String portalUrl = this.environment.getProperty("portalURL");
            String subscriptionsUrl = "";
            if (portalUrl != null) {
                if (portalUrl.endsWith("/")) {
                    portalUrl = portalUrl.substring(0, portalUrl.length() - 1);
                }
                subscriptionsUrl = portalUrl + "/#!/management/apis/" + api.getId() + "/subscriptions/" + subscription2.getId();
            }
            Map<String, Object> params = new NotificationParamsBuilder().api(api).plan(planEntity).application(applicationEntity).owner(apiOwner).subscription(this.convert(subscription2)).subscriptionsUrl(subscriptionsUrl).build();
            if (PlanValidationType.AUTO == planEntity.getValidation()) {
                ProcessSubscriptionEntity process = new ProcessSubscriptionEntity();
                process.setId(subscription2.getId());
                process.setAccepted(true);
                process.setStartingAt(new Date());
                return this.process(process, SUBSCRIPTION_SYSTEM_VALIDATOR);
            }
            this.notifierService.trigger(ApiHook.SUBSCRIPTION_NEW, apiId, params);
            this.notifierService.trigger(ApplicationHook.SUBSCRIPTION_NEW, application, params);
            return this.convert(subscription2);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to subscribe to the plan {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to subscribe to the plan %s", plan), ex);
        }
    }

    @Override
    public SubscriptionEntity update(UpdateSubscriptionEntity updateSubscription) {
        return this.update(updateSubscription, null);
    }

    @Override
    public SubscriptionEntity update(UpdateSubscriptionEntity updateSubscription, String clientId) {
        try {
            this.logger.debug("Update subscription {}", (Object)updateSubscription.getId());
            Optional optSubscription = this.subscriptionRepository.findById((Object)updateSubscription.getId());
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(updateSubscription.getId());
            }
            Subscription subscription = (Subscription)optSubscription.get();
            if (subscription.getStatus() == Subscription.Status.ACCEPTED) {
                Subscription previousSubscription = new Subscription(subscription);
                subscription.setUpdatedAt(new Date());
                subscription.setStartingAt(updateSubscription.getStartingAt());
                subscription.setEndingAt(updateSubscription.getEndingAt());
                if (clientId != null) {
                    subscription.setClientId(clientId);
                }
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                PlanEntity plan = this.planService.findById(subscription.getPlan());
                this.createAudit((String)plan.getApis().iterator().next(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
                Date endingAt = subscription.getEndingAt();
                if (plan.getSecurity() == PlanSecurityType.API_KEY && endingAt != null) {
                    List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscription.getId());
                    for (ApiKeyEntity apiKey : apiKeys) {
                        Date expireAt = apiKey.getExpireAt();
                        if (apiKey.isRevoked() || expireAt != null && expireAt.compareTo(endingAt) <= 0) continue;
                        apiKey.setExpireAt(endingAt);
                        this.apiKeyService.update(apiKey);
                    }
                }
                return this.convert(subscription);
            }
            throw new SubscriptionNotUpdatableException(updateSubscription.getId());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update subscription {}", (Object)updateSubscription.getId(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s", updateSubscription.getId()), ex);
        }
    }

    @Override
    public SubscriptionEntity process(ProcessSubscriptionEntity processSubscription, String userId) {
        try {
            this.logger.debug("Subscription {} processed by {}", (Object)processSubscription.getId(), (Object)userId);
            Optional optSubscription = this.subscriptionRepository.findById((Object)processSubscription.getId());
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(processSubscription.getId());
            }
            Subscription subscription = (Subscription)optSubscription.get();
            Subscription previousSubscription = new Subscription(subscription);
            if (subscription.getStatus() != Subscription.Status.PENDING) {
                throw new SubscriptionAlreadyProcessedException(subscription.getId());
            }
            PlanEntity planEntity = this.planService.findById(subscription.getPlan());
            if (planEntity.getStatus() == PlanStatus.CLOSED) {
                throw new PlanAlreadyClosedException(planEntity.getId());
            }
            subscription.setProcessedBy(userId);
            Date now = new Date();
            subscription.setProcessedAt(now);
            subscription.setUpdatedAt(now);
            if (processSubscription.isAccepted()) {
                subscription.setStatus(Subscription.Status.ACCEPTED);
                subscription.setStartingAt(processSubscription.getStartingAt() != null ? processSubscription.getStartingAt() : new Date());
                subscription.setEndingAt(processSubscription.getEndingAt());
                subscription.setReason(processSubscription.getReason());
            } else {
                subscription.setStatus(Subscription.Status.REJECTED);
                subscription.setReason(processSubscription.getReason());
                subscription.setClosedAt(new Date());
            }
            subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
            ApplicationEntity application = this.applicationService.findById(subscription.getApplication());
            PlanEntity plan = this.planService.findById(subscription.getPlan());
            String apiId = (String)plan.getApis().iterator().next();
            ApiModelEntity api = this.apiService.findByIdForTemplates(apiId);
            PrimaryOwnerEntity owner = application.getPrimaryOwner();
            this.createAudit(apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
            SubscriptionEntity subscriptionEntity = this.convert(subscription);
            Map<String, Object> params = new NotificationParamsBuilder().owner(owner).application(application).api(api).plan(plan).subscription(subscriptionEntity).build();
            if (subscription.getStatus() == Subscription.Status.ACCEPTED) {
                this.notifierService.trigger(ApiHook.SUBSCRIPTION_ACCEPTED, apiId, params);
                this.notifierService.trigger(ApplicationHook.SUBSCRIPTION_ACCEPTED, application.getId(), params);
                this.searchSubscriberEmail(subscriptionEntity).ifPresent(subscriberEmail -> {
                    if (!this.notifierService.hasEmailNotificationFor(ApplicationHook.SUBSCRIPTION_ACCEPTED, application.getId(), params, (String)subscriberEmail)) {
                        this.notifierService.triggerEmail(ApplicationHook.SUBSCRIPTION_ACCEPTED, apiId, params, (String)subscriberEmail);
                    }
                });
            } else {
                this.notifierService.trigger(ApiHook.SUBSCRIPTION_REJECTED, apiId, params);
                this.notifierService.trigger(ApplicationHook.SUBSCRIPTION_REJECTED, application.getId(), params);
                this.searchSubscriberEmail(subscriptionEntity).ifPresent(subscriberEmail -> {
                    if (!this.notifierService.hasEmailNotificationFor(ApplicationHook.SUBSCRIPTION_REJECTED, application.getId(), params, (String)subscriberEmail)) {
                        this.notifierService.triggerEmail(ApplicationHook.SUBSCRIPTION_REJECTED, apiId, params, (String)subscriberEmail);
                    }
                });
            }
            if (plan.getSecurity() == PlanSecurityType.API_KEY && subscription.getStatus() == Subscription.Status.ACCEPTED) {
                this.apiKeyService.generate(subscription.getId());
            }
            return subscriptionEntity;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to process subscription {} by {}", new Object[]{processSubscription.getId(), userId, ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to process subscription %s by %s", processSubscription.getId(), userId), ex);
        }
    }

    private Optional<String> searchSubscriberEmail(SubscriptionEntity subscriptionEntity) {
        try {
            UserEntity subscriber = this.userService.findById(subscriptionEntity.getSubscribedBy());
            return Optional.ofNullable(subscriber.getEmail());
        }
        catch (UserNotFoundException e) {
            this.logger.warn("Subscriber '{}' not found, unable to retrieve email", (Object)subscriptionEntity.getSubscribedBy());
            return Optional.empty();
        }
    }

    @Override
    public SubscriptionEntity close(String subscriptionId) {
        try {
            this.logger.debug("Close subscription {}", (Object)subscriptionId);
            Optional optSubscription = this.subscriptionRepository.findById((Object)subscriptionId);
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(subscriptionId);
            }
            Subscription subscription = (Subscription)optSubscription.get();
            switch (subscription.getStatus()) {
                case ACCEPTED: 
                case PAUSED: {
                    Subscription previousSubscription = new Subscription(subscription);
                    Date now = new Date();
                    subscription.setUpdatedAt(now);
                    subscription.setStatus(Subscription.Status.CLOSED);
                    subscription.setClosedAt(new Date());
                    subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                    ApplicationEntity application = this.applicationService.findById(subscription.getApplication());
                    PlanEntity plan = this.planService.findById(subscription.getPlan());
                    String apiId = (String)plan.getApis().iterator().next();
                    ApiModelEntity api = this.apiService.findByIdForTemplates(apiId);
                    PrimaryOwnerEntity owner = application.getPrimaryOwner();
                    Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(api).plan(plan).application(application).build();
                    this.notifierService.trigger(ApiHook.SUBSCRIPTION_CLOSED, apiId, params);
                    this.notifierService.trigger(ApplicationHook.SUBSCRIPTION_CLOSED, application.getId(), params);
                    this.createAudit(apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_CLOSED, subscription.getUpdatedAt(), previousSubscription, subscription);
                    List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscription.getId());
                    for (ApiKeyEntity apiKey : apiKeys) {
                        Date expireAt = apiKey.getExpireAt();
                        if (apiKey.isRevoked() || expireAt != null && !expireAt.equals(now) && !expireAt.before(now)) continue;
                        apiKey.setExpireAt(now);
                        apiKey.setRevokedAt(now);
                        apiKey.setRevoked(true);
                        this.apiKeyService.revoke(apiKey.getKey(), false);
                    }
                    return this.convert(subscription);
                }
                case PENDING: {
                    ProcessSubscriptionEntity processSubscriptionEntity = new ProcessSubscriptionEntity();
                    processSubscriptionEntity.setId(subscription.getId());
                    processSubscriptionEntity.setAccepted(false);
                    processSubscriptionEntity.setReason("Subscription has been closed.");
                    return this.process(processSubscriptionEntity, this.getAuthenticatedUsername());
                }
            }
            throw new SubscriptionNotClosableException(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to close subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to close subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public SubscriptionEntity pause(String subscriptionId) {
        try {
            this.logger.debug("Pause subscription {}", (Object)subscriptionId);
            Optional optSubscription = this.subscriptionRepository.findById((Object)subscriptionId);
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(subscriptionId);
            }
            Subscription subscription = (Subscription)optSubscription.get();
            if (subscription.getStatus() == Subscription.Status.ACCEPTED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(now);
                subscription.setStatus(Subscription.Status.PAUSED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                ApplicationEntity application = this.applicationService.findById(subscription.getApplication());
                PlanEntity plan = this.planService.findById(subscription.getPlan());
                String apiId = (String)plan.getApis().iterator().next();
                ApiModelEntity api = this.apiService.findByIdForTemplates(apiId);
                PrimaryOwnerEntity owner = application.getPrimaryOwner();
                Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(api).plan(plan).application(application).build();
                this.notifierService.trigger(ApiHook.SUBSCRIPTION_PAUSED, apiId, params);
                this.notifierService.trigger(ApplicationHook.SUBSCRIPTION_PAUSED, application.getId(), params);
                this.createAudit(apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_PAUSED, subscription.getUpdatedAt(), previousSubscription, subscription);
                List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscription.getId());
                for (ApiKeyEntity apiKey : apiKeys) {
                    Date expireAt = apiKey.getExpireAt();
                    if (apiKey.isRevoked() || expireAt != null && !expireAt.equals(now) && !expireAt.after(now)) continue;
                    apiKey.setPaused(true);
                    apiKey.setUpdatedAt(now);
                    this.apiKeyService.update(apiKey);
                }
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausableException(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to pause subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to pause subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public SubscriptionEntity resume(String subscriptionId) {
        try {
            this.logger.debug("Resume subscription {}", (Object)subscriptionId);
            Optional optSubscription = this.subscriptionRepository.findById((Object)subscriptionId);
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(subscriptionId);
            }
            Subscription subscription = (Subscription)optSubscription.get();
            if (subscription.getStatus() == Subscription.Status.PAUSED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(null);
                subscription.setStatus(Subscription.Status.ACCEPTED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                ApplicationEntity application = this.applicationService.findById(subscription.getApplication());
                PlanEntity plan = this.planService.findById(subscription.getPlan());
                String apiId = (String)plan.getApis().iterator().next();
                ApiModelEntity api = this.apiService.findByIdForTemplates(apiId);
                PrimaryOwnerEntity owner = application.getPrimaryOwner();
                Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(api).plan(plan).application(application).build();
                this.notifierService.trigger(ApiHook.SUBSCRIPTION_RESUMED, apiId, params);
                this.notifierService.trigger(ApplicationHook.SUBSCRIPTION_RESUMED, application.getId(), params);
                this.createAudit(apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_RESUMED, subscription.getUpdatedAt(), previousSubscription, subscription);
                List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscription.getId());
                for (ApiKeyEntity apiKey : apiKeys) {
                    Date expireAt = apiKey.getExpireAt();
                    if (apiKey.isRevoked() || expireAt != null && !expireAt.equals(now) && !expireAt.after(now)) continue;
                    apiKey.setPaused(false);
                    apiKey.setUpdatedAt(now);
                    this.apiKeyService.update(apiKey);
                }
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausedException(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to resume subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to resume subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public void delete(String subscriptionId) {
        try {
            this.logger.debug("Delete subscription {}", (Object)subscriptionId);
            Optional optSubscription = this.subscriptionRepository.findById((Object)subscriptionId);
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(subscriptionId);
            }
            Subscription subscription = (Subscription)optSubscription.get();
            this.apiKeyService.findBySubscription(subscriptionId).forEach(apiKey -> this.apiKeyService.delete(apiKey.getKey()));
            this.subscriptionRepository.delete((Object)subscriptionId);
            this.createAudit((String)this.planService.findById(subscription.getPlan()).getApis().iterator().next(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_DELETED, subscription.getUpdatedAt(), subscription, null);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete subscription: {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete subscription: %s", subscriptionId), ex);
        }
    }

    @Override
    public Collection<SubscriptionEntity> search(SubscriptionQuery query) {
        try {
            this.logger.debug("Search subscriptions {}", (Object)query);
            SubscriptionCriteria.Builder builder = new SubscriptionCriteria.Builder().apis(query.getApis()).applications(query.getApplications()).plans(query.getPlans()).from(query.getFrom()).to(query.getTo());
            if (query.getStatuses() != null) {
                builder.statuses((Collection)query.getStatuses().stream().map(subscriptionStatus -> Subscription.Status.valueOf((String)subscriptionStatus.name())).collect(Collectors.toSet()));
            }
            Stream<SubscriptionEntity> subscriptionsStream = this.subscriptionRepository.search(builder.build()).stream().map(this::convert);
            if (query.getApiKey() != null && !query.getApiKey().isEmpty()) {
                subscriptionsStream = subscriptionsStream.filter(subscriptionEntity -> {
                    List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscriptionEntity.getId());
                    return apiKeys.stream().anyMatch(apiKeyEntity -> apiKeyEntity.getKey().equals(query.getApiKey()));
                });
            }
            return subscriptionsStream.collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to search for subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for subscriptions: %s", query), ex);
        }
    }

    @Override
    public Page<SubscriptionEntity> search(SubscriptionQuery query, Pageable pageable) {
        try {
            this.logger.debug("Search pageable subscriptions {}", (Object)query);
            if (query.getApiKey() != null && !query.getApiKey().isEmpty()) {
                try {
                    ApiKeyEntity apiKeyEntity = this.apiKeyService.findByKey(query.getApiKey());
                    SubscriptionEntity subscriptionEntity = this.findById(apiKeyEntity.getSubscription());
                    if (query.getApis() != null && !query.getApis().contains(subscriptionEntity.getApi())) {
                        return new Page(Collections.emptyList(), 1, 0, 0L);
                    }
                    if (query.getApplications() != null && !query.getApplications().contains(subscriptionEntity.getApplication())) {
                        return new Page(Collections.emptyList(), 1, 0, 0L);
                    }
                    if (query.getPlans() != null && !query.getPlans().contains(subscriptionEntity.getPlan())) {
                        return new Page(Collections.emptyList(), 1, 0, 0L);
                    }
                    if (query.getStatuses() != null && !query.getStatuses().contains(subscriptionEntity.getStatus())) {
                        return new Page(Collections.emptyList(), 1, 0, 0L);
                    }
                    return new Page(Collections.singletonList(subscriptionEntity), 1, 1, 1L);
                }
                catch (ApiKeyNotFoundException | SubscriptionNotFoundException ex) {
                    return new Page(Collections.emptyList(), 1, 0, 0L);
                }
            }
            SubscriptionCriteria.Builder builder = new SubscriptionCriteria.Builder().apis(query.getApis()).applications(query.getApplications()).plans(query.getPlans()).from(query.getFrom()).to(query.getTo());
            if (query.getStatuses() != null) {
                builder.statuses((Collection)query.getStatuses().stream().map(subscriptionStatus -> Subscription.Status.valueOf((String)subscriptionStatus.name())).collect(Collectors.toSet()));
            }
            Page pageSubscription = this.subscriptionRepository.search(builder.build(), new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build());
            Stream<SubscriptionEntity> subscriptionsStream = pageSubscription.getContent().stream().map(this::convert);
            return new Page(subscriptionsStream.collect(Collectors.toList()), pageSubscription.getPageNumber() + 1, (int)pageSubscription.getPageElements(), pageSubscription.getTotalElements());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to search for pageable subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for pageable subscriptions: %s", query), ex);
        }
    }

    @Override
    public SubscriptionEntity transfer(TransferSubscriptionEntity transferSubscription, String userId) {
        try {
            this.logger.debug("Subscription {} transferred by {}", (Object)transferSubscription.getId(), (Object)userId);
            Optional optSubscription = this.subscriptionRepository.findById((Object)transferSubscription.getId());
            if (!optSubscription.isPresent()) {
                throw new SubscriptionNotFoundException(transferSubscription.getId());
            }
            PlanEntity planEntity = this.planService.findById(transferSubscription.getPlan());
            Subscription subscription = (Subscription)optSubscription.get();
            if (planEntity.getStatus() != PlanStatus.PUBLISHED || !planEntity.getSecurity().equals((Object)this.planService.findById(subscription.getPlan()).getSecurity())) {
                throw new TransferNotAllowedException(planEntity.getId());
            }
            Subscription previousSubscription = new Subscription(subscription);
            subscription.setUpdatedAt(new Date());
            subscription.setPlan(transferSubscription.getPlan());
            subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
            List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscription.getId());
            for (ApiKeyEntity apiKey : apiKeys) {
                apiKey.setPlan(transferSubscription.getPlan());
                this.apiKeyService.update(apiKey);
            }
            ApplicationEntity application = this.applicationService.findById(subscription.getApplication());
            PlanEntity plan = this.planService.findById(subscription.getPlan());
            String apiId = (String)plan.getApis().iterator().next();
            ApiModelEntity api = this.apiService.findByIdForTemplates(apiId);
            PrimaryOwnerEntity owner = application.getPrimaryOwner();
            this.createAudit(apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
            SubscriptionEntity subscriptionEntity = this.convert(subscription);
            Map<String, Object> params = new NotificationParamsBuilder().owner(owner).application(application).api(api).plan(plan).subscription(subscriptionEntity).build();
            this.notifierService.trigger(ApiHook.SUBSCRIPTION_TRANSFERRED, apiId, params);
            this.notifierService.trigger(ApplicationHook.SUBSCRIPTION_TRANSFERRED, application.getId(), params);
            return subscriptionEntity;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to transfer subscription {} by {}", new Object[]{transferSubscription.getId(), userId, ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to transfer subscription %s by %s", transferSubscription.getId(), userId), ex);
        }
    }

    @Override
    public String exportAsCsv(Collection<SubscriptionEntity> subscriptions, Map<String, Map<String, Object>> metadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("Plan");
        sb.append(';');
        sb.append("Application");
        sb.append(';');
        sb.append("Creation date");
        sb.append(';');
        sb.append("Process date");
        sb.append(';');
        sb.append("Start date");
        sb.append(';');
        sb.append("End date date");
        sb.append(';');
        sb.append("Status");
        sb.append(System.lineSeparator());
        if (subscriptions == null || subscriptions.isEmpty()) {
            return sb.toString();
        }
        for (SubscriptionEntity subscription : subscriptions) {
            Map<String, Object> plan = metadata.get(subscription.getPlan());
            sb.append(this.getName(plan));
            sb.append(';');
            Map<String, Object> application = metadata.get(subscription.getApplication());
            sb.append(this.getName(application));
            sb.append(';');
            if (subscription.getCreatedAt() != null) {
                sb.append(dateFormatter.format(subscription.getCreatedAt()));
                sb.append(';');
            }
            if (subscription.getProcessedAt() != null) {
                sb.append(dateFormatter.format(subscription.getProcessedAt()));
                sb.append(';');
            }
            if (subscription.getStartingAt() != null) {
                sb.append(dateFormatter.format(subscription.getStartingAt()));
                sb.append(';');
            }
            if (subscription.getEndingAt() != null) {
                sb.append(dateFormatter.format(subscription.getEndingAt()));
                sb.append(';');
            }
            sb.append(subscription.getStatus());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private String getName(Object map) {
        return map == null ? "" : ((Map)map).get("name").toString();
    }

    @Override
    public Metadata getMetadata(List<SubscriptionEntity> subscriptions) {
        Metadata metadata = new Metadata();
        subscriptions.forEach(subscription -> {
            if (!metadata.containsKey(subscription.getApplication())) {
                ApplicationEntity applicationEntity = this.applicationService.findById(subscription.getApplication());
                metadata.put(subscription.getApplication(), "name", (Object)applicationEntity.getName());
            }
            if (!metadata.containsKey(subscription.getPlan())) {
                PlanEntity planEntity = this.planService.findById(subscription.getPlan());
                metadata.put(subscription.getPlan(), "name", (Object)planEntity.getName());
            }
            if (!metadata.containsKey(subscription.getApi())) {
                ApiEntity api = this.apiService.findById(subscription.getApi());
                metadata.put(subscription.getApi(), "name", (Object)api.getName());
            }
        });
        return metadata;
    }

    private SubscriptionEntity convert(Subscription subscription) {
        SubscriptionEntity entity = new SubscriptionEntity();
        entity.setId(subscription.getId());
        entity.setApi(subscription.getApi());
        entity.setPlan(subscription.getPlan());
        entity.setProcessedAt(subscription.getProcessedAt());
        entity.setStatus(SubscriptionStatus.valueOf((String)subscription.getStatus().name()));
        entity.setProcessedBy(subscription.getProcessedBy());
        entity.setRequest(subscription.getRequest());
        entity.setReason(subscription.getReason());
        entity.setApplication(subscription.getApplication());
        entity.setStartingAt(subscription.getStartingAt());
        entity.setEndingAt(subscription.getEndingAt());
        entity.setCreatedAt(subscription.getCreatedAt());
        entity.setUpdatedAt(subscription.getUpdatedAt());
        entity.setSubscribedBy(subscription.getSubscribedBy());
        entity.setClosedAt(subscription.getClosedAt());
        entity.setClientId(subscription.getClientId());
        entity.setPausedAt(subscription.getPausedAt());
        return entity;
    }

    private void createAudit(String apiId, String applicationId, Audit.AuditEvent event, Date createdAt, Subscription oldValue, Subscription newValue) {
        this.auditService.createApiAuditLog(apiId, Collections.singletonMap(Audit.AuditProperties.APPLICATION, applicationId), event, createdAt, oldValue, newValue);
        this.auditService.createApplicationAuditLog(applicationId, Collections.singletonMap(Audit.AuditProperties.API, apiId), event, createdAt, oldValue, newValue);
    }
}

