/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.platform.plugin.PluginEntity;
import io.gravitee.management.service.ResourceService;
import io.gravitee.management.service.exceptions.ResourceNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.resource.ResourcePlugin;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceServiceImpl
extends TransactionalService
implements ResourceService {
    private final Logger LOGGER = LoggerFactory.getLogger(ResourceServiceImpl.class);
    @Autowired
    private ConfigurablePluginManager<ResourcePlugin> resourcePluginManager;

    @Override
    public Set<PluginEntity> findAll() {
        try {
            this.LOGGER.debug("List all resources");
            Collection resourceDefinitions = this.resourcePluginManager.findAll();
            return resourceDefinitions.stream().map(resourceDefinition -> this.convert((Plugin)resourceDefinition)).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to list all resources", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all resources", ex);
        }
    }

    @Override
    public PluginEntity findById(String resource) {
        this.LOGGER.debug("Find resource by ID: {}", (Object)resource);
        ResourcePlugin resourceDefinition = (ResourcePlugin)this.resourcePluginManager.get(resource);
        if (resourceDefinition == null) {
            throw new ResourceNotFoundException(resource);
        }
        return this.convert((Plugin)resourceDefinition);
    }

    @Override
    public String getSchema(String resource) {
        try {
            this.LOGGER.debug("Find resource schema by ID: {}", (Object)resource);
            return this.resourcePluginManager.getSchema(resource);
        }
        catch (IOException ioex) {
            this.LOGGER.error("An error occurs while trying to get resource's schema for resource {}", (Object)resource, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get resource's schema for resource " + resource, ioex);
        }
    }

    private PluginEntity convert(Plugin plugin) {
        PluginEntity entity = new PluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        return entity;
    }
}

