/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.quality.NewQualityRuleEntity;
import io.gravitee.management.model.quality.QualityRuleEntity;
import io.gravitee.management.model.quality.UpdateQualityRuleEntity;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.QualityRuleService;
import io.gravitee.management.service.exceptions.QualityRuleNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.QualityRuleRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.QualityRule;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QualityRuleServiceImpl
extends AbstractService
implements QualityRuleService {
    private final Logger LOGGER = LoggerFactory.getLogger(QualityRuleServiceImpl.class);
    @Autowired
    private QualityRuleRepository qualityRuleRepository;
    @Autowired
    private ApiQualityRuleRepository apiQualityRuleRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public QualityRuleEntity findById(String id) {
        try {
            this.LOGGER.debug("Find quality rule by id : {}", (Object)id);
            Optional qualityRule = this.qualityRuleRepository.findById((Object)id);
            if (qualityRule.isPresent()) {
                return this.convert((QualityRule)qualityRule.get());
            }
            throw new QualityRuleNotFoundException(id);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find a quality rule using its ID: " + id;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public List<QualityRuleEntity> findAll() {
        try {
            this.LOGGER.debug("Find all quality rules");
            return this.qualityRuleRepository.findAll().stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all quality rules", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all quality rules", ex);
        }
    }

    @Override
    public QualityRuleEntity create(NewQualityRuleEntity newEntity) {
        try {
            QualityRule qualityRule = this.convert(newEntity);
            QualityRule createdQualityRule = (QualityRule)this.qualityRuleRepository.create((Object)qualityRule);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.QUALITY_RULE, createdQualityRule.getId()), (Audit.AuditEvent)QualityRule.AuditEvent.QUALITY_RULE_CREATED, qualityRule.getCreatedAt(), null, qualityRule);
            return this.convert(createdQualityRule);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to create a quality rule {}", (Object)newEntity, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to create a quality rule " + newEntity, e);
        }
    }

    @Override
    public QualityRuleEntity update(UpdateQualityRuleEntity updateEntity) {
        try {
            Optional optionalQualityRule = this.qualityRuleRepository.findById((Object)updateEntity.getId());
            if (!optionalQualityRule.isPresent()) {
                throw new QualityRuleNotFoundException(updateEntity.getId());
            }
            QualityRule qualityRule = (QualityRule)this.qualityRuleRepository.update((Object)this.convert(updateEntity));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.QUALITY_RULE, qualityRule.getId()), (Audit.AuditEvent)QualityRule.AuditEvent.QUALITY_RULE_UPDATED, qualityRule.getUpdatedAt(), optionalQualityRule.get(), qualityRule);
            return this.convert(qualityRule);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to update quality rule {}", (Object)updateEntity, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to update quality rule " + updateEntity, e);
        }
    }

    @Override
    public void delete(String qualityRule) {
        try {
            Optional qualityRuleOptional = this.qualityRuleRepository.findById((Object)qualityRule);
            if (qualityRuleOptional.isPresent()) {
                this.qualityRuleRepository.delete((Object)qualityRule);
                this.apiQualityRuleRepository.deleteByQualityRule(qualityRule);
                this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.QUALITY_RULE, qualityRule), (Audit.AuditEvent)QualityRule.AuditEvent.QUALITY_RULE_DELETED, new Date(), null, qualityRuleOptional.get());
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete quality rule {}", (Object)qualityRule, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete quality rule " + qualityRule, ex);
        }
    }

    private QualityRuleEntity convert(QualityRule qualityRule) {
        QualityRuleEntity entity = new QualityRuleEntity();
        entity.setId(qualityRule.getId());
        entity.setName(qualityRule.getName());
        entity.setDescription(qualityRule.getDescription());
        entity.setWeight(qualityRule.getWeight());
        entity.setCreatedAt(qualityRule.getCreatedAt());
        entity.setUpdatedAt(qualityRule.getUpdatedAt());
        return entity;
    }

    private QualityRule convert(NewQualityRuleEntity qualityRuleEntity) {
        QualityRule qualityRule = new QualityRule();
        qualityRule.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        qualityRule.setName(qualityRuleEntity.getName());
        qualityRule.setDescription(qualityRuleEntity.getDescription());
        qualityRule.setWeight(qualityRuleEntity.getWeight());
        Date now = new Date();
        qualityRule.setCreatedAt(now);
        qualityRule.setUpdatedAt(now);
        return qualityRule;
    }

    private QualityRule convert(UpdateQualityRuleEntity qualityRuleEntity) {
        QualityRule qualityRule = new QualityRule();
        qualityRule.setId(qualityRuleEntity.getId());
        qualityRule.setName(qualityRuleEntity.getName());
        qualityRule.setDescription(qualityRuleEntity.getDescription());
        qualityRule.setWeight(qualityRuleEntity.getWeight());
        qualityRule.setUpdatedAt(new Date());
        return qualityRule;
    }
}

