/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.gravitee.management.model.notification.NewPortalNotificationEntity;
import io.gravitee.management.model.notification.PortalNotificationEntity;
import io.gravitee.management.service.PortalNotificationService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.notification.Hook;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalNotificationRepository;
import io.gravitee.repository.management.model.PortalNotification;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.yaml.snakeyaml.Yaml;

@Component
public class PortalNotificationServiceImpl
extends AbstractService
implements PortalNotificationService {
    private final Logger LOGGER = LoggerFactory.getLogger(PortalNotificationServiceImpl.class);
    private static final String RELATIVE_TPL_PATH = "notifications/portal/";
    @Autowired
    private PortalNotificationRepository portalNotificationRepository;
    @Autowired
    private Configuration freemarkerConfiguration;

    @Override
    public List<PortalNotificationEntity> findByUser(String user) {
        try {
            return this.portalNotificationRepository.findByUser(user).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find notifications by user {}", (Object)user, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find notifications by username " + user, ex);
        }
    }

    @Override
    public void create(Hook hook, List<String> users, Object params) {
        try {
            String tpl = RELATIVE_TPL_PATH + hook.getScope().name() + "." + hook.name() + ".yml";
            Template template = this.freemarkerConfiguration.getTemplate(tpl);
            String yamlContent = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)params);
            Yaml yaml = new Yaml();
            Map load = (Map)yaml.loadAs(yamlContent, HashMap.class);
            ArrayList<NewPortalNotificationEntity> notifications = new ArrayList<NewPortalNotificationEntity>(users.size());
            users.forEach(user -> {
                NewPortalNotificationEntity notification = new NewPortalNotificationEntity();
                notification.setUser(user);
                notification.setTitle((String)load.get("title"));
                notification.setMessage((String)load.get("message"));
                notifications.add(notification);
            });
            this.create(notifications);
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while sending notification", (Throwable)ex);
            throw new TechnicalManagementException("Error while sending notification", ex);
        }
    }

    @Override
    public void deleteAll(String user) {
        try {
            this.portalNotificationRepository.deleteAll(user);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete all notifications for user  {}", (Object)user, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying delete all notifications for user " + user, ex);
        }
    }

    @Override
    public void delete(String notificationId) {
        try {
            this.portalNotificationRepository.delete((Object)notificationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete {}", (Object)notificationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying delete " + notificationId, ex);
        }
    }

    private void create(List<NewPortalNotificationEntity> notificationEntities) {
        Date now = new Date();
        List<PortalNotification> notifications = notificationEntities.stream().map(this::convert).collect(Collectors.toList());
        notifications.forEach(n -> {
            n.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
            n.setCreatedAt(now);
        });
        try {
            this.portalNotificationRepository.create(notifications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {}", notifications, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + notifications, ex);
        }
    }

    private PortalNotification convert(NewPortalNotificationEntity entity) {
        PortalNotification notification = new PortalNotification();
        notification.setTitle(entity.getTitle());
        notification.setMessage(entity.getMessage());
        notification.setUser(entity.getUser());
        return notification;
    }

    private PortalNotificationEntity convert(PortalNotification notification) {
        PortalNotificationEntity entity = new PortalNotificationEntity();
        entity.setId(notification.getId());
        entity.setTitle(notification.getTitle());
        entity.setMessage(notification.getMessage());
        entity.setCreatedAt(notification.getCreatedAt());
        return entity;
    }
}

