/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.Path;
import io.gravitee.management.model.NewPlanEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.PlanSecurityEntity;
import io.gravitee.management.model.PlanSecurityType;
import io.gravitee.management.model.PlanStatus;
import io.gravitee.management.model.PlanType;
import io.gravitee.management.model.PlanValidationType;
import io.gravitee.management.model.PlansConfigurationEntity;
import io.gravitee.management.model.UpdatePlanEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.api.ApiLifecycleState;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.model.plan.PlanQuery;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.SubscriptionService;
import io.gravitee.management.service.exceptions.ApiDeprecatedException;
import io.gravitee.management.service.exceptions.KeylessPlanAlreadyPublishedException;
import io.gravitee.management.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.management.service.exceptions.PlanAlreadyDeprecatedException;
import io.gravitee.management.service.exceptions.PlanAlreadyPublishedException;
import io.gravitee.management.service.exceptions.PlanNotFoundException;
import io.gravitee.management.service.exceptions.PlanNotYetPublishedException;
import io.gravitee.management.service.exceptions.PlanWithSubscriptionsException;
import io.gravitee.management.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UnauthorizedPlanSecurityTypeException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.management.service.processor.PlanSynchronizationProcessor;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Plan;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanServiceImpl
extends TransactionalService
implements PlanService {
    private final Logger logger = LoggerFactory.getLogger(PlanServiceImpl.class);
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private PlanSynchronizationProcessor planSynchronizationProcessor;
    @Autowired
    private ApiService apiService;
    private static final List<PlanSecurityEntity> DEFAULT_SECURITY_LIST = Collections.unmodifiableList(Arrays.asList(new PlanSecurityEntity("oauth2", "OAuth2", "oauth2"), new PlanSecurityEntity("jwt", "JWT", "'jwt'"), new PlanSecurityEntity("api_key", "API Key", "api-key"), new PlanSecurityEntity("key_less", "Keyless (public)", "")));

    @Override
    public PlanEntity findById(String plan) {
        try {
            this.logger.debug("Find plan by id : {}", (Object)plan);
            Optional optPlan = this.planRepository.findById((Object)plan);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(plan);
            }
            return this.convert((Plan)optPlan.get());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a plan by id: {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by id: %s", plan), ex);
        }
    }

    @Override
    public Set<PlanEntity> findByApi(String api) {
        try {
            this.logger.debug("Find plan by api : {}", (Object)api);
            Set plans = this.planRepository.findByApi(api);
            return plans.stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a plan by api: {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by api: %s", api), ex);
        }
    }

    @Override
    public List<PlanEntity> search(PlanQuery query) {
        Set<Object> planEntities = query.getApi() != null ? this.findByApi(query.getApi()) : Collections.emptySet();
        return planEntities.stream().filter(p -> {
            boolean filtered = true;
            if (query.getName() != null) {
                filtered = p.getName().equals(query.getName());
            }
            if (filtered && query.getSecurity() != null) {
                filtered = p.getSecurity().equals((Object)query.getSecurity());
            }
            return filtered;
        }).collect(Collectors.toList());
    }

    @Override
    public PlanEntity create(NewPlanEntity newPlan) {
        try {
            this.logger.debug("Create a new plan {} for API {}", (Object)newPlan.getName(), (Object)newPlan.getApi());
            this.assertPlanSecurityIsAllowed(newPlan.getSecurity());
            ApiEntity api = this.apiService.findById(newPlan.getApi());
            if (ApiLifecycleState.DEPRECATED.equals((Object)api.getLifecycleState())) {
                throw new ApiDeprecatedException(api.getName());
            }
            Plan plan = new Plan();
            plan.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
            plan.setApis(Collections.singleton(newPlan.getApi()));
            plan.setName(newPlan.getName());
            plan.setDescription(newPlan.getDescription());
            plan.setCreatedAt(new Date());
            plan.setUpdatedAt(plan.getCreatedAt());
            plan.setNeedRedeployAt(plan.getCreatedAt());
            plan.setType(Plan.PlanType.valueOf((String)newPlan.getType().name()));
            plan.setSecurity(Plan.PlanSecurityType.valueOf((String)newPlan.getSecurity().name()));
            plan.setSecurityDefinition(newPlan.getSecurityDefinition());
            plan.setStatus(Plan.Status.valueOf((String)newPlan.getStatus().name()));
            plan.setExcludedGroups(newPlan.getExcludedGroups());
            plan.setCommentRequired(newPlan.isCommentRequired());
            plan.setCommentMessage(newPlan.getCommentMessage());
            plan.setTags(newPlan.getTags());
            plan.setSelectionRule(newPlan.getSelectionRule());
            if (plan.getSecurity() == Plan.PlanSecurityType.KEY_LESS) {
                plan.setValidation(Plan.PlanValidationType.AUTO);
            } else {
                plan.setValidation(Plan.PlanValidationType.valueOf((String)newPlan.getValidation().name()));
            }
            plan.setCharacteristics(newPlan.getCharacteristics());
            String planPolicies = this.objectMapper.writeValueAsString((Object)newPlan.getPaths());
            plan.setDefinition(planPolicies);
            plan = (Plan)this.planRepository.create((Object)plan);
            this.auditService.createApiAuditLog(newPlan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_CREATED, plan.getCreatedAt(), null, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to create a plan {} for API {}", new Object[]{newPlan.getName(), newPlan.getApi(), ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a plan %s for API %s", newPlan.getName(), newPlan.getApi()), ex);
        }
        catch (JsonProcessingException jse) {
            this.logger.error("Unexpected error while generating plan definition", (Throwable)jse);
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a plan %s for API %s", newPlan.getName(), newPlan.getApi()), jse);
        }
    }

    @Override
    public PlanEntity create(String apiId, PlanEntity planEntity) {
        return this.create(this.convert(planEntity, apiId));
    }

    @Override
    public PlanEntity update(UpdatePlanEntity updatePlan) {
        try {
            this.logger.debug("Update plan {}", (Object)updatePlan.getName());
            Optional optPlan = this.planRepository.findById((Object)updatePlan.getId());
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(updatePlan.getId());
            }
            Plan oldPlan = (Plan)optPlan.get();
            this.assertPlanSecurityIsAllowed(PlanSecurityType.valueOf((String)oldPlan.getSecurity().name()));
            Plan newPlan = new Plan();
            newPlan.setId(oldPlan.getId());
            newPlan.setSecurity(oldPlan.getSecurity());
            newPlan.setType(oldPlan.getType());
            newPlan.setStatus(oldPlan.getStatus());
            newPlan.setOrder(oldPlan.getOrder());
            newPlan.setApis(oldPlan.getApis());
            newPlan.setCreatedAt(oldPlan.getCreatedAt());
            newPlan.setPublishedAt(oldPlan.getPublishedAt());
            newPlan.setClosedAt(oldPlan.getClosedAt());
            if (oldPlan.getNeedRedeployAt() == null) {
                newPlan.setNeedRedeployAt(oldPlan.getUpdatedAt());
            } else {
                newPlan.setNeedRedeployAt(oldPlan.getNeedRedeployAt());
            }
            newPlan.setName(updatePlan.getName());
            newPlan.setDescription(updatePlan.getDescription());
            newPlan.setUpdatedAt(new Date());
            newPlan.setSecurityDefinition(updatePlan.getSecurityDefinition());
            newPlan.setCommentRequired(updatePlan.isCommentRequired());
            newPlan.setCommentMessage(updatePlan.getCommentMessage());
            newPlan.setTags(updatePlan.getTags());
            newPlan.setSelectionRule(updatePlan.getSelectionRule());
            String planPolicies = this.objectMapper.writeValueAsString((Object)updatePlan.getPaths());
            newPlan.setDefinition(planPolicies);
            newPlan.setExcludedGroups(updatePlan.getExcludedGroups());
            if (newPlan.getSecurity() == Plan.PlanSecurityType.KEY_LESS) {
                newPlan.setValidation(Plan.PlanValidationType.AUTO);
            } else {
                newPlan.setValidation(Plan.PlanValidationType.valueOf((String)updatePlan.getValidation().name()));
            }
            newPlan.setCharacteristics(updatePlan.getCharacteristics());
            if (newPlan.getOrder() != updatePlan.getOrder()) {
                newPlan.setOrder(updatePlan.getOrder());
                this.reorderAndSavePlans(newPlan);
                return null;
            }
            if (!this.planSynchronizationProcessor.processCheckSynchronization(this.convert(oldPlan), this.convert(newPlan))) {
                newPlan.setNeedRedeployAt(newPlan.getUpdatedAt());
            }
            newPlan = (Plan)this.planRepository.update((Object)newPlan);
            this.auditService.createApiAuditLog((String)newPlan.getApis().iterator().next(), Collections.singletonMap(Audit.AuditProperties.PLAN, newPlan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_UPDATED, newPlan.getUpdatedAt(), oldPlan, newPlan);
            return this.convert(newPlan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)updatePlan.getName(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update plan %s", updatePlan.getName()), ex);
        }
        catch (JsonProcessingException jse) {
            this.logger.error("Unexpected error while generating plan definition", (Throwable)jse);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update a plan %s", updatePlan.getName()), jse);
        }
    }

    @Override
    public PlanEntity close(String planId, String userId) {
        try {
            this.logger.debug("Close plan {}", (Object)planId);
            Optional optPlan = this.planRepository.findById((Object)planId);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(planId);
            }
            Plan plan = (Plan)optPlan.get();
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            plan.setStatus(Plan.Status.CLOSED);
            plan.setClosedAt(new Date());
            plan.setUpdatedAt(plan.getClosedAt());
            plan.setNeedRedeployAt(plan.getClosedAt());
            if (plan.getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                this.subscriptionService.findByPlan(planId).stream().forEach(subscription -> {
                    try {
                        this.subscriptionService.close(subscription.getId());
                    }
                    catch (SubscriptionNotClosableException subscriptionNotClosableException) {
                        // empty catch block
                    }
                });
            }
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog((String)plan.getApis().iterator().next(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_CLOSED, plan.getUpdatedAt(), previousPlan, plan);
            this.reorderedAndSavePlansAfterRemove((Plan)optPlan.get());
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete plan: %s", planId), ex);
        }
    }

    @Override
    public void delete(String plan) {
        try {
            this.logger.debug("Delete plan {}", (Object)plan);
            Optional optPlan = this.planRepository.findById((Object)plan);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(plan);
            }
            if (((Plan)optPlan.get()).getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                int subscriptions = this.subscriptionService.findByPlan(plan).size();
                if ((((Plan)optPlan.get()).getStatus() == Plan.Status.PUBLISHED || ((Plan)optPlan.get()).getStatus() == Plan.Status.DEPRECATED) && subscriptions > 0) {
                    throw new PlanWithSubscriptionsException();
                }
            }
            this.planRepository.delete((Object)plan);
            this.auditService.createApiAuditLog((String)((Plan)optPlan.get()).getApis().iterator().next(), Collections.singletonMap(Audit.AuditProperties.PLAN, ((Plan)optPlan.get()).getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_DELETED, new Date(), optPlan.get(), null);
            this.reorderedAndSavePlansAfterRemove((Plan)optPlan.get());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete plan: {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete plan: %s", plan), ex);
        }
    }

    @Override
    public PlanEntity publish(String planId) {
        try {
            long count;
            this.logger.debug("Publish plan {}", (Object)planId);
            Optional optPlan = this.planRepository.findById((Object)planId);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(planId);
            }
            Plan plan = (Plan)optPlan.get();
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (plan.getStatus() == Plan.Status.PUBLISHED) {
                throw new PlanAlreadyPublishedException(planId);
            }
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            Set plans = this.planRepository.findByApi((String)plan.getApis().iterator().next());
            if (plan.getSecurity() == Plan.PlanSecurityType.KEY_LESS && (count = plans.stream().filter(plan1 -> plan1.getStatus() == Plan.Status.PUBLISHED || plan1.getStatus() == Plan.Status.DEPRECATED).filter(plan1 -> plan1.getSecurity() == Plan.PlanSecurityType.KEY_LESS).count()) > 0L) {
                throw new KeylessPlanAlreadyPublishedException(planId);
            }
            plan.setStatus(Plan.Status.PUBLISHED);
            List orderedPublishedPlans = plans.stream().filter(plan1 -> Plan.Status.PUBLISHED.equals((Object)plan1.getStatus())).sorted(Comparator.comparingInt(Plan::getOrder)).collect(Collectors.toList());
            plan.setOrder(orderedPublishedPlans.isEmpty() ? 1 : ((Plan)orderedPublishedPlans.get(orderedPublishedPlans.size() - 1)).getOrder() + 1);
            plan.setPublishedAt(new Date());
            plan.setUpdatedAt(plan.getPublishedAt());
            plan.setNeedRedeployAt(plan.getPublishedAt());
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog((String)plan.getApis().iterator().next(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_PUBLISHED, plan.getUpdatedAt(), previousPlan, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to publish plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to publish plan: %s", planId), ex);
        }
    }

    @Override
    public PlanEntity depreciate(String planId) {
        return this.depreciate(planId, false);
    }

    @Override
    public PlanEntity depreciate(String planId, boolean allowStaging) {
        try {
            this.logger.debug("Depreciate plan {}", (Object)planId);
            Optional optPlan = this.planRepository.findById((Object)planId);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(planId);
            }
            Plan plan = (Plan)optPlan.get();
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (!allowStaging && plan.getStatus() == Plan.Status.STAGING) {
                throw new PlanNotYetPublishedException(planId);
            }
            plan.setStatus(Plan.Status.DEPRECATED);
            plan.setUpdatedAt(new Date());
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog((String)plan.getApis().iterator().next(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_DEPRECATED, plan.getUpdatedAt(), previousPlan, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to depreciate plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to depreciate plan: %s", planId), ex);
        }
    }

    @Override
    public PlansConfigurationEntity getConfiguration() {
        PlansConfigurationEntity config = new PlansConfigurationEntity();
        config.setSecurity(DEFAULT_SECURITY_LIST);
        return config;
    }

    private void reorderAndSavePlans(Plan planToReorder) throws TechnicalException {
        Set plans = this.planRepository.findByApi((String)planToReorder.getApis().iterator().next());
        Plan[] plansToReorder = (Plan[])plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus()) && !Objects.equals(p.getId(), planToReorder.getId())).sorted(Comparator.comparingInt(Plan::getOrder)).toArray(Plan[]::new);
        if (planToReorder.getOrder() < 1) {
            planToReorder.setOrder(1);
        } else if (planToReorder.getOrder() > plansToReorder.length + 1) {
            planToReorder.setOrder(plansToReorder.length + 1);
        }
        try {
            for (int i = 0; i < plansToReorder.length; ++i) {
                int newOrder;
                int n = newOrder = i + 1 < planToReorder.getOrder() ? i + 1 : i + 2;
                if (plansToReorder[i].getOrder() == newOrder) continue;
                plansToReorder[i].setOrder(newOrder);
                this.planRepository.update((Object)plansToReorder[i]);
            }
            this.planRepository.update((Object)planToReorder);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)planToReorder.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update plan " + planToReorder.getId(), ex);
        }
    }

    private void reorderedAndSavePlansAfterRemove(Plan planRemoved) throws TechnicalException {
        Set plans = this.planRepository.findByApi((String)planRemoved.getApis().iterator().next());
        plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus())).sorted(Comparator.comparingInt(Plan::getOrder)).forEachOrdered(plan -> {
            try {
                if (plan.getOrder() > planRemoved.getOrder()) {
                    plan.setOrder(plan.getOrder() - 1);
                    this.planRepository.update(plan);
                }
            }
            catch (TechnicalException ex) {
                this.logger.error("An error occurs while trying to reorder plan {}", (Object)plan.getId(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update plan " + plan.getId(), ex);
            }
        });
    }

    private PlanEntity convert(Plan plan) {
        PlanEntity entity = new PlanEntity();
        entity.setId(plan.getId());
        entity.setName(plan.getName());
        entity.setDescription(plan.getDescription());
        entity.setApis(plan.getApis());
        entity.setCreatedAt(plan.getCreatedAt());
        entity.setUpdatedAt(plan.getUpdatedAt());
        entity.setOrder(plan.getOrder());
        entity.setExcludedGroups(plan.getExcludedGroups());
        if (plan.getDefinition() != null && !plan.getDefinition().isEmpty()) {
            try {
                HashMap rules = (HashMap)this.objectMapper.readValue(plan.getDefinition(), (TypeReference)new TypeReference<HashMap<String, Path>>(){});
                entity.setPaths((Map)rules);
            }
            catch (IOException ioe) {
                this.logger.error("Unexpected error while generating policy definition", (Throwable)ioe);
            }
        }
        entity.setType(PlanType.valueOf((String)plan.getType().name()));
        if (plan.getStatus() != null) {
            entity.setStatus(PlanStatus.valueOf((String)plan.getStatus().name()));
        } else {
            entity.setStatus(PlanStatus.PUBLISHED);
        }
        if (plan.getSecurity() != null) {
            entity.setSecurity(PlanSecurityType.valueOf((String)plan.getSecurity().name()));
        } else {
            entity.setSecurity(PlanSecurityType.API_KEY);
        }
        entity.setSecurityDefinition(plan.getSecurityDefinition());
        entity.setClosedAt(plan.getClosedAt());
        entity.setNeedRedeployAt(plan.getNeedRedeployAt() == null ? plan.getUpdatedAt() : plan.getNeedRedeployAt());
        entity.setPublishedAt(plan.getPublishedAt());
        entity.setValidation(PlanValidationType.valueOf((String)plan.getValidation().name()));
        entity.setCharacteristics(plan.getCharacteristics());
        entity.setCommentRequired(plan.isCommentRequired());
        entity.setCommentMessage(plan.getCommentMessage());
        entity.setTags(plan.getTags());
        entity.setSelectionRule(plan.getSelectionRule());
        return entity;
    }

    private NewPlanEntity convert(PlanEntity planEntity, String apiId) {
        NewPlanEntity newPlanEntity = new NewPlanEntity();
        newPlanEntity.setName(planEntity.getName());
        newPlanEntity.setType(planEntity.getType());
        newPlanEntity.setCharacteristics(planEntity.getCharacteristics());
        newPlanEntity.setCommentMessage(planEntity.getCommentMessage());
        newPlanEntity.setCommentRequired(planEntity.isCommentRequired());
        newPlanEntity.setDescription(planEntity.getDescription());
        newPlanEntity.setExcludedGroups(planEntity.getExcludedGroups());
        newPlanEntity.setPaths(planEntity.getPaths());
        newPlanEntity.setSecurity(planEntity.getSecurity());
        newPlanEntity.setSecurityDefinition(planEntity.getSecurityDefinition());
        newPlanEntity.setSelectionRule(planEntity.getSelectionRule());
        newPlanEntity.setStatus(planEntity.getStatus());
        newPlanEntity.setTags(planEntity.getTags());
        newPlanEntity.setValidation(planEntity.getValidation());
        newPlanEntity.setApi(apiId);
        return newPlanEntity;
    }

    private void assertPlanSecurityIsAllowed(PlanSecurityType securityType) {
        Key securityKey;
        switch (securityType) {
            case API_KEY: {
                securityKey = Key.PLAN_SECURITY_APIKEY_ENABLED;
                break;
            }
            case OAUTH2: {
                securityKey = Key.PLAN_SECURITY_OAUTH2_ENABLED;
                break;
            }
            case JWT: {
                securityKey = Key.PLAN_SECURITY_JWT_ENABLED;
                break;
            }
            case KEY_LESS: {
                securityKey = Key.PLAN_SECURITY_KEYLESS_ENABLED;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.parameterService.findAsBoolean(securityKey)) {
            throw new UnauthorizedPlanSecurityTypeException(securityType);
        }
    }
}

