/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.permissions.RolePermission;
import io.gravitee.management.model.permissions.RolePermissionAction;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.PermissionService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.exceptions.ApiNotFoundException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.management.model.MembershipDefaultReferenceId;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionServiceImpl
extends AbstractService
implements PermissionService {
    @Autowired
    MembershipService membershipService;
    @Autowired
    ApiService apiService;
    @Autowired
    ApplicationService applicationService;
    @Autowired
    RoleService roleService;

    @Override
    public boolean hasPermission(RolePermission permission, String referenceId, Set<String> referenceGroups, RolePermissionAction ... acls) {
        RoleScope repoRoleScope;
        MembershipReferenceType membershipReferenceType;
        Optional<String> optionalReferenceId = Optional.ofNullable(referenceId);
        MembershipReferenceType groupMembershipReferenceType = null;
        switch (permission.getScope()) {
            case MANAGEMENT: {
                membershipReferenceType = MembershipReferenceType.MANAGEMENT;
                repoRoleScope = RoleScope.MANAGEMENT;
                break;
            }
            case PORTAL: {
                membershipReferenceType = MembershipReferenceType.PORTAL;
                repoRoleScope = RoleScope.PORTAL;
                break;
            }
            case API: {
                membershipReferenceType = MembershipReferenceType.API;
                groupMembershipReferenceType = MembershipReferenceType.GROUP;
                repoRoleScope = RoleScope.API;
                break;
            }
            case APPLICATION: {
                membershipReferenceType = MembershipReferenceType.APPLICATION;
                groupMembershipReferenceType = MembershipReferenceType.GROUP;
                repoRoleScope = RoleScope.APPLICATION;
                break;
            }
            default: {
                membershipReferenceType = null;
                repoRoleScope = null;
            }
        }
        HashSet<RoleEntity> roles = new HashSet<RoleEntity>();
        RoleEntity firstDegreeRole = this.membershipService.getRole(membershipReferenceType, optionalReferenceId.orElse(MembershipDefaultReferenceId.DEFAULT.name()), this.getAuthenticatedUsername(), repoRoleScope);
        if (firstDegreeRole != null) {
            roles.add(firstDegreeRole);
        }
        if (groupMembershipReferenceType != null) {
            Set groups;
            if (referenceGroups != null) {
                groups = referenceGroups;
            } else {
                try {
                    groups = this.apiService.findById(referenceId).getGroups();
                }
                catch (ApiNotFoundException | IllegalArgumentException ane) {
                    groups = this.applicationService.findById(referenceId).getGroups();
                }
            }
            if (groups != null && !groups.isEmpty()) {
                roles.addAll(this.membershipService.getRoles(groupMembershipReferenceType, groups, this.getAuthenticatedUsername(), repoRoleScope));
            }
        }
        for (RoleEntity roleEntity : roles) {
            if (!this.roleService.hasPermission(roleEntity.getPermissions(), permission.getPermission(), acls)) continue;
            return true;
        }
        return false;
    }
}

