/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.gravitee.common.utils.UUID;
import io.gravitee.fetcher.api.Fetcher;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.fetcher.api.FetcherException;
import io.gravitee.fetcher.api.FilepathAwareFetcherConfiguration;
import io.gravitee.fetcher.api.FilesFetcher;
import io.gravitee.fetcher.api.Resource;
import io.gravitee.fetcher.api.Sensitive;
import io.gravitee.management.fetcher.FetcherConfigurationFactory;
import io.gravitee.management.model.ApiModelEntity;
import io.gravitee.management.model.ApiPageEntity;
import io.gravitee.management.model.ImportPageEntity;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.MetadataEntity;
import io.gravitee.management.model.NewPageEntity;
import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.PageSourceEntity;
import io.gravitee.management.model.UpdatePageEntity;
import io.gravitee.management.model.Visibility;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.descriptor.GraviteeDescriptorEntity;
import io.gravitee.management.model.descriptor.GraviteeDescriptorPageEntity;
import io.gravitee.management.model.documentation.PageQuery;
import io.gravitee.management.model.permissions.ApiPermission;
import io.gravitee.management.model.permissions.Permission;
import io.gravitee.management.model.permissions.RolePermissionAction;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.GraviteeDescriptorService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.MetadataService;
import io.gravitee.management.service.PageService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.SwaggerService;
import io.gravitee.management.service.exceptions.InvalidDataException;
import io.gravitee.management.service.exceptions.NoFetcherDefinedException;
import io.gravitee.management.service.exceptions.PageContentUnsafeException;
import io.gravitee.management.service.exceptions.PageFolderActionException;
import io.gravitee.management.service.exceptions.PageNotFoundException;
import io.gravitee.management.service.exceptions.SwaggerDescriptorException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.management.service.impl.swagger.parser.OAIParser;
import io.gravitee.management.service.impl.swagger.transformer.entrypoints.EntrypointsOAITransformer;
import io.gravitee.management.service.impl.swagger.transformer.page.PageConfigurationOAITransformer;
import io.gravitee.management.service.sanitizer.HtmlSanitizer;
import io.gravitee.management.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.management.service.search.SearchEngineService;
import io.gravitee.management.service.spring.ImportConfiguration;
import io.gravitee.management.service.swagger.OAIDescriptor;
import io.gravitee.management.service.swagger.SwaggerDescriptor;
import io.gravitee.plugin.core.api.PluginManager;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.search.PageCriteria;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageSource;
import io.gravitee.repository.management.model.PageType;
import io.gravitee.repository.management.model.RoleScope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Component
public class PageServiceImpl
extends TransactionalService
implements PageService,
ApplicationContextAware {
    private static final Gson gson = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(PageServiceImpl.class);
    private static final String SENSITIVE_DATA_REPLACEMENT = "********";
    @Value(value="${documentation.markdown.sanitize:false}")
    private boolean markdownSanitize;
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private SwaggerService swaggerService;
    @Autowired
    private PluginManager<FetcherPlugin> fetcherPluginManager;
    @Autowired
    private FetcherConfigurationFactory fetcherConfigurationFactory;
    @Autowired
    private Configuration freemarkerConfiguration;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private GraviteeDescriptorService graviteeDescriptorService;
    @Autowired
    private ImportConfiguration importConfiguration;

    @Override
    public PageEntity findById(String pageId) {
        try {
            logger.debug("Find page by ID: {}", (Object)pageId);
            Optional page = this.pageRepository.findById((Object)pageId);
            if (page.isPresent()) {
                return this.convert((Page)page.get());
            }
            throw new PageNotFoundException(pageId);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to find a page using its ID {}", (Object)pageId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find a page using its ID " + pageId, ex);
        }
    }

    @Override
    public void transformSwagger(PageEntity pageEntity) {
        String apiId = null;
        if (pageEntity instanceof ApiPageEntity) {
            apiId = ((ApiPageEntity)pageEntity).getApi();
        }
        this.transformSwagger(pageEntity, apiId);
    }

    @Override
    public void transformSwagger(PageEntity pageEntity, String apiId) {
        if (apiId != null) {
            this.transformWithTemplate(pageEntity, apiId);
        }
        if (this.markdownSanitize && PageType.MARKDOWN.name().equalsIgnoreCase(pageEntity.getType())) {
            pageEntity.setContent(HtmlSanitizer.sanitize(pageEntity.getContent()));
        } else if (PageType.SWAGGER.name().equalsIgnoreCase(pageEntity.getType())) {
            SwaggerDescriptor descriptor = null;
            try {
                descriptor = this.swaggerService.parse(pageEntity.getContent());
            }
            catch (SwaggerDescriptorException sde) {
                if (apiId != null) {
                    logger.error("Parsing error for API : {}", (Object)apiId);
                }
                throw sde;
            }
            ArrayList transformers = new ArrayList();
            transformers.add(new PageConfigurationOAITransformer(pageEntity));
            if (apiId != null) {
                List entrypoints = this.apiService.findById(apiId).getEntrypoints();
                transformers.add(new EntrypointsOAITransformer(pageEntity, entrypoints));
            }
            this.swaggerService.transform((OAIDescriptor)descriptor, transformers);
            if (pageEntity.getContentType().equalsIgnoreCase("application/json")) {
                try {
                    pageEntity.setContent(descriptor.toJson());
                }
                catch (JsonProcessingException e) {
                    logger.error("Unexpected error", (Throwable)e);
                }
            } else {
                try {
                    pageEntity.setContent(descriptor.toYaml());
                }
                catch (JsonProcessingException e) {
                    logger.error("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<PageEntity> search(PageQuery query) {
        try {
            return this.convert(this.pageRepository.search(this.queryToCriteria(query)));
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    @Override
    public void transformWithTemplate(PageEntity pageEntity, String api) {
        if (pageEntity.getContent() != null) {
            try {
                Template template = new Template(pageEntity.getId(), pageEntity.getContent(), this.freemarkerConfiguration);
                HashMap model = new HashMap();
                if (api == null) {
                    List<MetadataEntity> metadataList = this.metadataService.findAllDefault();
                    if (metadataList != null) {
                        HashMap mapMetadata = new HashMap(metadataList.size());
                        metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue()));
                        model.put("metadata", mapMetadata);
                    }
                } else {
                    ApiModelEntity apiEntity = this.apiService.findByIdForTemplates(api, true);
                    model.put("api", apiEntity);
                }
                String content = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, model);
                pageEntity.setContent(content);
            }
            catch (TemplateException | IOException ex) {
                logger.error("An error occurs while transforming page content for {}", (Object)pageEntity.getId(), (Object)ex);
            }
        }
    }

    @Override
    public PageEntity createPage(String apiId, NewPageEntity newPageEntity) {
        try {
            Page page;
            logger.debug("Create page {} for API {}", (Object)newPageEntity, (Object)apiId);
            String id = UUID.toString((java.util.UUID)UUID.random());
            if (io.gravitee.management.model.PageType.FOLDER.equals((Object)newPageEntity.getType())) {
                if (newPageEntity.getContent() != null && newPageEntity.getContent().length() > 0) {
                    throw new PageFolderActionException("have a content");
                }
                if (newPageEntity.isHomepage()) {
                    throw new PageFolderActionException("be affected to the home page");
                }
            }
            if ((page = PageServiceImpl.convert(newPageEntity)).getSource() != null) {
                this.fetchPage(page);
            }
            page.setId(id);
            page.setApi(apiId);
            page.setCreatedAt(new Date());
            page.setUpdatedAt(page.getCreatedAt());
            List<String> messages = this.validateSafeContent(page.getContent(), page.getType());
            Page createdPage = (Page)this.pageRepository.create((Object)page);
            this.onlyOneHomepage(page);
            this.createAuditLog(apiId, (Audit.AuditEvent)Page.AuditEvent.PAGE_CREATED, page.getCreatedAt(), null, page);
            PageEntity pageEntity = this.convert(createdPage);
            if (messages != null && messages.size() > 0) {
                pageEntity.setMessages(messages);
            }
            this.index(pageEntity);
            return pageEntity;
        }
        catch (FetcherException | TechnicalException ex) {
            logger.error("An error occurs while trying to create {}", (Object)newPageEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + newPageEntity, ex);
        }
    }

    @Override
    public PageEntity createPage(NewPageEntity newPageEntity) {
        return this.createPage(null, newPageEntity);
    }

    @Override
    public PageEntity create(String apiId, PageEntity pageEntity) {
        NewPageEntity newPageEntity = this.convert(pageEntity);
        newPageEntity.setLastContributor(null);
        return this.createPage(apiId, newPageEntity);
    }

    private void onlyOneHomepage(Page page) throws TechnicalException {
        if (page.isHomepage()) {
            List pages = page.getApi() != null ? this.pageRepository.search(new PageCriteria.Builder().api(page.getApi()).homepage(Boolean.valueOf(true)).build()) : this.pageRepository.search(new PageCriteria.Builder().homepage(Boolean.valueOf(true)).build());
            pages.stream().filter(i -> !i.getId().equals(page.getId())).forEach(i -> {
                try {
                    i.setHomepage(false);
                    this.pageRepository.update(i);
                }
                catch (TechnicalException e) {
                    logger.error("An error occurs while trying update homepage attribute from {}", (Object)page, (Object)e);
                }
            });
        }
    }

    @Override
    public PageEntity update(String pageId, UpdatePageEntity updatePageEntity) {
        return this.update(pageId, updatePageEntity, false);
    }

    @Override
    public PageEntity update(String pageId, UpdatePageEntity updatePageEntity, boolean partial) {
        try {
            logger.debug("Update Page {}", (Object)pageId);
            Optional optPageToUpdate = this.pageRepository.findById((Object)pageId);
            if (!optPageToUpdate.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page pageToUpdate = (Page)optPageToUpdate.get();
            Page page = null;
            page = partial ? PageServiceImpl.merge(updatePageEntity, pageToUpdate) : PageServiceImpl.convert(updatePageEntity);
            if (page.getSource() != null) {
                try {
                    if (pageToUpdate.getSource() != null && pageToUpdate.getSource().getConfiguration() != null) {
                        this.mergeSensitiveData(this.getFetcher(pageToUpdate.getSource()).getConfiguration(), page);
                    }
                    this.fetchPage(page);
                }
                catch (FetcherException e) {
                    throw this.onUpdateFail(pageId, e);
                }
            }
            page.setId(pageId);
            page.setUpdatedAt(new Date());
            page.setCreatedAt(pageToUpdate.getCreatedAt());
            page.setType(pageToUpdate.getType());
            page.setApi(pageToUpdate.getApi());
            this.onlyOneHomepage(page);
            if (page.getOrder() != pageToUpdate.getOrder()) {
                this.reorderAndSavePages(page);
                return null;
            }
            List<String> messages = this.validateSafeContent(page.getContent(), page.getType());
            Page updatedPage = (Page)this.pageRepository.update((Object)page);
            this.createAuditLog(page.getApi(), (Audit.AuditEvent)Page.AuditEvent.PAGE_UPDATED, page.getUpdatedAt(), pageToUpdate, page);
            PageEntity pageEntity = this.convert(updatedPage);
            pageEntity.setMessages(messages);
            if (pageToUpdate.isPublished() && !page.isPublished()) {
                this.searchEngineService.delete((Indexable)this.convert(pageToUpdate), false);
            } else {
                this.index(pageEntity);
            }
            return pageEntity;
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    private void index(PageEntity pageEntity) {
        if (pageEntity.isPublished()) {
            this.searchEngineService.index((Indexable)pageEntity, false);
        }
    }

    private void fetchPage(Page page) throws FetcherException {
        this.validateSafeSource(page);
        Fetcher fetcher = this.getFetcher(page.getSource());
        if (fetcher != null) {
            try {
                Resource resource = fetcher.fetch();
                page.setContent(this.getResourceContentAsString(resource));
                if (resource.getMetadata() != null) {
                    page.setMetadata(new HashMap(resource.getMetadata().size()));
                    for (Map.Entry entry : resource.getMetadata().entrySet()) {
                        if (entry.getValue() instanceof Map) continue;
                        page.getMetadata().put(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new FetcherException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Fetcher getFetcher(PageSource ps) throws FetcherException {
        if (ps.getConfiguration().isEmpty()) {
            return null;
        }
        try {
            Fetcher fetcher;
            FetcherPlugin fetcherPlugin = (FetcherPlugin)this.fetcherPluginManager.get(ps.getType());
            ClassLoader fetcherCL = fetcherPlugin.fetcher().getClassLoader();
            if (fetcherPlugin.configuration().getName().equals(FilepathAwareFetcherConfiguration.class.getName())) {
                Class<?> fetcherConfigurationClass = fetcherCL.loadClass(fetcherPlugin.configuration().getName());
                Class<?> fetcherClass = fetcherCL.loadClass(fetcherPlugin.clazz());
                FetcherConfiguration fetcherConfigurationInstance = this.fetcherConfigurationFactory.create(fetcherConfigurationClass, ps.getConfiguration());
                fetcher = (Fetcher)fetcherClass.getConstructor(fetcherConfigurationClass).newInstance(fetcherConfigurationInstance);
            } else {
                Class<?> fetcherConfigurationClass = fetcherCL.loadClass(fetcherPlugin.configuration().getName());
                Class<?> fetcherClass = fetcherCL.loadClass(fetcherPlugin.clazz());
                FetcherConfiguration fetcherConfigurationInstance = this.fetcherConfigurationFactory.create(fetcherConfigurationClass, ps.getConfiguration());
                fetcher = (Fetcher)fetcherClass.getConstructor(fetcherConfigurationClass).newInstance(fetcherConfigurationInstance);
            }
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)fetcher);
            return fetcher;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FetcherException(e.getMessage(), (Throwable)e);
        }
    }

    private String getResourceContentAsString(Resource resource) throws FetcherException {
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resource.getContent()));){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FetcherException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<PageEntity> importFiles(ImportPageEntity pageEntity) {
        return this.importFiles(null, pageEntity);
    }

    @Override
    public List<PageEntity> importFiles(String apiId, ImportPageEntity pageEntity) {
        Page page = this.upsertRootPage(apiId, pageEntity);
        pageEntity.setSource(this.convert(page.getSource(), false));
        return this.fetchPages(apiId, pageEntity);
    }

    @Override
    public void delete(String pageId) {
        try {
            logger.debug("Delete Page : {}", (Object)pageId);
            Optional optPage = this.pageRepository.findById((Object)pageId);
            if (!optPage.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page page = (Page)optPage.get();
            if (PageType.FOLDER.equals((Object)page.getType()) && this.pageRepository.search(new PageCriteria.Builder().api(page.getApi()).parent(page.getId()).build()).size() > 0) {
                throw new TechnicalManagementException("Unable to remove the folder. It must be empty before being removed.");
            }
            this.pageRepository.delete((Object)pageId);
            this.createAuditLog(page.getApi(), (Audit.AuditEvent)Page.AuditEvent.PAGE_DELETED, new Date(), page, null);
            this.searchEngineService.delete((Indexable)this.convert(page), false);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to delete Page {}", (Object)pageId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Page " + pageId, ex);
        }
    }

    @Override
    public int findMaxApiPageOrderByApi(String apiName) {
        try {
            logger.debug("Find Max Order Page for api name : {}", (Object)apiName);
            Integer maxPageOrder = this.pageRepository.findMaxApiPageOrderByApiId(apiName);
            return maxPageOrder == null ? 0 : maxPageOrder;
        }
        catch (TechnicalException ex) {
            logger.error("An error occured when searching max order page for api name [{}]", (Object)apiName, (Object)ex);
            throw new TechnicalManagementException("An error occured when searching max order page for api name " + apiName, ex);
        }
    }

    @Override
    public int findMaxPortalPageOrder() {
        try {
            logger.debug("Find Max Order Portal Page");
            Integer maxPageOrder = this.pageRepository.findMaxPortalPageOrder();
            return maxPageOrder == null ? 0 : maxPageOrder;
        }
        catch (TechnicalException ex) {
            logger.error("An error occured when searching max order portal page", (Throwable)ex);
            throw new TechnicalManagementException("An error occured when searching max order portal ", ex);
        }
    }

    @Override
    public boolean isDisplayable(ApiEntity api, boolean pageIsPublished, String username) {
        boolean isDisplayable = false;
        if (api.getVisibility() == Visibility.PUBLIC && pageIsPublished) {
            isDisplayable = true;
        } else if (username != null) {
            MemberEntity member = this.membershipService.getMember(MembershipReferenceType.API, api.getId(), username, RoleScope.API);
            if (member == null && api.getGroups() != null) {
                Iterator groupIdIterator = api.getGroups().iterator();
                while (!isDisplayable && groupIdIterator.hasNext()) {
                    String groupId = (String)groupIdIterator.next();
                    member = this.membershipService.getMember(MembershipReferenceType.GROUP, groupId, username, RoleScope.API);
                    isDisplayable = this.isDisplayableForMember(member, pageIsPublished);
                }
            } else {
                isDisplayable = this.isDisplayableForMember(member, pageIsPublished);
            }
        }
        return isDisplayable;
    }

    @Override
    public void fetchAll(PageQuery query, String contributor) {
        try {
            this.pageRepository.search(this.queryToCriteria(query)).stream().filter(pageListItem -> pageListItem.getSource() != null).forEach(pageListItem -> {
                if (pageListItem.getType() != null && pageListItem.getType().toString().equals("ROOT")) {
                    ImportPageEntity pageEntity = new ImportPageEntity();
                    pageEntity.setType(io.gravitee.management.model.PageType.valueOf((String)pageListItem.getType().toString()));
                    pageEntity.setSource(this.convert(pageListItem.getSource(), false));
                    pageEntity.setConfiguration(pageListItem.getConfiguration());
                    pageEntity.setPublished(pageListItem.isPublished());
                    pageEntity.setExcludedGroups(pageListItem.getExcludedGroups());
                    pageEntity.setLastContributor(contributor);
                    this.fetchPages(query.getApi(), pageEntity);
                } else {
                    this.fetch(pageListItem.getId(), contributor);
                }
            });
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to fetch pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to fetch pages", ex);
        }
    }

    @Override
    public PageEntity fetch(String pageId, String contributor) {
        try {
            logger.debug("Fetch page {}", (Object)pageId);
            Optional optPageToUpdate = this.pageRepository.findById((Object)pageId);
            if (!optPageToUpdate.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page page = (Page)optPageToUpdate.get();
            if (page.getSource() == null) {
                throw new NoFetcherDefinedException(pageId);
            }
            try {
                this.fetchPage(page);
            }
            catch (FetcherException e) {
                throw this.onUpdateFail(pageId, e);
            }
            page.setUpdatedAt(new Date());
            page.setLastContributor(contributor);
            List<String> messages = this.validateSafeContent(page.getContent(), page.getType());
            Page updatedPage = (Page)this.pageRepository.update((Object)page);
            this.createAuditLog(page.getApi(), (Audit.AuditEvent)Page.AuditEvent.PAGE_UPDATED, page.getUpdatedAt(), page, page);
            PageEntity pageEntity = this.convert(updatedPage);
            pageEntity.setMessages(messages);
            return pageEntity;
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    private List<PageEntity> fetchPages(String apiId, ImportPageEntity pageEntity) {
        try {
            Fetcher _fetcher = this.getFetcher(PageServiceImpl.convert(pageEntity.getSource()));
            if (_fetcher == null) {
                return Collections.emptyList();
            }
            if (!(_fetcher instanceof FilesFetcher)) {
                throw new UnsupportedOperationException("The plugin does not support to import a directory.");
            }
            FilesFetcher fetcher = (FilesFetcher)_fetcher;
            return this.importDirectory(apiId, pageEntity, fetcher);
        }
        catch (FetcherException ex) {
            logger.error("An error occurs while trying to import a directory", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying import a directory", ex);
        }
    }

    private List<PageEntity> importDescriptor(String apiId, ImportPageEntity descriptorPageEntity, FilesFetcher fetcher, GraviteeDescriptorEntity descriptorEntity) {
        if (descriptorEntity.getDocumentation() == null || descriptorEntity.getDocumentation().getPages() == null || descriptorEntity.getDocumentation().getPages().isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> parentsIdByPath = new HashMap<String, String>();
        ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
        int order = 0;
        for (GraviteeDescriptorPageEntity descriptorPage : descriptorEntity.getDocumentation().getPages()) {
            NewPageEntity newPage = this.getPageFromPath(descriptorPage.getSrc());
            if (newPage == null) {
                logger.warn("Unable to find a source file to import. Please fix the descriptor content.");
                continue;
            }
            if (descriptorPage.getName() != null && !descriptorPage.getName().isEmpty()) {
                newPage.setName(descriptorPage.getName());
            }
            newPage.setHomepage(descriptorPage.isHomepage());
            newPage.setLastContributor(descriptorPageEntity.getLastContributor());
            newPage.setPublished(descriptorPageEntity.isPublished());
            newPage.setSource(descriptorPageEntity.getSource());
            newPage.setOrder(order++);
            String parentPath = descriptorPage.getDest() == null || descriptorPage.getDest().isEmpty() ? this.getParentPathFromFilePath(descriptorPage.getSrc()) : descriptorPage.getDest();
            try {
                createdPages.addAll(this.upsertPageAndParentFolders(parentPath, newPage, parentsIdByPath, fetcher, apiId, descriptorPage.getSrc()));
            }
            catch (TechnicalException ex) {
                logger.error("An error occurs while trying to import a gravitee descriptor", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while trying to import a gravitee descriptor", ex);
            }
        }
        return createdPages;
    }

    private List<PageEntity> importDirectory(String apiId, ImportPageEntity pageEntity, FilesFetcher fetcher) {
        try {
            String[] files = fetcher.files();
            Optional<String> optDescriptor = Arrays.stream(files).filter(f -> f.endsWith(this.graviteeDescriptorService.descriptorName())).findFirst();
            if (optDescriptor.isPresent()) {
                try {
                    ((FilepathAwareFetcherConfiguration)fetcher.getConfiguration()).setFilepath(optDescriptor.get());
                    Resource resource = fetcher.fetch();
                    GraviteeDescriptorEntity descriptorEntity = this.graviteeDescriptorService.read(this.getResourceContentAsString(resource));
                    return this.importDescriptor(apiId, pageEntity, fetcher, descriptorEntity);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new FetcherException(e.getMessage(), (Throwable)e);
                }
            }
            HashMap<String, String> parentsIdByPath = new HashMap<String, String>();
            ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
            int order = 0;
            for (String file : files) {
                NewPageEntity pageFromPath = this.getPageFromPath(file);
                if (pageFromPath == null) continue;
                pageFromPath.setLastContributor(pageEntity.getLastContributor());
                pageFromPath.setPublished(pageEntity.isPublished());
                pageFromPath.setSource(pageEntity.getSource());
                pageFromPath.setOrder(order++);
                try {
                    createdPages.addAll(this.upsertPageAndParentFolders(this.getParentPathFromFilePath(file), pageFromPath, parentsIdByPath, fetcher, apiId, file));
                }
                catch (TechnicalException ex) {
                    logger.error("An error occurs while trying to import a directory", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to import a directory", ex);
                }
            }
            return createdPages;
        }
        catch (FetcherException ex) {
            logger.error("An error occurs while trying to import a directory", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying import a directory", ex);
        }
    }

    private NewPageEntity getPageFromPath(String path) {
        String[] pathElements;
        io.gravitee.management.model.PageType supportedPageType;
        String[] extensions;
        if (path != null && (extensions = path.split("\\.")).length > 0 && (supportedPageType = this.getSupportedPageType(extensions[extensions.length - 1])) != null && (pathElements = path.split("/")).length > 0) {
            String filename = pathElements[pathElements.length - 1];
            NewPageEntity newPage = new NewPageEntity();
            newPage.setName(filename.substring(0, filename.lastIndexOf(".")));
            newPage.setType(supportedPageType);
            return newPage;
        }
        logger.warn("Unable to extract Page informations from :[" + path + "]");
        return null;
    }

    private String getParentPathFromFilePath(String filePath) {
        String[] pathElements;
        if (filePath != null && !filePath.isEmpty() && (pathElements = filePath.split("/")).length > 0) {
            StringJoiner stringJoiner = new StringJoiner("/");
            for (int i = 0; i < pathElements.length - 1; ++i) {
                stringJoiner.add(pathElements[i]);
            }
            return stringJoiner.toString();
        }
        return "/";
    }

    private List<PageEntity> upsertPageAndParentFolders(String parentPath, NewPageEntity newPageEntity, Map<String, String> parentsIdByPath, FilesFetcher fetcher, String apiId, String src) throws TechnicalException {
        ObjectMapper mapper = new ObjectMapper();
        String[] pathElements = parentPath.split("/");
        String pwd = "";
        ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
        for (String pathElement : pathElements) {
            if (pathElement.isEmpty()) continue;
            String futurePwd = pwd + "/" + pathElement;
            if (!parentsIdByPath.containsKey(futurePwd)) {
                PageEntity folder;
                String parentId = parentsIdByPath.get(pwd);
                List pages = this.pageRepository.search(new PageCriteria.Builder().parent(parentId).api(apiId).name(pathElement).type(io.gravitee.management.model.PageType.FOLDER.name()).build());
                if (pages.isEmpty()) {
                    NewPageEntity newPage = new NewPageEntity();
                    newPage.setParentId(parentId);
                    newPage.setPublished(newPageEntity.isPublished());
                    newPage.setLastContributor(newPageEntity.getLastContributor());
                    newPage.setName(pathElement);
                    newPage.setType(io.gravitee.management.model.PageType.FOLDER);
                    folder = this.createPage(apiId, newPage);
                } else {
                    folder = this.convert((Page)pages.get(0));
                }
                parentsIdByPath.put(futurePwd, folder.getId());
                createdPages.add(folder);
            }
            pwd = futurePwd;
        }
        String parentId = parentsIdByPath.get(pwd);
        List pages = this.pageRepository.search(new PageCriteria.Builder().parent(parentId).api(apiId).name(newPageEntity.getName()).type(newPageEntity.getType().name()).build());
        if (pages.isEmpty()) {
            newPageEntity.setParentId(parentId);
            FilepathAwareFetcherConfiguration configuration = (FilepathAwareFetcherConfiguration)fetcher.getConfiguration();
            configuration.setFilepath(src);
            newPageEntity.getSource().setConfiguration(mapper.valueToTree((Object)configuration));
            createdPages.add(this.createPage(apiId, newPageEntity));
        } else {
            Page page = (Page)pages.get(0);
            UpdatePageEntity updatePage = this.convertToUpdateEntity(page);
            updatePage.setLastContributor(newPageEntity.getLastContributor());
            updatePage.setPublished(Boolean.valueOf(newPageEntity.isPublished()));
            updatePage.setOrder(Integer.valueOf(newPageEntity.getOrder()));
            updatePage.setHomepage(Boolean.valueOf(newPageEntity.isHomepage()));
            FilepathAwareFetcherConfiguration configuration = (FilepathAwareFetcherConfiguration)fetcher.getConfiguration();
            configuration.setFilepath(src);
            updatePage.setSource(newPageEntity.getSource());
            updatePage.getSource().setConfiguration(mapper.valueToTree((Object)configuration));
            createdPages.add(this.update(page.getId(), updatePage, false));
        }
        return createdPages;
    }

    private Page upsertRootPage(String apiId, ImportPageEntity rootPage) {
        try {
            List searchResult = this.pageRepository.search(new PageCriteria.Builder().api(apiId).type(io.gravitee.management.model.PageType.ROOT.name()).build());
            Page page = PageServiceImpl.convert(rootPage);
            page.setApi(apiId);
            if (searchResult.isEmpty()) {
                page.setId(UUID.toString((java.util.UUID)UUID.random()));
                this.validateSafeContent(page.getContent(), page.getType());
                return (Page)this.pageRepository.create((Object)page);
            }
            page.setId(((Page)searchResult.get(0)).getId());
            this.mergeSensitiveData(this.getFetcher(((Page)searchResult.get(0)).getSource()).getConfiguration(), page);
            this.validateSafeContent(page.getContent(), page.getType());
            return (Page)this.pageRepository.update((Object)page);
        }
        catch (FetcherException | TechnicalException ex) {
            logger.error("An error occurs while trying to save the configuration", ex);
            throw new TechnicalManagementException("An error occurs while trying to save the configuration", ex);
        }
    }

    private io.gravitee.management.model.PageType getSupportedPageType(String extension) {
        for (io.gravitee.management.model.PageType pageType : io.gravitee.management.model.PageType.values()) {
            if (!pageType.extensions().contains(extension.toLowerCase())) continue;
            return pageType;
        }
        return null;
    }

    private void reorderAndSavePages(Page pageToReorder) throws TechnicalException {
        PageCriteria.Builder q = new PageCriteria.Builder().api(pageToReorder.getApi());
        if (pageToReorder.getParentId() == null) {
            q.rootParent(Boolean.TRUE);
        } else {
            q.parent(pageToReorder.getParentId());
        }
        List pages = this.pageRepository.search(q.build());
        List<Boolean> increment = Arrays.asList(true);
        pages.stream().sorted(Comparator.comparingInt(Page::getOrder)).forEachOrdered(page -> {
            try {
                if (page.equals((Object)pageToReorder)) {
                    increment.set(0, false);
                    page.setOrder(pageToReorder.getOrder());
                } else {
                    Boolean isIncrement = (Boolean)increment.get(0);
                    int newOrder = page.getOrder() < pageToReorder.getOrder() ? page.getOrder() - (isIncrement != false ? 0 : 1) : (page.getOrder() > pageToReorder.getOrder() ? page.getOrder() + (isIncrement != false ? 1 : 0) : page.getOrder() + (isIncrement != false ? 1 : -1));
                    page.setOrder(newOrder);
                }
                this.pageRepository.update(page);
            }
            catch (TechnicalException ex) {
                throw this.onUpdateFail(page.getId(), ex);
            }
        });
    }

    private TechnicalManagementException onUpdateFail(String pageId, TechnicalException ex) {
        logger.error("An error occurs while trying to update page {}", (Object)pageId, (Object)ex);
        return new TechnicalManagementException("An error occurs while trying to update page " + pageId, ex);
    }

    private TechnicalManagementException onUpdateFail(String pageId, FetcherException ex) {
        logger.error("An error occurs while trying to update page {}", (Object)pageId, (Object)ex);
        return new TechnicalManagementException("An error occurs while trying to fetch content. " + ex.getMessage(), ex);
    }

    private boolean isDisplayableForMember(MemberEntity member, boolean pageIsPublished) {
        if (member == null) {
            return false;
        }
        if (pageIsPublished) {
            return true;
        }
        return this.roleService.hasPermission(member.getPermissions(), (Permission)ApiPermission.DOCUMENTATION, new RolePermissionAction[]{RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE});
    }

    private static Page convert(NewPageEntity newPageEntity) {
        Page page = new Page();
        page.setName(newPageEntity.getName());
        io.gravitee.management.model.PageType type = newPageEntity.getType();
        if (type != null) {
            page.setType(PageType.valueOf((String)type.name()));
        }
        page.setContent(newPageEntity.getContent());
        page.setLastContributor(newPageEntity.getLastContributor());
        page.setOrder(newPageEntity.getOrder());
        page.setPublished(newPageEntity.isPublished());
        page.setHomepage(newPageEntity.isHomepage());
        page.setSource(PageServiceImpl.convert(newPageEntity.getSource()));
        page.setConfiguration(newPageEntity.getConfiguration());
        page.setExcludedGroups(newPageEntity.getExcludedGroups());
        page.setParentId("".equals(newPageEntity.getParentId()) ? null : newPageEntity.getParentId());
        return page;
    }

    private NewPageEntity convert(PageEntity pageEntity) {
        NewPageEntity newPageEntity = new NewPageEntity();
        newPageEntity.setName(pageEntity.getName());
        newPageEntity.setOrder(pageEntity.getOrder());
        newPageEntity.setPublished(pageEntity.isPublished());
        newPageEntity.setSource(pageEntity.getSource());
        newPageEntity.setType(io.gravitee.management.model.PageType.valueOf((String)pageEntity.getType()));
        newPageEntity.setParentId(pageEntity.getParentId());
        newPageEntity.setHomepage(pageEntity.isHomepage());
        newPageEntity.setContent(pageEntity.getContent());
        newPageEntity.setConfiguration(pageEntity.getConfiguration());
        newPageEntity.setExcludedGroups(pageEntity.getExcludedGroups());
        newPageEntity.setLastContributor(pageEntity.getLastContributor());
        return newPageEntity;
    }

    private static Page convert(ImportPageEntity importPageEntity) {
        Page page = new Page();
        io.gravitee.management.model.PageType type = importPageEntity.getType();
        if (type != null) {
            page.setType(PageType.valueOf((String)type.name()));
        }
        page.setLastContributor(importPageEntity.getLastContributor());
        page.setPublished(importPageEntity.isPublished());
        page.setSource(PageServiceImpl.convert(importPageEntity.getSource()));
        page.setConfiguration(importPageEntity.getConfiguration());
        page.setExcludedGroups(importPageEntity.getExcludedGroups());
        return page;
    }

    private List<PageEntity> convert(List<Page> pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        return pages.stream().map(this::convert).collect(Collectors.toList());
    }

    private PageEntity convert(Page page) {
        ApiPageEntity pageEntity;
        if (page.getApi() != null) {
            pageEntity = new ApiPageEntity();
            pageEntity.setApi(page.getApi());
        } else {
            pageEntity = new PageEntity();
        }
        pageEntity.setId(page.getId());
        pageEntity.setName(page.getName());
        pageEntity.setHomepage(page.isHomepage());
        if (page.getType() != null) {
            pageEntity.setType(page.getType().toString());
        }
        pageEntity.setContent(page.getContent());
        if (PageServiceImpl.isJson(page.getContent())) {
            pageEntity.setContentType("application/json");
        } else {
            pageEntity.setContentType("text/yaml");
        }
        pageEntity.setLastContributor(page.getLastContributor());
        pageEntity.setLastModificationDate(page.getUpdatedAt());
        pageEntity.setOrder(page.getOrder());
        pageEntity.setPublished(page.isPublished());
        if (page.getSource() != null) {
            pageEntity.setSource(this.convert(page.getSource()));
        }
        if (page.getConfiguration() != null) {
            pageEntity.setConfiguration(page.getConfiguration());
        }
        pageEntity.setExcludedGroups(page.getExcludedGroups());
        pageEntity.setParentId("".equals(page.getParentId()) ? null : page.getParentId());
        pageEntity.setMetadata(page.getMetadata());
        return pageEntity;
    }

    private static Page merge(UpdatePageEntity updatePageEntity, Page withUpdatePage) {
        Page page = new Page();
        page.setName(updatePageEntity.getName() != null ? updatePageEntity.getName() : withUpdatePage.getName());
        page.setContent(updatePageEntity.getContent() != null ? updatePageEntity.getContent() : withUpdatePage.getContent());
        page.setLastContributor(updatePageEntity.getLastContributor() != null ? updatePageEntity.getLastContributor() : withUpdatePage.getLastContributor());
        page.setOrder(updatePageEntity.getOrder() != null ? updatePageEntity.getOrder().intValue() : withUpdatePage.getOrder());
        page.setPublished(updatePageEntity.isPublished() != null ? updatePageEntity.isPublished().booleanValue() : withUpdatePage.isPublished());
        PageSource pageSource = PageServiceImpl.convert(updatePageEntity.getSource());
        page.setSource(pageSource != null ? pageSource : withUpdatePage.getSource());
        page.setConfiguration(updatePageEntity.getConfiguration() != null ? updatePageEntity.getConfiguration() : withUpdatePage.getConfiguration());
        page.setHomepage(updatePageEntity.isHomepage() != null ? updatePageEntity.isHomepage().booleanValue() : withUpdatePage.isHomepage());
        page.setExcludedGroups(updatePageEntity.getExcludedGroups() != null ? updatePageEntity.getExcludedGroups() : withUpdatePage.getExcludedGroups());
        page.setParentId((String)(updatePageEntity.getParentId() != null ? (updatePageEntity.getParentId().isEmpty() ? null : updatePageEntity.getParentId()) : withUpdatePage.getParentId()));
        return page;
    }

    private static Page convert(UpdatePageEntity updatePageEntity) {
        Page page = new Page();
        page.setName(updatePageEntity.getName());
        page.setContent(updatePageEntity.getContent());
        page.setLastContributor(updatePageEntity.getLastContributor());
        page.setOrder(updatePageEntity.getOrder().intValue());
        page.setPublished(Boolean.TRUE.equals(updatePageEntity.isPublished()));
        page.setSource(PageServiceImpl.convert(updatePageEntity.getSource()));
        page.setConfiguration(updatePageEntity.getConfiguration());
        page.setHomepage(Boolean.TRUE.equals(updatePageEntity.isHomepage()));
        page.setExcludedGroups(updatePageEntity.getExcludedGroups());
        page.setParentId("".equals(updatePageEntity.getParentId()) ? null : updatePageEntity.getParentId());
        return page;
    }

    private UpdatePageEntity convertToUpdateEntity(Page page) {
        UpdatePageEntity updatePageEntity = new UpdatePageEntity();
        updatePageEntity.setName(page.getName());
        updatePageEntity.setContent(page.getContent());
        updatePageEntity.setLastContributor(page.getLastContributor());
        updatePageEntity.setOrder(Integer.valueOf(page.getOrder()));
        updatePageEntity.setPublished(Boolean.valueOf(page.isPublished()));
        updatePageEntity.setSource(this.convert(page.getSource()));
        updatePageEntity.setConfiguration(page.getConfiguration());
        updatePageEntity.setHomepage(Boolean.valueOf(page.isHomepage()));
        updatePageEntity.setExcludedGroups(page.getExcludedGroups());
        updatePageEntity.setParentId("".equals(page.getParentId()) ? null : page.getParentId());
        return updatePageEntity;
    }

    private static PageSource convert(PageSourceEntity pageSourceEntity) {
        PageSource source = null;
        if (pageSourceEntity != null && pageSourceEntity.getType() != null && pageSourceEntity.getConfiguration() != null) {
            source = new PageSource();
            source.setType(pageSourceEntity.getType());
            source.setConfiguration(pageSourceEntity.getConfiguration());
        }
        return source;
    }

    private PageSourceEntity convert(PageSource pageSource) {
        return this.convert(pageSource, true);
    }

    private PageSourceEntity convert(PageSource pageSource, boolean removeSensitiveData) {
        PageSourceEntity entity = null;
        if (pageSource != null) {
            entity = new PageSourceEntity();
            entity.setType(pageSource.getType());
            try {
                FetcherConfiguration fetcherConfiguration = this.getFetcher(pageSource).getConfiguration();
                if (removeSensitiveData) {
                    this.removeSensitiveData(fetcherConfiguration);
                }
                entity.setConfiguration(new ObjectMapper().valueToTree((Object)fetcherConfiguration));
            }
            catch (FetcherException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return entity;
    }

    private void removeSensitiveData(FetcherConfiguration fetcherConfiguration) {
        Field[] fields;
        for (Field field : fields = fetcherConfiguration.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Sensitive.class)) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(fetcherConfiguration, SENSITIVE_DATA_REPLACEMENT);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(accessible);
        }
    }

    private void mergeSensitiveData(FetcherConfiguration originalFetcherConfiguration, Page page) throws FetcherException {
        Field[] fields;
        FetcherConfiguration updatedFetcherConfiguration = this.getFetcher(page.getSource()).getConfiguration();
        boolean updated = false;
        for (Field field : fields = originalFetcherConfiguration.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Sensitive.class)) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object updatedValue = field.get(updatedFetcherConfiguration);
                if (updatedValue.equals(SENSITIVE_DATA_REPLACEMENT)) {
                    updated = true;
                    field.set(updatedFetcherConfiguration, field.get(originalFetcherConfiguration));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(accessible);
        }
        if (updated) {
            page.getSource().setConfiguration(new ObjectMapper().valueToTree((Object)updatedFetcherConfiguration).toString());
        }
    }

    private static boolean isJson(String content) {
        try {
            gson.fromJson(content, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public List<String> validateSafeContent(String content, PageType type) {
        OAIDescriptor openApiDescriptor;
        if (this.markdownSanitize && PageType.MARKDOWN.equals((Object)type)) {
            HtmlSanitizer.SanitizeInfos sanitizeInfos = HtmlSanitizer.isSafe(content);
            if (!sanitizeInfos.isSafe()) {
                throw new PageContentUnsafeException(sanitizeInfos.getRejectedMessage());
            }
        } else if (type != null && PageType.SWAGGER.equals((Object)type) && (openApiDescriptor = new OAIParser().parse(content)) != null && openApiDescriptor.getMessages() != null) {
            return openApiDescriptor.getMessages();
        }
        return new ArrayList<String>();
    }

    private void validateSafeSource(Page page) {
        Map map;
        if (this.importConfiguration.isAllowImportFromPrivate() || page.getSource() == null || page.getSource().getConfiguration() == null) {
            return;
        }
        PageSource source = page.getSource();
        try {
            map = (Map)new ObjectMapper().readValue(source.getConfiguration(), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e2) {
            throw new InvalidDataException("Source is invalid", e2);
        }
        Optional<String> urlOpt = map.entrySet().stream().filter(e -> ((String)e.getKey()).equals("repository") || ((String)e.getKey()).matches(".*[uU]rl")).map(Map.Entry::getValue).findFirst();
        if (!urlOpt.isPresent()) {
            return;
        }
        UrlSanitizerUtils.checkAllowed(urlOpt.get(), this.importConfiguration.getImportWhitelist(), false);
    }

    private void createAuditLog(String apiId, Audit.AuditEvent event, Date createdAt, Page oldValue, Page newValue) {
        String pageId;
        String string = pageId = oldValue != null ? oldValue.getId() : newValue.getId();
        if (apiId == null) {
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.PAGE, pageId), event, createdAt, oldValue, newValue);
        } else {
            this.auditService.createApiAuditLog(apiId, Collections.singletonMap(Audit.AuditProperties.PAGE, pageId), event, createdAt, oldValue, newValue);
        }
    }

    private PageCriteria queryToCriteria(PageQuery query) {
        PageCriteria.Builder builder = new PageCriteria.Builder();
        if (query != null) {
            builder.homepage(query.getHomepage());
            builder.api(query.getApi());
            builder.name(query.getName());
            builder.parent(query.getParent());
            builder.published(query.getPublished());
            if (query.getType() != null) {
                builder.type(query.getType().name());
            }
            builder.rootParent(query.getRootParent());
        }
        return builder.build();
    }
}

