/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.management.model.MetadataEntity;
import io.gravitee.management.model.NewMetadataEntity;
import io.gravitee.management.model.UpdateMetadataEntity;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.MetadataService;
import io.gravitee.management.service.exceptions.DuplicateMetadataNameException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataFormat;
import io.gravitee.repository.management.model.MetadataReferenceType;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Component
public class MetadataServiceImpl
extends TransactionalService
implements MetadataService {
    private final Logger LOGGER = LoggerFactory.getLogger(MetadataServiceImpl.class);
    private static final String DEFAULT_REFERENCE_ID = "_";
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private Configuration freemarkerConfiguration;

    @Override
    public List<MetadataEntity> findAllDefault() {
        try {
            this.LOGGER.debug("Find all metadata");
            return this.metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to find all metadata", (Throwable)ex);
            throw new TechnicalManagementException("An error occurred while trying to find all metadata", ex);
        }
    }

    @Override
    public MetadataEntity create(NewMetadataEntity metadataEntity) {
        if (metadataEntity.getFormat() == null) {
            metadataEntity.setFormat(io.gravitee.management.model.MetadataFormat.STRING);
        }
        try {
            Optional<MetadataEntity> optionalMetadata = this.findAllDefault().stream().filter(metadata -> metadataEntity.getName().equalsIgnoreCase(metadata.getName())).findAny();
            if (optionalMetadata.isPresent()) {
                throw new DuplicateMetadataNameException(optionalMetadata.get().getName());
            }
            this.checkMetadataFormat(metadataEntity.getFormat(), metadataEntity.getValue());
            Metadata metadata2 = this.convert(metadataEntity);
            Date now = new Date();
            metadata2.setCreatedAt(now);
            metadata2.setUpdatedAt(now);
            this.metadataRepository.create(metadata2);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.METADATA, metadata2.getKey()), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_CREATED, metadata2.getCreatedAt(), null, metadata2);
            return this.convert(metadata2);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to create metadata {}", (Object)metadataEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to create metadata " + metadataEntity.getName(), ex);
        }
    }

    @Override
    public MetadataEntity update(UpdateMetadataEntity metadataEntity) {
        try {
            Optional<Metadata> optionalMetadata = this.metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT).stream().filter(metadata -> !metadataEntity.getKey().equals(metadata.getKey()) && metadataEntity.getName().equalsIgnoreCase(metadata.getName())).findAny();
            if (optionalMetadata.isPresent()) {
                throw new DuplicateMetadataNameException(optionalMetadata.get().getName());
            }
            this.checkMetadataFormat(metadataEntity.getFormat(), metadataEntity.getValue());
            Metadata metadata2 = this.convert(metadataEntity);
            Date now = new Date();
            metadata2.setUpdatedAt(now);
            this.metadataRepository.update(metadata2);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.METADATA, metadata2.getKey()), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_UPDATED, metadata2.getCreatedAt(), null, metadata2);
            return this.convert(metadata2);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to update metadata {}", (Object)metadataEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to update metadata " + metadataEntity.getName(), ex);
        }
    }

    @Override
    public void delete(String key) {
        try {
            Optional optMetadata = this.metadataRepository.findById(key, DEFAULT_REFERENCE_ID, MetadataReferenceType.DEFAULT);
            if (optMetadata.isPresent()) {
                this.metadataRepository.delete(key, DEFAULT_REFERENCE_ID, MetadataReferenceType.DEFAULT);
                this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.METADATA, key), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_DELETED, new Date(), optMetadata.get(), null);
                List apiMetadata = this.metadataRepository.findByKeyAndReferenceType(key, MetadataReferenceType.API);
                for (Metadata metadata : apiMetadata) {
                    this.metadataRepository.delete(key, metadata.getReferenceId(), metadata.getReferenceType());
                    this.auditService.createApiAuditLog(metadata.getReferenceId(), Collections.singletonMap(Audit.AuditProperties.METADATA, key), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_DELETED, new Date(), metadata, null);
                }
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete metadata {}", (Object)key, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete metadata " + key, ex);
        }
    }

    @Override
    public MetadataEntity findDefaultByKey(String key) {
        try {
            this.LOGGER.debug("Find default metadata by key");
            Optional optMetadata = this.metadataRepository.findById(key, DEFAULT_REFERENCE_ID, MetadataReferenceType.DEFAULT);
            if (optMetadata.isPresent()) {
                return this.convert((Metadata)optMetadata.get());
            }
            return null;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to find default metadata by key", (Throwable)ex);
            throw new TechnicalManagementException("An error occurred while trying to find default metadata by key", ex);
        }
    }

    @Override
    public void checkMetadataFormat(io.gravitee.management.model.MetadataFormat format, String value) {
        this.checkMetadataFormat(format, value, null, null);
    }

    @Override
    public void checkMetadataFormat(io.gravitee.management.model.MetadataFormat format, String value, MetadataReferenceType referenceType, Object entity) {
        try {
            String decodedValue = value;
            if (entity != null && !StringUtils.isBlank((CharSequence)value) && value.startsWith("${")) {
                Template template = new Template(value, (Reader)new StringReader(value), this.freemarkerConfiguration);
                decodedValue = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, Collections.singletonMap(referenceType.name().toLowerCase(), entity));
            }
            if (StringUtils.isBlank((CharSequence)decodedValue)) {
                return;
            }
            switch (format) {
                case BOOLEAN: {
                    Boolean.valueOf(decodedValue);
                    break;
                }
                case URL: {
                    new URL(decodedValue);
                    break;
                }
                case MAIL: {
                    InternetAddress email = new InternetAddress(decodedValue);
                    email.validate();
                    break;
                }
                case DATE: {
                    SimpleDateFormat sdf = new SimpleDateFormat("YYYY-mm-dd");
                    sdf.setLenient(false);
                    sdf.parse(decodedValue);
                    break;
                }
                case NUMERIC: {
                    Double.valueOf(decodedValue);
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error occurred while trying to validate format '{}' of value '{}'", new Object[]{format, value, e});
            throw new TechnicalManagementException("Error occurred while trying to validate format " + format + " of value " + value, e);
        }
    }

    public void setFreemarkerConfiguration(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
    }

    private MetadataEntity convert(Metadata metadata) {
        MetadataEntity metadataEntity = new MetadataEntity();
        metadataEntity.setKey(metadata.getKey());
        metadataEntity.setName(metadata.getName());
        metadataEntity.setValue(metadata.getValue());
        metadataEntity.setFormat(io.gravitee.management.model.MetadataFormat.valueOf((String)metadata.getFormat().name()));
        return metadataEntity;
    }

    private Metadata convert(NewMetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(IdGenerator.generate((String)metadataEntity.getName()));
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (io.gravitee.management.model.MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(DEFAULT_REFERENCE_ID);
        metadata.setReferenceType(MetadataReferenceType.DEFAULT);
        return metadata;
    }

    private Metadata convert(UpdateMetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(metadataEntity.getKey());
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (io.gravitee.management.model.MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(DEFAULT_REFERENCE_ID);
        metadata.setReferenceType(MetadataReferenceType.DEFAULT);
        return metadata;
    }

    public static String getDefaultReferenceId() {
        return DEFAULT_REFERENCE_ID;
    }
}

