/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.management.model.EventEntity;
import io.gravitee.management.model.EventQuery;
import io.gravitee.management.model.EventType;
import io.gravitee.management.model.InstanceEntity;
import io.gravitee.management.model.InstanceListItem;
import io.gravitee.management.model.InstanceQuery;
import io.gravitee.management.model.InstanceState;
import io.gravitee.management.model.PluginEntity;
import io.gravitee.management.service.EventService;
import io.gravitee.management.service.InstanceService;
import io.gravitee.management.service.exceptions.EventNotFoundException;
import io.gravitee.management.service.exceptions.InstanceNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InstanceServiceImpl
implements InstanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceServiceImpl.class);
    @Autowired
    private EventService eventService;
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${gateway.unknown-expire-after:604800}")
    private long unknownExpireAfterInSec;
    private static final List<EventType> instancesAllState = new ArrayList<EventType>();
    private static final List<EventType> instancesRunningOnly = new ArrayList<EventType>();

    public InstanceServiceImpl() {
        instancesAllState.add(EventType.GATEWAY_STARTED);
        instancesAllState.add(EventType.GATEWAY_STOPPED);
        instancesRunningOnly.add(EventType.GATEWAY_STARTED);
    }

    @Override
    public Page<InstanceListItem> search(InstanceQuery query) {
        List<EventType> types = query.isIncludeStopped() ? instancesAllState : instancesRunningOnly;
        ExpiredPredicate filter = new ExpiredPredicate(Duration.ofSeconds(this.unknownExpireAfterInSec));
        return this.eventService.search(types, query.getProperties(), query.getFrom(), query.getTo(), query.getPage(), query.getSize(), new Function<EventEntity, InstanceListItem>(){

            @Override
            public InstanceListItem apply(EventEntity eventEntity) {
                InstanceEntity instanceEntity = InstanceServiceImpl.this.convert(eventEntity);
                InstanceListItem item = new InstanceListItem();
                item.setId(instanceEntity.getId());
                item.setEvent(instanceEntity.getEvent());
                item.setHostname(instanceEntity.getHostname());
                item.setIp(instanceEntity.getIp());
                item.setPort(instanceEntity.getPort());
                item.setLastHeartbeatAt(instanceEntity.getLastHeartbeatAt());
                item.setStartedAt(instanceEntity.getStartedAt());
                item.setStoppedAt(instanceEntity.getStoppedAt());
                item.setVersion(instanceEntity.getVersion());
                item.setTags(instanceEntity.getTags());
                item.setTenant(instanceEntity.getTenant());
                item.setOperatingSystemName((String)instanceEntity.getSystemProperties().get("os.name"));
                item.setState(instanceEntity.getState());
                return item;
            }
        }, filter);
    }

    @Override
    public InstanceEntity findById(String instanceId) {
        EventQuery query = new EventQuery();
        query.setId(instanceId);
        query.setTypes(instancesAllState);
        Collection<EventEntity> events = this.eventService.search(query);
        if (events == null || events.isEmpty()) {
            throw new InstanceNotFoundException(instanceId);
        }
        return this.convert(events.iterator().next());
    }

    @Override
    public InstanceEntity findByEvent(String eventId) {
        try {
            LOGGER.debug("Find instance by event ID: {}", (Object)eventId);
            EventEntity event = this.eventService.findById(eventId);
            return this.convert(event);
        }
        catch (EventNotFoundException enfe) {
            throw new InstanceNotFoundException(eventId);
        }
    }

    private InstanceEntity convert(EventEntity event) {
        Instant nowMinusXMinutes = Instant.now().minus(5L, ChronoUnit.MINUTES);
        Map props = event.getProperties();
        InstanceEntity instance = new InstanceEntity((String)props.get("id"));
        instance.setEvent(event.getId());
        instance.setLastHeartbeatAt(new Date(Long.parseLong((String)props.get("last_heartbeat_at"))));
        instance.setStartedAt(new Date(Long.parseLong((String)props.get("started_at"))));
        if (event.getPayload() != null) {
            try {
                InstanceInfo info = (InstanceInfo)this.objectMapper.readValue(event.getPayload(), InstanceInfo.class);
                instance.setHostname(info.getHostname());
                instance.setIp(info.getIp());
                instance.setPort(info.getPort());
                instance.setTenant(info.getTenant());
                instance.setVersion(info.getVersion());
                instance.setTags(info.getTags());
                instance.setSystemProperties(info.getSystemProperties());
                instance.setPlugins(info.getPlugins());
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while getting instance data from event payload", (Throwable)ioe);
            }
        }
        if (event.getType() == EventType.GATEWAY_STARTED) {
            Instant lastHeartbeat = Instant.ofEpochMilli(instance.getLastHeartbeatAt().getTime());
            if (lastHeartbeat.isAfter(nowMinusXMinutes)) {
                instance.setState(InstanceState.STARTED);
            } else {
                instance.setState(InstanceState.UNKNOWN);
            }
        } else {
            instance.setState(InstanceState.STOPPED);
            instance.setStoppedAt(new Date(Long.parseLong((String)props.get("stopped_at"))));
        }
        return instance;
    }

    public static final class ExpiredPredicate
    implements Predicate<InstanceListItem> {
        private Duration threshold;

        public ExpiredPredicate(Duration threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean test(InstanceListItem instance) {
            boolean result = true;
            if (instance.getState().equals((Object)InstanceState.UNKNOWN)) {
                Instant now = Instant.now();
                result = now.toEpochMilli() - instance.getLastHeartbeatAt().getTime() <= this.threshold.toMillis();
            }
            return result;
        }
    }

    private static class InstanceInfo {
        private String id;
        private String version;
        private List<String> tags;
        private Set<PluginEntity> plugins;
        private String hostname;
        private String ip;
        private String port;
        private String tenant;
        private Map<String, String> systemProperties;

        private InstanceInfo() {
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public Map<String, String> getSystemProperties() {
            return this.systemProperties;
        }

        public void setSystemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Set<PluginEntity> getPlugins() {
            return this.plugins;
        }

        public void setPlugins(Set<PluginEntity> plugins) {
            this.plugins = plugins;
        }

        public String getTenant() {
            return this.tenant;
        }

        public void setTenant(String tenant) {
            this.tenant = tenant;
        }
    }
}

