/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.definition.model.Endpoint;
import io.gravitee.management.model.InstanceEntity;
import io.gravitee.management.model.analytics.Analytics;
import io.gravitee.management.model.analytics.HistogramAnalytics;
import io.gravitee.management.model.analytics.Timestamp;
import io.gravitee.management.model.analytics.query.DateHistogramQuery;
import io.gravitee.management.model.analytics.query.LogQuery;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.healthcheck.ApiMetrics;
import io.gravitee.management.model.healthcheck.Request;
import io.gravitee.management.model.healthcheck.SearchLogResponse;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.HealthCheckService;
import io.gravitee.management.service.InstanceService;
import io.gravitee.management.service.exceptions.InstanceNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.analytics.query.AggregationType;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.response.histogram.Bucket;
import io.gravitee.repository.analytics.query.response.histogram.Data;
import io.gravitee.repository.healthcheck.api.HealthCheckRepository;
import io.gravitee.repository.healthcheck.query.DateHistogramQueryBuilder;
import io.gravitee.repository.healthcheck.query.FieldBucket;
import io.gravitee.repository.healthcheck.query.Query;
import io.gravitee.repository.healthcheck.query.QueryBuilders;
import io.gravitee.repository.healthcheck.query.availability.AvailabilityQuery;
import io.gravitee.repository.healthcheck.query.availability.AvailabilityQueryBuilder;
import io.gravitee.repository.healthcheck.query.availability.AvailabilityResponse;
import io.gravitee.repository.healthcheck.query.log.ExtendedLog;
import io.gravitee.repository.healthcheck.query.log.Log;
import io.gravitee.repository.healthcheck.query.log.LogsQueryBuilder;
import io.gravitee.repository.healthcheck.query.log.LogsResponse;
import io.gravitee.repository.healthcheck.query.log.Response;
import io.gravitee.repository.healthcheck.query.log.Step;
import io.gravitee.repository.healthcheck.query.response.histogram.DateHistogramResponse;
import io.gravitee.repository.healthcheck.query.responsetime.AverageResponseTimeQuery;
import io.gravitee.repository.healthcheck.query.responsetime.AverageResponseTimeQueryBuilder;
import io.gravitee.repository.healthcheck.query.responsetime.AverageResponseTimeResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckServiceImpl
implements HealthCheckService {
    private final Logger logger = LoggerFactory.getLogger(HealthCheckServiceImpl.class);
    @Autowired
    private HealthCheckRepository healthCheckRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private InstanceService instanceService;

    @Override
    public Analytics query(DateHistogramQuery query) {
        try {
            DateHistogramQueryBuilder queryBuilder = (DateHistogramQueryBuilder)((DateHistogramQueryBuilder)((DateHistogramQueryBuilder)QueryBuilders.dateHistogram().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier());
            if (query.getAggregations() != null) {
                query.getAggregations().stream().forEach(aggregation -> queryBuilder.aggregation(AggregationType.valueOf((String)aggregation.type().name()), aggregation.field()));
            }
            return this.convert((DateHistogramResponse)this.healthCheckRepository.query((Query)queryBuilder.build()));
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    private HistogramAnalytics convert(DateHistogramResponse histogramResponse) {
        HistogramAnalytics analytics = new HistogramAnalytics();
        List timestamps = histogramResponse.timestamps();
        if (timestamps != null && timestamps.size() > 1) {
            long from = (Long)timestamps.get(0);
            long interval = (Long)timestamps.get(1) - from;
            long to = (Long)timestamps.get(timestamps.size() - 1);
            analytics.setTimestamp(new Timestamp(Long.valueOf(from), Long.valueOf(to), Long.valueOf(interval)));
            ArrayList<io.gravitee.management.model.analytics.Bucket> buckets = new ArrayList<io.gravitee.management.model.analytics.Bucket>(histogramResponse.values().size());
            for (Bucket bucket : histogramResponse.values()) {
                io.gravitee.management.model.analytics.Bucket analyticsBucket = this.convertBucket(histogramResponse.timestamps(), from, interval, bucket);
                buckets.add(analyticsBucket);
            }
            analytics.setValues(buckets);
        }
        return analytics;
    }

    private io.gravitee.management.model.analytics.Bucket convertBucket(List<Long> timestamps, long from, long interval, Bucket bucket) {
        io.gravitee.management.model.analytics.Bucket analyticsBucket = new io.gravitee.management.model.analytics.Bucket();
        analyticsBucket.setName(bucket.name());
        analyticsBucket.setField(bucket.field());
        ArrayList<io.gravitee.management.model.analytics.Bucket> childBuckets = new ArrayList<io.gravitee.management.model.analytics.Bucket>();
        for (Bucket bucket2 : bucket.buckets()) {
            childBuckets.add(this.convertBucket(timestamps, from, interval, bucket2));
        }
        for (Map.Entry entry : bucket.data().entrySet()) {
            io.gravitee.management.model.analytics.Bucket analyticsDataBucket = new io.gravitee.management.model.analytics.Bucket();
            analyticsDataBucket.setName((String)entry.getKey());
            Number[] values = new Number[timestamps.size()];
            for (int i = 0; i < timestamps.size(); ++i) {
                values[i] = 0;
            }
            for (Data data : (List)entry.getValue()) {
                values[(int)((data.timestamp() - from) / interval)] = data.value();
            }
            analyticsDataBucket.setData(values);
            childBuckets.add(analyticsDataBucket);
        }
        analyticsBucket.setBuckets(childBuckets);
        return analyticsBucket;
    }

    @Override
    public ApiMetrics getAvailability(String api, String field) {
        this.logger.debug("Run health availability query for API '{}'", (Object)api);
        try {
            ApiEntity apiEntity = this.apiService.findById(api);
            AvailabilityResponse response = (AvailabilityResponse)this.healthCheckRepository.query((Query)((AvailabilityQueryBuilder)QueryBuilders.availability().api(api)).field(AvailabilityQuery.Field.valueOf((String)field)).build());
            return this.convert(apiEntity, response.getEndpointAvailabilities(), field);
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public ApiMetrics getResponseTime(String api, String field) {
        this.logger.debug("Run health response-time query for API '{}'", (Object)api);
        try {
            ApiEntity apiEntity = this.apiService.findById(api);
            AverageResponseTimeResponse response = (AverageResponseTimeResponse)this.healthCheckRepository.query((Query)((AverageResponseTimeQueryBuilder)QueryBuilders.responseTime().api(api)).field(AverageResponseTimeQuery.Field.valueOf((String)field)).build());
            return this.convert(apiEntity, response.getEndpointResponseTimes(), field);
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public SearchLogResponse findByApi(String api, LogQuery query, Boolean transition) {
        this.logger.debug("Run health logs query for API '{}'", (Object)api);
        try {
            LogsResponse response = (LogsResponse)this.healthCheckRepository.query((Query)((LogsQueryBuilder)((LogsQueryBuilder)QueryBuilders.logs().api(api)).page(query.getPage()).size(query.getSize()).query(query.getQuery())).transition(transition).from(query.getFrom()).to(query.getTo()).build());
            return this.convert(response);
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public io.gravitee.management.model.healthcheck.Log findLog(String id) {
        try {
            ExtendedLog log = this.healthCheckRepository.findById(id);
            return this.toLog(log);
        }
        catch (AnalyticsException ae) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ae);
            return null;
        }
    }

    private SearchLogResponse convert(LogsResponse response) {
        SearchLogResponse searchLogResponseResponse = new SearchLogResponse(response.getSize());
        searchLogResponseResponse.setLogs(response.getLogs().stream().map(this::toLog).collect(Collectors.toList()));
        if (response.getSize() > 0L) {
            HashMap metadata = new HashMap();
            searchLogResponseResponse.getLogs().forEach(logItem -> {
                String gateway = logItem.getGateway();
                if (gateway != null) {
                    metadata.computeIfAbsent(gateway, this::getGatewayMetadata);
                }
            });
            searchLogResponseResponse.setMetadata(metadata);
        }
        return searchLogResponseResponse;
    }

    private <T extends Number> ApiMetrics<T> convert(final ApiEntity api, List<FieldBucket<T>> response, final String field) {
        final ApiMetrics apiMetrics = new ApiMetrics();
        final HashMap buckets = new HashMap();
        response.forEach(new Consumer<FieldBucket<T>>(){

            @Override
            public void accept(FieldBucket<T> bucket) {
                Map<String, Number> bucketMetrics = bucket.getValues().stream().collect(Collectors.toMap(io.gravitee.repository.healthcheck.query.Bucket::getKey, io.gravitee.repository.healthcheck.query.Bucket::getValue));
                buckets.put(bucket.getName(), bucketMetrics);
            }
        });
        apiMetrics.setBuckets(buckets);
        if (!apiMetrics.getBuckets().isEmpty()) {
            final HashMap values = new HashMap();
            apiMetrics.getBuckets().values().forEach(new Consumer<Map<String, T>>(){

                @Override
                public void accept(Map<String, T> stringTMap) {
                    stringTMap.entrySet().forEach(new Consumer<Map.Entry<String, T>>(){

                        @Override
                        public void accept(Map.Entry<String, T> stringTEntry) {
                            Number value = (Number)stringTEntry.getValue();
                            Double total = values.getOrDefault(stringTEntry.getKey(), 0.0);
                            total = total + value.doubleValue();
                            values.put(stringTEntry.getKey(), total);
                        }
                    });
                }
            });
            values.entrySet().forEach(new Consumer<Map.Entry<String, Double>>(){

                @Override
                public void accept(Map.Entry<String, Double> stringDoubleEntry) {
                    values.put(stringDoubleEntry.getKey(), stringDoubleEntry.getValue() / (double)apiMetrics.getBuckets().size());
                }
            });
            apiMetrics.setGlobal(values);
        }
        final HashMap metadata = new HashMap();
        apiMetrics.getBuckets().keySet().forEach(new Consumer<String>(){

            @Override
            public void accept(String name) {
                if (field.equalsIgnoreCase("endpoint")) {
                    metadata.put(name, HealthCheckServiceImpl.this.getEndpointMetadata(api, name));
                } else if (field.equalsIgnoreCase("gateway")) {
                    metadata.put(name, HealthCheckServiceImpl.this.getGatewayMetadata(name));
                }
            }
        });
        apiMetrics.setMetadata(metadata);
        return apiMetrics;
    }

    private io.gravitee.management.model.healthcheck.Log toLog(Log repoLog) {
        io.gravitee.management.model.healthcheck.Log log = new io.gravitee.management.model.healthcheck.Log();
        log.setId(repoLog.getId());
        log.setTimestamp(repoLog.getTimestamp());
        log.setAvailable(repoLog.isAvailable());
        log.setSuccess(repoLog.isSuccess());
        log.setEndpoint(repoLog.getEndpoint());
        log.setGateway(repoLog.getGateway());
        log.setResponseTime(repoLog.getResponseTime());
        log.setState(repoLog.getState());
        Request request = new Request();
        request.setMethod(repoLog.getMethod());
        request.setUri(repoLog.getUri());
        log.setRequest(request);
        io.gravitee.management.model.healthcheck.Response response = new io.gravitee.management.model.healthcheck.Response();
        response.setStatus(repoLog.getStatus());
        log.setResponse(response);
        return log;
    }

    private io.gravitee.management.model.healthcheck.Log toLog(ExtendedLog repoLog) {
        io.gravitee.management.model.healthcheck.Log log = new io.gravitee.management.model.healthcheck.Log();
        log.setId(repoLog.getId());
        log.setTimestamp(repoLog.getTimestamp());
        log.setAvailable(repoLog.isAvailable());
        log.setSuccess(repoLog.isSuccess());
        log.setEndpoint(repoLog.getEndpoint());
        log.setGateway(repoLog.getGateway());
        log.setResponseTime(repoLog.getResponseTime());
        log.setState(repoLog.getState());
        log.setMessage(((Step)repoLog.getSteps().get(0)).getMessage());
        log.setRequest(this.createRequest(((Step)repoLog.getSteps().get(0)).getRequest()));
        log.setResponse(this.createResponse(((Step)repoLog.getSteps().get(0)).getResponse()));
        return log;
    }

    private Request createRequest(io.gravitee.repository.healthcheck.query.log.Request repoRequest) {
        if (repoRequest == null) {
            return null;
        }
        Request request = new Request();
        request.setUri(repoRequest.getUri());
        request.setMethod(repoRequest.getMethod());
        request.setHeaders((Map)repoRequest.getHeaders());
        request.setBody(repoRequest.getBody());
        return request;
    }

    private io.gravitee.management.model.healthcheck.Response createResponse(Response repoResponse) {
        if (repoResponse == null) {
            return null;
        }
        io.gravitee.management.model.healthcheck.Response response = new io.gravitee.management.model.healthcheck.Response();
        response.setStatus(repoResponse.getStatus());
        response.setHeaders((Map)repoResponse.getHeaders());
        response.setBody(repoResponse.getBody());
        return response;
    }

    private Map<String, String> getEndpointMetadata(ApiEntity api, String endpointName) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Optional<Endpoint> endpointOpt = api.getProxy().getGroups().stream().filter(group -> group.getEndpoints() != null).flatMap(group -> group.getEndpoints().stream()).filter(endpoint -> endpoint.getName().equalsIgnoreCase(endpointName)).findFirst();
        if (endpointOpt.isPresent()) {
            metadata.put("target", endpointOpt.get().getTarget());
        } else {
            metadata.put("deleted", "true");
        }
        return metadata;
    }

    private Map<String, String> getGatewayMetadata(String gateway) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            InstanceEntity instance = this.instanceService.findById(gateway);
            metadata.put("hostname", instance.getHostname());
            metadata.put("ip", instance.getIp());
            if (instance.getTenant() != null) {
                metadata.put("tenant", instance.getTenant());
            }
        }
        catch (InstanceNotFoundException infe) {
            metadata.put("deleted", "true");
        }
        return metadata;
    }
}

