/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.fetcher.api.FilesFetcher;
import io.gravitee.management.model.FetcherEntity;
import io.gravitee.management.model.PluginEntity;
import io.gravitee.management.service.FetcherService;
import io.gravitee.management.service.exceptions.FetcherNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FetcherServiceImpl
extends TransactionalService
implements FetcherService {
    private final Logger LOGGER = LoggerFactory.getLogger(FetcherServiceImpl.class);
    @Autowired
    private ConfigurablePluginManager<FetcherPlugin> fetcherPluginManager;

    @Override
    public Set<FetcherEntity> findAll() {
        return this.findAll(false);
    }

    @Override
    public Set<FetcherEntity> findAll(boolean onlyFilesFetchers) {
        try {
            this.LOGGER.debug("List all fetchers");
            List<Object> fetcherDefinitions = new ArrayList(this.fetcherPluginManager.findAll());
            if (onlyFilesFetchers) {
                Class<FilesFetcher> filesFetcherClass = FilesFetcher.class;
                fetcherDefinitions = fetcherDefinitions.stream().filter(fetcherPlugin -> filesFetcherClass.isAssignableFrom(fetcherPlugin.fetcher())).collect(Collectors.toList());
            }
            return fetcherDefinitions.stream().map(fetcherDefinition -> this.convert((FetcherPlugin)fetcherDefinition, false)).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to list all fetchers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all fetchers", ex);
        }
    }

    @Override
    public FetcherEntity findById(String fetcher) {
        this.LOGGER.debug("Find fetcher by ID: {}", (Object)fetcher);
        FetcherPlugin fetcherDefinition = (FetcherPlugin)this.fetcherPluginManager.get(fetcher);
        if (fetcherDefinition == null) {
            throw new FetcherNotFoundException(fetcher);
        }
        return this.convert(fetcherDefinition, true);
    }

    @Override
    public String getSchema(String fetcher) {
        try {
            this.LOGGER.debug("Find fetcher schema by ID: {}", (Object)fetcher);
            return this.fetcherPluginManager.getSchema(fetcher);
        }
        catch (IOException ioex) {
            this.LOGGER.error("An error occurs while trying to get fetcher's schema for fetcher {}", (Object)fetcher, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get fetcher's schema for fetcher " + fetcher, ioex);
        }
    }

    private FetcherEntity convert(FetcherPlugin fetcherPlugin, boolean withPlugin) {
        FetcherEntity entity = new FetcherEntity();
        entity.setId(fetcherPlugin.id());
        entity.setDescription(fetcherPlugin.manifest().description());
        entity.setName(fetcherPlugin.manifest().name());
        entity.setVersion(fetcherPlugin.manifest().version());
        if (withPlugin) {
            FetcherPlugin plugin = fetcherPlugin;
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setPlugin(plugin.clazz());
            pluginEntity.setPath(plugin.path().toString());
            pluginEntity.setType(plugin.type().toString().toLowerCase());
            pluginEntity.setDependencies(plugin.dependencies());
            entity.setPlugin(pluginEntity);
        }
        return entity;
    }
}

