/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.EntrypointEntity;
import io.gravitee.management.model.NewEntryPointEntity;
import io.gravitee.management.model.UpdateEntryPointEntity;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.EntrypointService;
import io.gravitee.management.service.exceptions.EntrypointNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EntrypointRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Entrypoint;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntrypointServiceImpl
extends TransactionalService
implements EntrypointService {
    private final Logger LOGGER = LoggerFactory.getLogger(EntrypointServiceImpl.class);
    private static final String SEPARATOR = ";";
    @Autowired
    private AuditService auditService;
    @Autowired
    private EntrypointRepository entrypointRepository;

    @Override
    public EntrypointEntity findById(String entrypointId) {
        try {
            this.LOGGER.debug("Find by id {}", (Object)entrypointId);
            Optional optionalEntryPoint = this.entrypointRepository.findById((Object)entrypointId);
            if (!optionalEntryPoint.isPresent()) {
                throw new EntrypointNotFoundException(entrypointId);
            }
            return this.convert((Entrypoint)optionalEntryPoint.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all entrypoints", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all entrypoints", ex);
        }
    }

    @Override
    public List<EntrypointEntity> findAll() {
        try {
            this.LOGGER.debug("Find all APIs");
            return this.entrypointRepository.findAll().stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all entrypoints", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all entrypoints", ex);
        }
    }

    @Override
    public EntrypointEntity create(NewEntryPointEntity entrypointEntity) {
        try {
            Entrypoint entrypoint = this.convert(entrypointEntity);
            EntrypointEntity savedEntryPoint = this.convert((Entrypoint)this.entrypointRepository.create((Object)entrypoint));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ENTRYPOINT, entrypoint.getId()), (Audit.AuditEvent)Entrypoint.AuditEvent.ENTRYPOINT_CREATED, new Date(), null, entrypoint);
            return savedEntryPoint;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create entrypoint {}", (Object)entrypointEntity.getValue(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create entrypoint " + entrypointEntity.getValue(), ex);
        }
    }

    @Override
    public EntrypointEntity update(UpdateEntryPointEntity entrypointEntity) {
        try {
            Optional entrypointOptional = this.entrypointRepository.findById((Object)entrypointEntity.getId());
            if (entrypointOptional.isPresent()) {
                Entrypoint entrypoint = this.convert(entrypointEntity);
                EntrypointEntity savedEntryPoint = this.convert((Entrypoint)this.entrypointRepository.update((Object)entrypoint));
                this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ENTRYPOINT, entrypoint.getId()), (Audit.AuditEvent)Entrypoint.AuditEvent.ENTRYPOINT_UPDATED, new Date(), entrypointOptional.get(), entrypoint);
                return savedEntryPoint;
            }
            throw new EntrypointNotFoundException(entrypointEntity.getId());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update entrypoint {}", (Object)entrypointEntity.getValue(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update entrypoint " + entrypointEntity.getValue(), ex);
        }
    }

    @Override
    public void delete(String entrypointId) {
        try {
            Optional entrypointOptional = this.entrypointRepository.findById((Object)entrypointId);
            if (!entrypointOptional.isPresent()) {
                throw new EntrypointNotFoundException(entrypointId);
            }
            this.entrypointRepository.delete((Object)entrypointId);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ENTRYPOINT, entrypointId), (Audit.AuditEvent)Entrypoint.AuditEvent.ENTRYPOINT_DELETED, new Date(), null, entrypointOptional.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete entrypoint {}", (Object)entrypointId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete entrypoint " + entrypointId, ex);
        }
    }

    private Entrypoint convert(NewEntryPointEntity entrypointEntity) {
        Entrypoint entrypoint = new Entrypoint();
        entrypoint.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        entrypoint.setValue(entrypointEntity.getValue());
        entrypoint.setTags(String.join((CharSequence)SEPARATOR, entrypointEntity.getTags()));
        return entrypoint;
    }

    private Entrypoint convert(UpdateEntryPointEntity entrypointEntity) {
        Entrypoint entrypoint = new Entrypoint();
        entrypoint.setId(entrypointEntity.getId());
        entrypoint.setValue(entrypointEntity.getValue());
        entrypoint.setTags(String.join((CharSequence)SEPARATOR, entrypointEntity.getTags()));
        return entrypoint;
    }

    private EntrypointEntity convert(Entrypoint entrypoint) {
        EntrypointEntity entrypointEntity = new EntrypointEntity();
        entrypointEntity.setId(entrypoint.getId());
        entrypointEntity.setValue(entrypoint.getValue());
        entrypointEntity.setTags(entrypoint.getTags().split(SEPARATOR));
        return entrypointEntity;
    }
}

