/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.quality.ApiQualityRuleEntity;
import io.gravitee.management.model.quality.NewApiQualityRuleEntity;
import io.gravitee.management.model.quality.UpdateApiQualityRuleEntity;
import io.gravitee.management.service.ApiQualityRuleService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.exceptions.ApiQualityRuleAlreadyExistsException;
import io.gravitee.management.service.exceptions.ApiQualityRuleNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.model.ApiQualityRule;
import io.gravitee.repository.management.model.Audit;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiQualityRuleServiceImpl
extends AbstractService
implements ApiQualityRuleService {
    private final Logger LOGGER = LoggerFactory.getLogger(ApiQualityRuleServiceImpl.class);
    @Autowired
    private ApiQualityRuleRepository apiQualityRuleRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public List<ApiQualityRuleEntity> findByApi(String api) {
        try {
            this.LOGGER.debug("Find quality rules by API");
            return this.apiQualityRuleRepository.findByApi(api).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find quality rules by API";
            this.LOGGER.error("An error occurs while trying to find quality rules by API", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find quality rules by API", ex);
        }
    }

    @Override
    public ApiQualityRuleEntity create(NewApiQualityRuleEntity newEntity) {
        try {
            Optional optionalApiQualityRule = this.apiQualityRuleRepository.findById(newEntity.getApi(), newEntity.getQualityRule());
            if (optionalApiQualityRule.isPresent()) {
                throw new ApiQualityRuleAlreadyExistsException(newEntity.getApi(), newEntity.getQualityRule());
            }
            ApiQualityRule apiQualityRule = this.convert(newEntity);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.API_QUALITY_RULE, apiQualityRule.getApi()), (Audit.AuditEvent)ApiQualityRule.AuditEvent.API_QUALITY_RULE_CREATED, apiQualityRule.getCreatedAt(), null, apiQualityRule);
            return this.convert(this.apiQualityRuleRepository.create(apiQualityRule));
        }
        catch (TechnicalException e) {
            String error = "An error occurs while trying to create an API quality rule " + newEntity;
            this.LOGGER.error(error, (Throwable)e);
            throw new TechnicalManagementException(error, e);
        }
    }

    @Override
    public ApiQualityRuleEntity update(UpdateApiQualityRuleEntity updateEntity) {
        try {
            Optional optionalApiQualityRule = this.apiQualityRuleRepository.findById(updateEntity.getApi(), updateEntity.getQualityRule());
            if (!optionalApiQualityRule.isPresent()) {
                throw new ApiQualityRuleNotFoundException(updateEntity.getApi(), updateEntity.getQualityRule());
            }
            ApiQualityRule apiQualityRule = this.apiQualityRuleRepository.update(this.convert(updateEntity));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.API_QUALITY_RULE, apiQualityRule.getApi()), (Audit.AuditEvent)ApiQualityRule.AuditEvent.API_QUALITY_RULE_UPDATED, apiQualityRule.getUpdatedAt(), optionalApiQualityRule.get(), apiQualityRule);
            return this.convert(apiQualityRule);
        }
        catch (TechnicalException e) {
            String error = "An error occurs while trying to update API quality rule " + updateEntity;
            this.LOGGER.error(error, (Throwable)e);
            throw new TechnicalManagementException(error, e);
        }
    }

    private ApiQualityRuleEntity convert(ApiQualityRule apiQualityRule) {
        ApiQualityRuleEntity entity = new ApiQualityRuleEntity();
        entity.setApi(apiQualityRule.getApi());
        entity.setQualityRule(apiQualityRule.getQualityRule());
        entity.setChecked(apiQualityRule.isChecked());
        entity.setCreatedAt(apiQualityRule.getCreatedAt());
        entity.setUpdatedAt(apiQualityRule.getUpdatedAt());
        return entity;
    }

    private ApiQualityRule convert(NewApiQualityRuleEntity apiQualityRuleEntity) {
        ApiQualityRule apiQualityRule = new ApiQualityRule();
        apiQualityRule.setApi(apiQualityRuleEntity.getApi());
        apiQualityRule.setQualityRule(apiQualityRuleEntity.getQualityRule());
        apiQualityRule.setChecked(apiQualityRuleEntity.isChecked());
        Date now = new Date();
        apiQualityRule.setCreatedAt(now);
        apiQualityRule.setUpdatedAt(now);
        return apiQualityRule;
    }

    private ApiQualityRule convert(UpdateApiQualityRuleEntity apiQualityRuleEntity) {
        ApiQualityRule apiQualityRule = new ApiQualityRule();
        apiQualityRule.setApi(apiQualityRuleEntity.getApi());
        apiQualityRule.setQualityRule(apiQualityRuleEntity.getQualityRule());
        apiQualityRule.setChecked(apiQualityRuleEntity.isChecked());
        Date now = new Date();
        apiQualityRule.setCreatedAt(now);
        apiQualityRule.setUpdatedAt(now);
        return apiQualityRule;
    }
}

