/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.api.header.ApiHeaderEntity;
import io.gravitee.management.model.api.header.NewApiHeaderEntity;
import io.gravitee.management.model.api.header.UpdateApiHeaderEntity;
import io.gravitee.management.service.ApiHeaderService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.exceptions.ApiHeaderNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiHeaderRepository;
import io.gravitee.repository.management.model.ApiHeader;
import io.gravitee.repository.management.model.Audit;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiHeaderServiceImpl
extends TransactionalService
implements ApiHeaderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiHeaderServiceImpl.class);
    @Autowired
    private ApiHeaderRepository apiHeaderRepository;
    @Autowired
    AuditService auditService;

    @Override
    public ApiHeaderEntity create(NewApiHeaderEntity newEntity) {
        try {
            int order = this.apiHeaderRepository.findAll().size() + 1;
            ApiHeader apiHeader = new ApiHeader();
            apiHeader.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
            apiHeader.setName(newEntity.getName());
            apiHeader.setValue(newEntity.getValue());
            apiHeader.setOrder(order);
            apiHeader.setCreatedAt(new Date());
            apiHeader.setUpdatedAt(apiHeader.getCreatedAt());
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.API_HEADER, apiHeader.getId()), (Audit.AuditEvent)ApiHeader.AuditEvent.API_HEADER_CREATED, apiHeader.getCreatedAt(), null, apiHeader);
            return this.convert((ApiHeader)this.apiHeaderRepository.create((Object)apiHeader));
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to create a header {}", (Object)newEntity, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to create a header " + newEntity, e);
        }
    }

    @Override
    public void delete(String apiHeaderId) {
        try {
            Optional optionalApiHeader = this.apiHeaderRepository.findById((Object)apiHeaderId);
            if (!optionalApiHeader.isPresent()) {
                throw new ApiHeaderNotFoundException(apiHeaderId);
            }
            this.apiHeaderRepository.delete((Object)apiHeaderId);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.API_HEADER, apiHeaderId), (Audit.AuditEvent)ApiHeader.AuditEvent.API_HEADER_DELETED, new Date(), optionalApiHeader.get(), null);
            int currentOrder = 1;
            for (ApiHeaderEntity apiHeaderEntity : this.findAll()) {
                if (apiHeaderEntity.getOrder() != currentOrder) {
                    UpdateApiHeaderEntity updateEntity = this.convert(apiHeaderEntity);
                    updateEntity.setOrder(currentOrder);
                    this.update(updateEntity);
                    break;
                }
                ++currentOrder;
            }
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to delete a header {}", (Object)apiHeaderId, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to delete a header " + apiHeaderId, e);
        }
    }

    @Override
    public ApiHeaderEntity update(UpdateApiHeaderEntity updateEntity) {
        try {
            Optional optionalApiHeader = this.apiHeaderRepository.findById((Object)updateEntity.getId());
            if (!optionalApiHeader.isPresent()) {
                throw new ApiHeaderNotFoundException(updateEntity.getId());
            }
            ApiHeader updatedHeader = new ApiHeader((ApiHeader)optionalApiHeader.get());
            Date updatedAt = new Date();
            updatedHeader.setName(updateEntity.getName());
            updatedHeader.setValue(updateEntity.getValue());
            updatedHeader.setUpdatedAt(updatedAt);
            if (updatedHeader.getOrder() != updateEntity.getOrder()) {
                updatedHeader.setOrder(updateEntity.getOrder());
                this.reorderAndSave(updatedHeader);
                return this.convert(updatedHeader);
            }
            ApiHeader header = (ApiHeader)this.apiHeaderRepository.update((Object)updatedHeader);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.API_HEADER, header.getId()), (Audit.AuditEvent)ApiHeader.AuditEvent.API_HEADER_UPDATED, header.getUpdatedAt(), optionalApiHeader.get(), header);
            return this.convert(header);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to update header {}", (Object)updateEntity, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to update header " + updateEntity, e);
        }
    }

    @Override
    public List<ApiHeaderEntity> findAll() {
        try {
            return this.apiHeaderRepository.findAll().stream().sorted(Comparator.comparingInt(ApiHeader::getOrder)).map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to find all header", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to find all header", e);
        }
    }

    private void reorderAndSave(ApiHeader headerToReorder) throws TechnicalException {
        ApiHeader[] headers = (ApiHeader[])this.apiHeaderRepository.findAll().stream().filter(h -> !Objects.equals(h.getId(), headerToReorder.getId())).sorted(Comparator.comparingInt(ApiHeader::getOrder)).toArray(ApiHeader[]::new);
        if (headerToReorder.getOrder() < 1) {
            headerToReorder.setOrder(1);
        } else if (headerToReorder.getOrder() > headers.length + 1) {
            headerToReorder.setOrder(headers.length + 1);
        }
        for (int i = 0; i < headers.length; ++i) {
            int newOrder;
            int n = newOrder = i + 1 < headerToReorder.getOrder() ? i + 1 : i + 2;
            if (headers[i].getOrder() == newOrder) continue;
            headers[i].setOrder(newOrder);
            this.apiHeaderRepository.update((Object)headers[i]);
        }
        this.apiHeaderRepository.update((Object)headerToReorder);
    }

    @Override
    public void createDefault() {
        NewApiHeaderEntity h = new NewApiHeaderEntity();
        h.setName("api.version");
        h.setValue("${api.version}");
        this.create(h);
        h.setName("api.endpoint");
        h.setValue("${api.proxy.contextPath}");
        this.create(h);
        h.setName("api.owner");
        h.setValue("${api.primaryOwner.displayName}");
        this.create(h);
        h.setName("api.publishedAt");
        h.setValue("${(api.deployedAt?date)!}");
        this.create(h);
    }

    private ApiHeaderEntity convert(ApiHeader apiHeader) {
        ApiHeaderEntity entity = new ApiHeaderEntity();
        entity.setId(apiHeader.getId());
        entity.setName(apiHeader.getName());
        entity.setValue(apiHeader.getValue());
        entity.setOrder(apiHeader.getOrder());
        entity.setCreatedAt(apiHeader.getCreatedAt());
        entity.setUpdatedAt(apiHeader.getUpdatedAt());
        return entity;
    }

    private UpdateApiHeaderEntity convert(ApiHeaderEntity entity) {
        UpdateApiHeaderEntity updateApiHeaderEntity = new UpdateApiHeaderEntity();
        updateApiHeaderEntity.setId(entity.getId());
        updateApiHeaderEntity.setName(entity.getName());
        updateApiHeaderEntity.setOrder(entity.getOrder());
        updateApiHeaderEntity.setValue(entity.getValue());
        return updateApiHeaderEntity;
    }
}

