/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.TenantEntity;
import io.gravitee.management.model.analytics.HistogramAnalytics;
import io.gravitee.management.model.analytics.HitsAnalytics;
import io.gravitee.management.model.analytics.StatsAnalytics;
import io.gravitee.management.model.analytics.Timestamp;
import io.gravitee.management.model.analytics.TopHitsAnalytics;
import io.gravitee.management.model.analytics.query.CountQuery;
import io.gravitee.management.model.analytics.query.DateHistogramQuery;
import io.gravitee.management.model.analytics.query.GroupByQuery;
import io.gravitee.management.model.analytics.query.StatsQuery;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.api.ApiLifecycleState;
import io.gravitee.management.service.AnalyticsService;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.TenantService;
import io.gravitee.management.service.exceptions.ApiNotFoundException;
import io.gravitee.management.service.exceptions.ApplicationNotFoundException;
import io.gravitee.management.service.exceptions.PlanNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.TenantNotFoundException;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.analytics.api.AnalyticsRepository;
import io.gravitee.repository.analytics.query.AggregationType;
import io.gravitee.repository.analytics.query.DateHistogramQueryBuilder;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.Order;
import io.gravitee.repository.analytics.query.Query;
import io.gravitee.repository.analytics.query.QueryBuilders;
import io.gravitee.repository.analytics.query.SortBuilder;
import io.gravitee.repository.analytics.query.SortType;
import io.gravitee.repository.analytics.query.count.CountQueryBuilder;
import io.gravitee.repository.analytics.query.count.CountResponse;
import io.gravitee.repository.analytics.query.groupby.GroupByQueryBuilder;
import io.gravitee.repository.analytics.query.groupby.GroupByResponse;
import io.gravitee.repository.analytics.query.response.histogram.Bucket;
import io.gravitee.repository.analytics.query.response.histogram.Data;
import io.gravitee.repository.analytics.query.response.histogram.DateHistogramResponse;
import io.gravitee.repository.analytics.query.stats.StatsQueryBuilder;
import io.gravitee.repository.analytics.query.stats.StatsResponse;
import io.gravitee.repository.management.model.ApplicationStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsServiceImpl
implements AnalyticsService {
    private final Logger logger = LoggerFactory.getLogger(AnalyticsServiceImpl.class);
    private static final String UNKNOWN_SERVICE = "1";
    private static final String UNKNOWN_SERVICE_MAPPED = "?";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_VERSION = "version";
    private static final String METADATA_UNKNOWN_API_NAME = "Unknown API (not found)";
    private static final String METADATA_UNKNOWN_APPLICATION_NAME = "Unknown application (keyless)";
    private static final String METADATA_UNKNOWN_PLAN_NAME = "Unknown plan (keyless)";
    private static final String METADATA_DELETED_API_NAME = "Deleted API";
    private static final String METADATA_DELETED_APPLICATION_NAME = "Deleted application";
    private static final String METADATA_DELETED_TENANT_NAME = "Deleted tenant";
    private static final String METADATA_DELETED_PLAN_NAME = "Deleted plan";
    private static final String FIELD_API = "api";
    private static final String FIELD_APPLICATION = "application";
    private static final String FIELD_TENANT = "tenant";
    private static final String FIELD_PLAN = "plan";
    private static final String FIELD_GEOIP_COUNTRY_ISO_CODE = "geoip.country_iso_code";
    @Autowired
    private AnalyticsRepository analyticsRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private PlanService planService;
    @Autowired
    private TenantService tenantService;

    @Override
    public StatsAnalytics execute(StatsQuery query) {
        try {
            StatsResponse response = (StatsResponse)this.analyticsRepository.query((Query)((StatsQueryBuilder)((StatsQueryBuilder)((StatsQueryBuilder)QueryBuilders.stats().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).field(query.getField()).build());
            return this.convert(response, query);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    @Override
    public HitsAnalytics execute(CountQuery query) {
        try {
            CountResponse response = (CountResponse)this.analyticsRepository.query((Query)((CountQueryBuilder)((CountQueryBuilder)((CountQueryBuilder)QueryBuilders.count().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).build());
            return this.convert(response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    @Override
    public HistogramAnalytics execute(DateHistogramQuery query) {
        try {
            DateHistogramQueryBuilder queryBuilder = (DateHistogramQueryBuilder)((DateHistogramQueryBuilder)((DateHistogramQueryBuilder)QueryBuilders.dateHistogram().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier());
            if (query.getAggregations() != null) {
                query.getAggregations().stream().forEach(aggregation -> queryBuilder.aggregation(AggregationType.valueOf((String)aggregation.type().name()), aggregation.field()));
            }
            DateHistogramResponse response = (DateHistogramResponse)this.analyticsRepository.query((Query)queryBuilder.build());
            return this.convert(response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    @Override
    public TopHitsAnalytics execute(GroupByQuery query) {
        try {
            GroupByQueryBuilder queryBuilder = ((GroupByQueryBuilder)((GroupByQueryBuilder)((GroupByQueryBuilder)QueryBuilders.groupBy().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).field(query.getField());
            if (query.getGroups() != null) {
                query.getGroups().forEach((arg_0, arg_1) -> ((GroupByQueryBuilder)queryBuilder).range(arg_0, arg_1));
            }
            if (query.getOrder() != null) {
                GroupByQuery.Order order = query.getOrder();
                queryBuilder.sort(SortBuilder.on((String)order.getField(), (Order)(order.isOrder() ? Order.ASC : Order.DESC), (SortType)(order.getType() == null ? SortType.AVG : SortType.valueOf((String)order.getType().toUpperCase()))));
            }
            GroupByResponse response = (GroupByResponse)this.analyticsRepository.query((Query)queryBuilder.build());
            return this.convert(response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    private HistogramAnalytics convert(DateHistogramResponse histogramResponse) {
        HistogramAnalytics analytics = new HistogramAnalytics();
        List timestamps = histogramResponse.timestamps();
        if (timestamps != null && timestamps.size() > 1) {
            long from = (Long)timestamps.get(0);
            long interval = (Long)timestamps.get(1) - from;
            long to = (Long)timestamps.get(timestamps.size() - 1);
            analytics.setTimestamp(new Timestamp(Long.valueOf(from), Long.valueOf(to), Long.valueOf(interval)));
            ArrayList<io.gravitee.management.model.analytics.Bucket> buckets = new ArrayList<io.gravitee.management.model.analytics.Bucket>(histogramResponse.values().size());
            for (Bucket bucket : histogramResponse.values()) {
                io.gravitee.management.model.analytics.Bucket analyticsBucket = this.convertBucket(histogramResponse.timestamps(), from, interval, bucket);
                buckets.add(analyticsBucket);
            }
            analytics.setValues(buckets);
        }
        return analytics;
    }

    private io.gravitee.management.model.analytics.Bucket convertBucket(List<Long> timestamps, long from, long interval, Bucket bucket) {
        HashMap metadata;
        io.gravitee.management.model.analytics.Bucket analyticsBucket = new io.gravitee.management.model.analytics.Bucket();
        analyticsBucket.setName(bucket.name());
        analyticsBucket.setField(bucket.field());
        ArrayList<io.gravitee.management.model.analytics.Bucket> childBuckets = new ArrayList<io.gravitee.management.model.analytics.Bucket>();
        for (Bucket bucket2 : bucket.buckets()) {
            childBuckets.add(this.convertBucket(timestamps, from, interval, bucket2));
        }
        if (FIELD_APPLICATION.equals(analyticsBucket.getField())) {
            metadata = new HashMap();
            bucket.data().keySet().forEach(app -> metadata.put(app, this.getApplicationMetadata((String)app)));
            analyticsBucket.setMetadata(metadata);
        } else if (FIELD_API.equals(analyticsBucket.getField())) {
            metadata = new HashMap();
            bucket.data().keySet().forEach(api -> metadata.put(api, this.getAPIMetadata((String)api)));
            analyticsBucket.setMetadata(metadata);
        } else if (FIELD_TENANT.equals(analyticsBucket.getField())) {
            metadata = new HashMap();
            bucket.data().keySet().forEach(tenant -> metadata.put(tenant, this.getTenantMetadata((String)tenant)));
            analyticsBucket.setMetadata(metadata);
        }
        for (Map.Entry entry : bucket.data().entrySet()) {
            io.gravitee.management.model.analytics.Bucket analyticsDataBucket = new io.gravitee.management.model.analytics.Bucket();
            analyticsDataBucket.setName((String)entry.getKey());
            Number[] values = new Number[timestamps.size()];
            for (int i = 0; i < timestamps.size(); ++i) {
                values[i] = 0;
            }
            for (Data data : (List)entry.getValue()) {
                values[(int)((data.timestamp() - from) / interval)] = data.value();
            }
            analyticsDataBucket.setData(values);
            childBuckets.add(analyticsDataBucket);
        }
        analyticsBucket.setBuckets(childBuckets);
        return analyticsBucket;
    }

    private StatsAnalytics convert(StatsResponse statsResponse, StatsQuery query) {
        StatsAnalytics statsAnalytics = new StatsAnalytics();
        statsAnalytics.setAvg(statsResponse.getAvg());
        statsAnalytics.setCount(statsResponse.getCount());
        statsAnalytics.setMax(statsResponse.getMax());
        statsAnalytics.setMin(statsResponse.getMin());
        statsAnalytics.setSum(statsResponse.getSum());
        if (statsResponse.getCount() != null) {
            long numberOfSeconds = (query.getTo() - query.getFrom()) / 1000L;
            statsAnalytics.setRps(Float.valueOf(statsResponse.getCount().floatValue() / (float)numberOfSeconds));
            statsAnalytics.setRpm(Float.valueOf(statsResponse.getCount().floatValue() / (float)numberOfSeconds * 60.0f));
            statsAnalytics.setRph(Float.valueOf(statsResponse.getCount().floatValue() / (float)numberOfSeconds * 3600.0f));
        }
        return statsAnalytics;
    }

    private HitsAnalytics convert(CountResponse countResponse) {
        HitsAnalytics hitsAnalytics = new HitsAnalytics();
        hitsAnalytics.setHits(countResponse.getCount());
        return hitsAnalytics;
    }

    private TopHitsAnalytics convert(GroupByResponse groupByResponse) {
        TopHitsAnalytics topHitsAnalytics = new TopHitsAnalytics();
        topHitsAnalytics.setValues((Map)groupByResponse.values().stream().collect(Collectors.toMap(bucket -> UNKNOWN_SERVICE.equals(bucket.name()) ? UNKNOWN_SERVICE_MAPPED : bucket.name(), GroupByResponse.Bucket::value, (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
        }, LinkedHashMap::new)));
        String fieldName = groupByResponse.getField();
        if (fieldName != null && !fieldName.isEmpty()) {
            HashMap<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
            if (topHitsAnalytics.getValues() != null) {
                int i = 0;
                for (String key : topHitsAnalytics.getValues().keySet()) {
                    switch (fieldName) {
                        case "api": {
                            metadata.put(key, this.getAPIMetadata(key));
                            break;
                        }
                        case "application": {
                            metadata.put(key, this.getApplicationMetadata(key));
                            break;
                        }
                        case "plan": {
                            metadata.put(key, this.getPlanMetadata(key));
                            break;
                        }
                        case "tenant": {
                            metadata.put(key, this.getTenantMetadata(key));
                            break;
                        }
                        case "geoip.country_iso_code": {
                            metadata.put(key, this.getCountryName(key));
                            break;
                        }
                        default: {
                            metadata.put(key, this.getGenericMetadata(key));
                        }
                    }
                    ((Map)metadata.get(key)).put("order", String.valueOf(i));
                    ++i;
                }
            }
            topHitsAnalytics.setMetadata(metadata);
        }
        return topHitsAnalytics;
    }

    private Map<String, String> getAPIMetadata(String api) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            if (api.equals(UNKNOWN_SERVICE) || api.equals(UNKNOWN_SERVICE_MAPPED)) {
                metadata.put(METADATA_NAME, METADATA_UNKNOWN_API_NAME);
                metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
            } else {
                ApiEntity apiEntity = this.apiService.findById(api);
                metadata.put(METADATA_NAME, apiEntity.getName());
                metadata.put(METADATA_VERSION, apiEntity.getVersion());
                if (ApiLifecycleState.ARCHIVED.equals((Object)apiEntity.getLifecycleState())) {
                    metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                }
            }
        }
        catch (ApiNotFoundException anfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_API_NAME);
        }
        return metadata;
    }

    private Map<String, String> getApplicationMetadata(String application) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            if (application.equals(UNKNOWN_SERVICE) || application.equals(UNKNOWN_SERVICE_MAPPED)) {
                metadata.put(METADATA_NAME, METADATA_UNKNOWN_APPLICATION_NAME);
                metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
            } else {
                ApplicationEntity applicationEntity = this.applicationService.findById(application);
                metadata.put(METADATA_NAME, applicationEntity.getName());
                if (ApplicationStatus.ARCHIVED.toString().equals(applicationEntity.getStatus())) {
                    metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                }
            }
        }
        catch (ApplicationNotFoundException anfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_APPLICATION_NAME);
        }
        return metadata;
    }

    private Map<String, String> getPlanMetadata(String plan) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            if (plan.equals(UNKNOWN_SERVICE) || plan.equals(UNKNOWN_SERVICE_MAPPED)) {
                metadata.put(METADATA_NAME, METADATA_UNKNOWN_PLAN_NAME);
                metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
            } else {
                PlanEntity planEntity = this.planService.findById(plan);
                metadata.put(METADATA_NAME, planEntity.getName());
            }
        }
        catch (PlanNotFoundException anfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_PLAN_NAME);
        }
        return metadata;
    }

    private Map<String, String> getTenantMetadata(String tenant) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            TenantEntity tenantEntity = this.tenantService.findById(tenant);
            metadata.put(METADATA_NAME, tenantEntity.getName());
        }
        catch (TenantNotFoundException tnfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_TENANT_NAME);
        }
        return metadata;
    }

    private Map<String, String> getCountryName(String country_iso) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(METADATA_NAME, new Locale("", country_iso).getDisplayCountry(Locale.UK));
        return metadata;
    }

    private Map<String, String> getGenericMetadata(String value) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(METADATA_NAME, value);
        return metadata;
    }
}

