/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.idp.api.authentication.UserDetails;
import io.gravitee.management.model.permissions.RoleScope;
import io.gravitee.management.model.permissions.SystemRole;
import io.gravitee.management.service.impl.TransactionalService;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractService
extends TransactionalService {
    public static final String MANAGEMENT_ADMIN = RoleScope.MANAGEMENT.name() + ':' + SystemRole.ADMIN.name();
    public static final String PORTAL_ADMIN = RoleScope.PORTAL.name() + ':' + SystemRole.ADMIN.name();

    String getAuthenticatedUsername() {
        UserDetails authenticatedUser = this.getAuthenticatedUser();
        return authenticatedUser == null ? null : authenticatedUser.getUsername();
    }

    UserDetails getAuthenticatedUser() {
        if (this.isAuthenticated()) {
            return (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        return null;
    }

    protected boolean isAuthenticated() {
        return SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof UserDetails;
    }

    protected boolean isAdmin() {
        return this.isUserInRole(MANAGEMENT_ADMIN) || this.isUserInRole(PORTAL_ADMIN);
    }

    private boolean isUserInRole(String role) {
        return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(auth -> role.equals(auth.getAuthority()));
    }
}

