/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service;

import io.gravitee.management.model.ApiModelEntity;
import io.gravitee.management.model.EventType;
import io.gravitee.management.model.ImportSwaggerDescriptorEntity;
import io.gravitee.management.model.InlinePictureEntity;
import io.gravitee.management.model.ReviewEntity;
import io.gravitee.management.model.Visibility;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.api.ApiQuery;
import io.gravitee.management.model.api.DuplicateApiEntity;
import io.gravitee.management.model.api.NewApiEntity;
import io.gravitee.management.model.api.SwaggerApiEntity;
import io.gravitee.management.model.api.UpdateApiEntity;
import io.gravitee.management.model.api.header.ApiHeaderEntity;
import io.gravitee.repository.exceptions.TechnicalException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ApiService {
    public ApiEntity findById(String var1);

    public Set<ApiEntity> findAll();

    public Set<ApiEntity> findAllLight();

    public Set<ApiEntity> findByUser(String var1, ApiQuery var2);

    public Set<ApiEntity> findByVisibility(Visibility var1);

    public ApiEntity create(NewApiEntity var1, String var2);

    public ApiEntity create(SwaggerApiEntity var1, String var2, ImportSwaggerDescriptorEntity var3);

    public ApiEntity update(String var1, UpdateApiEntity var2);

    public ApiEntity update(String var1, SwaggerApiEntity var2, ImportSwaggerDescriptorEntity var3);

    public void delete(String var1);

    public ApiEntity start(String var1, String var2);

    public ApiEntity stop(String var1, String var2);

    public boolean isSynchronized(String var1);

    public ApiEntity deploy(String var1, String var2, EventType var3);

    public ApiEntity rollback(String var1, UpdateApiEntity var2);

    public String exportAsJson(String var1, String var2, String ... var3);

    public ApiEntity createOrUpdateWithDefinition(ApiEntity var1, String var2, String var3);

    public InlinePictureEntity getPicture(String var1);

    public byte[] getDefaultPicture();

    public void deleteViewFromAPIs(String var1);

    public void deleteTagFromAPIs(String var1);

    public ApiModelEntity findByIdForTemplates(String var1, boolean var2);

    default public ApiModelEntity findByIdForTemplates(String apiId) {
        return this.findByIdForTemplates(apiId, false);
    }

    public boolean exists(String var1);

    public ApiEntity importPathMappingsFromPage(ApiEntity var1, String var2);

    public static UpdateApiEntity convert(ApiEntity apiEntity) {
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        updateApiEntity.setProxy(apiEntity.getProxy());
        updateApiEntity.setVersion(apiEntity.getVersion());
        updateApiEntity.setName(apiEntity.getName());
        updateApiEntity.setProperties(apiEntity.getProperties());
        updateApiEntity.setDescription(apiEntity.getDescription());
        updateApiEntity.setGroups(apiEntity.getGroups());
        updateApiEntity.setPaths(apiEntity.getPaths());
        updateApiEntity.setPicture(apiEntity.getPicture());
        updateApiEntity.setResources(apiEntity.getResources());
        updateApiEntity.setTags(apiEntity.getTags());
        updateApiEntity.setServices(apiEntity.getServices());
        updateApiEntity.setVisibility(apiEntity.getVisibility());
        updateApiEntity.setLabels(apiEntity.getLabels());
        updateApiEntity.setPathMappings(apiEntity.getPathMappings());
        updateApiEntity.setLifecycleState(apiEntity.getLifecycleState());
        return updateApiEntity;
    }

    public Collection<ApiEntity> search(ApiQuery var1);

    public Collection<ApiEntity> search(String var1, Map<String, Object> var2) throws TechnicalException;

    public List<ApiHeaderEntity> getPortalHeaders(String var1);

    public ApiEntity askForReview(String var1, String var2, ReviewEntity var3);

    public ApiEntity acceptReview(String var1, String var2, ReviewEntity var3);

    public ApiEntity rejectReview(String var1, String var2, ReviewEntity var3);

    public ApiEntity duplicate(ApiEntity var1, DuplicateApiEntity var2);
}

