/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.search.query;

import io.gravitee.management.model.common.Pageable;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.search.query.Query;
import java.util.Map;

public class QueryBuilder<T extends Indexable> {
    private final Query<T> query;

    private QueryBuilder(Class<T> root) {
        this.query = new Query<T>(root);
    }

    public static <S extends Indexable> QueryBuilder<S> create(Class<S> root) {
        return new QueryBuilder<S>(root);
    }

    public QueryBuilder<T> setQuery(String query) {
        this.query.setQuery(query);
        return this;
    }

    public QueryBuilder<T> addFilter(String name, Object value) {
        this.query.getFilters().put(name, value);
        return this;
    }

    public QueryBuilder<T> removeFilter(String name) {
        this.query.getFilters().remove(name);
        return this;
    }

    public QueryBuilder<T> setFilters(Map<String, Object> filters) {
        this.query.setFilters(filters);
        return this;
    }

    public QueryBuilder<T> setPage(Pageable pageable) {
        this.query.setPage(pageable);
        return this;
    }

    public Query<T> build() {
        return this.query;
    }
}

