/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.plaftform.plugins;

import io.gravitee.management.model.platform.plugin.PluginEntity;
import io.gravitee.management.service.ServiceDiscoveryService;
import io.gravitee.management.service.exceptions.ServiceDiscoveryNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.discovery.ServiceDiscoveryPlugin;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDiscoveryServiceImpl
extends TransactionalService
implements ServiceDiscoveryService {
    private final Logger LOGGER = LoggerFactory.getLogger(ServiceDiscoveryServiceImpl.class);
    @Autowired
    private ConfigurablePluginManager<ServiceDiscoveryPlugin> serviceDiscoveryPluginManager;

    @Override
    public Set<PluginEntity> findAll() {
        try {
            this.LOGGER.debug("List all service discovery plugins");
            Collection plugins = this.serviceDiscoveryPluginManager.findAll();
            return plugins.stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to list all service discovery plugins", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all service discovery plugins", ex);
        }
    }

    @Override
    public PluginEntity findById(String pluginId) {
        this.LOGGER.debug("Find service discovery plugin by ID: {}", (Object)pluginId);
        ServiceDiscoveryPlugin plugin = (ServiceDiscoveryPlugin)this.serviceDiscoveryPluginManager.get(pluginId);
        if (plugin == null) {
            throw new ServiceDiscoveryNotFoundException(pluginId);
        }
        return this.convert((Plugin)plugin);
    }

    @Override
    public String getSchema(String pluginId) {
        try {
            this.LOGGER.debug("Find service discovery plugin schema by ID: {}", (Object)pluginId);
            return this.serviceDiscoveryPluginManager.getSchema(pluginId);
        }
        catch (IOException ioex) {
            this.LOGGER.error("An error occurs while trying to get service discovery plugin's schema for plugin {}", (Object)pluginId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get service discovery plugin's schema for plugin " + pluginId, ioex);
        }
    }

    private PluginEntity convert(Plugin plugin) {
        PluginEntity entity = new PluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        return entity;
    }
}

