/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.upgrade;

import io.gravitee.management.model.ViewEntity;
import io.gravitee.management.service.Upgrader;
import io.gravitee.management.service.ViewService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultViewUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultViewUpgrader.class);
    @Autowired
    private ViewService viewService;

    @Override
    public boolean upgrade() {
        Optional<ViewEntity> optionalAllView = this.viewService.findAll().stream().filter(v -> v.getId().equals("all")).findFirst();
        if (!optionalAllView.isPresent()) {
            this.logger.info("Create default View");
            this.viewService.createDefaultView();
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 200;
    }
}

