/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.transformer;

import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.lucene.DocumentTransformer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Component;

@Component
public class ApiDocumentTransformer
implements DocumentTransformer {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_TYPE_VALUE = "api";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NAME_LOWERCASE = "name_lowercase";
    private static final String FIELD_NAME_SPLIT = "name_split";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_OWNER = "ownerName";
    private static final String FIELD_OWNER_MAIL = "ownerMail";
    private static final String FIELD_LABELS = "labels";
    private static final String FIELD_VIEWS = "views";
    private static final String FIELD_CREATED_AT = "createdAt";
    private static final String FIELD_UPDATED_AT = "updatedAt";
    private static final String FIELD_PATH = "path";
    private static final String FIELD_PATH_SPLIT = "path_split";
    private static final String FIELD_TAGS = "tags";

    @Override
    public Document transform(Indexable indexable) {
        Document doc = new Document();
        ApiEntity api = (ApiEntity)indexable;
        doc.add((IndexableField)new StringField(FIELD_ID, api.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_TYPE, FIELD_TYPE_VALUE, Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_NAME, api.getName(), Field.Store.NO));
        doc.add((IndexableField)new StringField(FIELD_NAME_LOWERCASE, api.getName().toLowerCase(), Field.Store.NO));
        doc.add((IndexableField)new TextField(FIELD_NAME_SPLIT, api.getName(), Field.Store.NO));
        doc.add((IndexableField)new TextField(FIELD_DESCRIPTION, api.getDescription(), Field.Store.NO));
        doc.add((IndexableField)new TextField(FIELD_OWNER, api.getPrimaryOwner().getDisplayName(), Field.Store.NO));
        if (api.getPrimaryOwner().getEmail() != null) {
            doc.add((IndexableField)new TextField(FIELD_OWNER_MAIL, api.getPrimaryOwner().getEmail(), Field.Store.NO));
        }
        doc.add((IndexableField)new StringField(FIELD_PATH, api.getProxy().getContextPath(), Field.Store.NO));
        doc.add((IndexableField)new TextField(FIELD_PATH_SPLIT, api.getProxy().getContextPath(), Field.Store.NO));
        if (api.getLabels() != null) {
            for (String label : api.getLabels()) {
                doc.add((IndexableField)new TextField(FIELD_LABELS, label, Field.Store.NO));
            }
        }
        if (api.getViews() != null) {
            for (String view : api.getViews()) {
                doc.add((IndexableField)new TextField(FIELD_VIEWS, view, Field.Store.NO));
            }
        }
        if (api.getTags() != null) {
            for (String tag : api.getTags()) {
                doc.add((IndexableField)new TextField(FIELD_TAGS, tag, Field.Store.NO));
            }
        }
        doc.add((IndexableField)new LongPoint(FIELD_CREATED_AT, new long[]{api.getCreatedAt().getTime()}));
        doc.add((IndexableField)new LongPoint(FIELD_UPDATED_AT, new long[]{api.getUpdatedAt().getTime()}));
        return doc;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return ApiEntity.class.isAssignableFrom(source);
    }
}

