/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.searcher;

import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.repository.exceptions.TechnicalException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class UserDocumentSearcher
extends AbstractDocumentSearcher {
    protected static final String FIELD_TYPE_VALUE = "user";

    @Override
    public SearchResult search(io.gravitee.management.service.search.query.Query query) throws TechnicalException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"firstname", "lastname", "displayname", "displayname_split", "email"}, this.analyzer);
        parser.setFuzzyMinSim(0.6f);
        parser.setAllowLeadingWildcard(true);
        try {
            Query parse = parser.parse(QueryParserBase.escape((String)query.getQuery()));
            BooleanQuery.Builder userQuery = new BooleanQuery.Builder();
            BooleanQuery.Builder userFieldsQuery = new BooleanQuery.Builder();
            userFieldsQuery.add(parse, BooleanClause.Occur.SHOULD);
            userFieldsQuery.add((Query)new WildcardQuery(new Term("firstname", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            userFieldsQuery.add((Query)new WildcardQuery(new Term("lastname", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            userFieldsQuery.add((Query)new WildcardQuery(new Term("displayname", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            userFieldsQuery.add((Query)new WildcardQuery(new Term("email", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            userQuery.add((Query)userFieldsQuery.build(), BooleanClause.Occur.MUST);
            userQuery.add((Query)new TermQuery(new Term("type", FIELD_TYPE_VALUE)), BooleanClause.Occur.MUST);
            return this.search((Query)userQuery.build(), query.getPage());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for user documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for user documents", (Throwable)pe);
        }
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(UserEntity.class);
    }
}

