/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.searcher;

import io.gravitee.management.model.common.Pageable;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.impl.search.lucene.DocumentSearcher;
import io.gravitee.management.service.impl.search.lucene.analyzer.CustomWhitespaceAnalyzer;
import io.gravitee.repository.exceptions.TechnicalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDocumentSearcher
implements DocumentSearcher {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_TYPE = "type";
    protected Analyzer analyzer = new CustomWhitespaceAnalyzer();
    @Autowired
    protected IndexWriter indexWriter;

    protected SearchResult search(Query query) throws TechnicalException {
        return this.search(query, null);
    }

    protected SearchResult search(Query query, Pageable pageable) throws TechnicalException {
        this.logger.debug("Searching for: {}", (Object)query.toString());
        try {
            TopDocs topDocs;
            IndexSearcher searcher = this.getIndexSearcher();
            if (pageable != null) {
                TopScoreDocCollector collector = TopScoreDocCollector.create((int)1000);
                searcher.search(query, (Collector)collector);
                topDocs = collector.topDocs((pageable.getPageNumber() - 1) * pageable.getPageSize(), pageable.getPageSize());
            } else {
                topDocs = searcher.search(query, Integer.MAX_VALUE);
            }
            ScoreDoc[] hits = topDocs.scoreDocs;
            ArrayList<String> results = new ArrayList<String>();
            this.logger.debug("Found {} total matching documents", (Object)topDocs.totalHits);
            if (hits.length > 0) {
                for (ScoreDoc hit : hits) {
                    results.add(this.getReference(searcher.doc(hit.doc)));
                }
            }
            return new SearchResult(results.stream().distinct().collect(Collectors.toList()), topDocs.totalHits);
        }
        catch (IOException ioe) {
            this.logger.error("An error occurs while getting documents from search result", (Throwable)ioe);
            throw new TechnicalException("An error occurs while getting documents from search result", (Throwable)ioe);
        }
    }

    protected String getReference(Document document) {
        return document.get(FIELD_ID);
    }

    private IndexSearcher getIndexSearcher() throws IOException {
        return new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.indexWriter));
    }
}

