/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.management.model.ApiPageEntity;
import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.command.CommandSearchIndexerEntity;
import io.gravitee.management.model.command.CommandTags;
import io.gravitee.management.model.command.NewCommandEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.CommandService;
import io.gravitee.management.service.PageService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.impl.search.lucene.DocumentSearcher;
import io.gravitee.management.service.impl.search.lucene.DocumentTransformer;
import io.gravitee.management.service.impl.search.lucene.SearchEngineIndexer;
import io.gravitee.management.service.search.SearchEngineService;
import io.gravitee.management.service.search.query.Query;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.MessageRecipient;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SearchEngineServiceImpl
implements SearchEngineService {
    private final Logger logger = LoggerFactory.getLogger(SearchEngineServiceImpl.class);
    @Autowired
    private SearchEngineIndexer indexer;
    @Autowired
    private Collection<DocumentTransformer> transformers;
    @Autowired
    private Collection<DocumentSearcher> searchers;
    @Autowired
    @Lazy
    private CommandService commandService;
    @Autowired
    @Lazy
    private ApiService apiService;
    @Autowired
    @Lazy
    private PageService pageService;
    @Autowired
    @Lazy
    private UserService userService;
    private ObjectMapper mapper = new ObjectMapper();
    private static final String ACTION_INDEX = "I";
    private static final String ACTION_DELETE = "D";

    @Override
    @Async
    public void index(Indexable source, boolean locally) {
        if (locally) {
            this.indexLocally(source);
        } else {
            CommandSearchIndexerEntity content = new CommandSearchIndexerEntity();
            content.setAction(ACTION_INDEX);
            content.setId(source.getId());
            content.setClazz(source.getClass().getName());
            this.sendCommands(content);
        }
    }

    @Override
    @Async
    public void delete(Indexable source, boolean locally) {
        if (locally) {
            this.deleteLocally(source);
        } else {
            CommandSearchIndexerEntity content = new CommandSearchIndexerEntity();
            content.setAction(ACTION_DELETE);
            content.setId(source.getId());
            content.setClazz(source.getClass().getName());
            this.sendCommands(content);
        }
    }

    private void sendCommands(CommandSearchIndexerEntity content) {
        try {
            NewCommandEntity msg = new NewCommandEntity();
            msg.setTags(Collections.singletonList(CommandTags.DATA_TO_INDEX));
            msg.setTo(MessageRecipient.MANAGEMENT_APIS.name());
            msg.setTtlInSeconds(60L);
            msg.setContent(this.mapper.writeValueAsString((Object)content));
            this.commandService.send(msg);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Unexpected error while sending a message", (Throwable)e);
        }
    }

    @Override
    public void process(CommandSearchIndexerEntity content) {
        Indexable source = this.getSource(content.getClazz(), content.getId());
        if (source == null) {
            this.logger.error("Unable to get source from message content [{}]", (Object)content);
            throw new TechnicalManagementException("Unable to get source from message content [" + content + "]");
        }
        if (ACTION_DELETE.equals(content.getAction())) {
            this.deleteLocally(source);
        } else if (ACTION_INDEX.equals(content.getAction())) {
            this.indexLocally(source);
        }
    }

    private Indexable getSource(String clazz, String id) {
        if (ApiEntity.class.getName().equals(clazz)) {
            return this.apiService.findById(id);
        }
        if (PageEntity.class.getName().equals(clazz) || ApiPageEntity.class.getName().equals(clazz)) {
            return this.pageService.findById(id);
        }
        if (UserEntity.class.getName().equals(clazz)) {
            return this.userService.findById(id);
        }
        return null;
    }

    private void indexLocally(Indexable source) {
        this.transformers.stream().filter(transformer -> transformer.handle(source.getClass())).findFirst().ifPresent(transformer -> {
            try {
                this.indexer.index(transformer.transform(source));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while indexing a document", (Throwable)te);
            }
        });
    }

    private void deleteLocally(Indexable source) {
        this.transformers.stream().filter(transformer -> transformer.handle(source.getClass())).findFirst().ifPresent(transformer -> {
            try {
                this.indexer.remove(transformer.transform(source));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while deleting a document", (Throwable)te);
            }
        });
    }

    @Override
    public SearchResult search(Query<? extends Indexable> query) {
        Optional results = this.searchers.stream().filter(searcher -> searcher.handle(query.getRoot())).findFirst().flatMap(searcher -> {
            try {
                return Optional.of(searcher.search(query));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while deleting a document", (Throwable)te);
                return Optional.empty();
            }
        });
        return (SearchResult)results.get();
    }
}

