/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.SubscriptionEntity;
import io.gravitee.management.model.SubscriptionStatus;
import io.gravitee.management.model.TaskEntity;
import io.gravitee.management.model.TaskType;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.pagedresult.Metadata;
import io.gravitee.management.model.permissions.ApiPermission;
import io.gravitee.management.model.subscription.SubscriptionQuery;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.SubscriptionService;
import io.gravitee.management.service.TaskService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UnauthorizedAccessException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskServiceImpl
extends AbstractService
implements TaskService {
    private final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    ApiService apiService;
    @Autowired
    SubscriptionService subscriptionService;
    @Autowired
    ApplicationService applicationService;
    @Autowired
    MembershipRepository membershipRepository;
    @Autowired
    ApiRepository apiRepository;
    @Autowired
    RoleService roleService;
    @Autowired
    PlanService planService;

    @Override
    public List<TaskEntity> findAll(String userId) {
        if (userId == null) {
            throw new UnauthorizedAccessException();
        }
        try {
            Set memberships = this.membershipRepository.findByUserAndReferenceType(userId, MembershipReferenceType.GROUP);
            memberships.addAll(this.membershipRepository.findByUserAndReferenceType(userId, MembershipReferenceType.API));
            HashMap<String, RoleEntity> roleNameToEntity = new HashMap<String, RoleEntity>();
            HashSet<String> apiIds = new HashSet<String>();
            ArrayList<String> groupIds = new ArrayList<String>();
            for (Membership membership : memberships) {
                String roleName = (String)membership.getRoles().get(RoleScope.API.getId());
                if (roleName == null) continue;
                RoleEntity roleEntity = (RoleEntity)roleNameToEntity.get(roleName);
                if (roleEntity == null) {
                    roleEntity = this.roleService.findById(RoleScope.API, roleName);
                    roleNameToEntity.put(roleName, roleEntity);
                }
                block7: for (char c : (char[])roleEntity.getPermissions().get(ApiPermission.SUBSCRIPTION.getName())) {
                    if (c != 'U') continue;
                    switch (membership.getReferenceType()) {
                        case GROUP: {
                            groupIds.add(membership.getReferenceId());
                            continue block7;
                        }
                        case API: {
                            apiIds.add(membership.getReferenceId());
                            continue block7;
                        }
                    }
                }
            }
            if (!groupIds.isEmpty()) {
                apiIds.addAll(this.apiRepository.search(new ApiCriteria.Builder().groups(groupIds.toArray(new String[0])).build()).stream().map(Api::getId).collect(Collectors.toSet()));
            }
            if (apiIds.isEmpty()) {
                return Collections.emptyList();
            }
            SubscriptionQuery query = new SubscriptionQuery();
            query.setStatuses(Collections.singleton(SubscriptionStatus.PENDING));
            query.setApis(apiIds);
            return this.subscriptionService.search(query).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error retreiving user tasks {}", (Object)e.getMessage());
            throw new TechnicalManagementException("Error retreiving user tasks", e);
        }
    }

    @Override
    public Metadata getMetadata(List<TaskEntity> tasks) {
        Metadata metadata = new Metadata();
        tasks.forEach(task -> {
            SubscriptionEntity subscription = (SubscriptionEntity)task.getData();
            if (!metadata.containsKey(subscription.getApplication())) {
                ApplicationEntity applicationEntity = this.applicationService.findById(subscription.getApplication());
                metadata.put(subscription.getApplication(), "name", (Object)applicationEntity.getName());
            }
            if (!metadata.containsKey(subscription.getPlan())) {
                PlanEntity planEntity = this.planService.findById(subscription.getPlan());
                String apiId = (String)planEntity.getApis().iterator().next();
                ApiEntity api = this.apiService.findById(apiId);
                metadata.put(subscription.getPlan(), "name", (Object)planEntity.getName());
                metadata.put(subscription.getPlan(), "api", (Object)apiId);
                metadata.put(apiId, "name", (Object)api.getName());
            }
        });
        return metadata;
    }

    private TaskEntity convert(SubscriptionEntity subscription) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.SUBSCRIPTION_APPROVAL);
            taskEntity.setCreatedAt(subscription.getCreatedAt());
            taskEntity.setData((Object)subscription);
        }
        catch (Exception e) {
            this.LOGGER.error("Error converting subscription {} to a Task", (Object)subscription.getId());
            throw new TechnicalManagementException("Error converting subscription " + subscription.getId() + " to a Task", e);
        }
        return taskEntity;
    }
}

