/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.NewRoleEntity;
import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.UpdateRoleEntity;
import io.gravitee.management.model.permissions.ApiPermission;
import io.gravitee.management.model.permissions.ApplicationPermission;
import io.gravitee.management.model.permissions.GroupPermission;
import io.gravitee.management.model.permissions.ManagementPermission;
import io.gravitee.management.model.permissions.Permission;
import io.gravitee.management.model.permissions.PortalPermission;
import io.gravitee.management.model.permissions.RolePermissionAction;
import io.gravitee.management.model.permissions.SystemRole;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.exceptions.DefaultRoleNotFoundException;
import io.gravitee.management.service.exceptions.RoleAlreadyExistsException;
import io.gravitee.management.service.exceptions.RoleDeletionForbiddenException;
import io.gravitee.management.service.exceptions.RoleNotFoundException;
import io.gravitee.management.service.exceptions.RoleReservedNameException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
extends AbstractService
implements RoleService {
    private final Logger LOGGER = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private AuditService auditService;

    @Override
    public RoleEntity findById(RoleScope scope, String name) {
        try {
            this.LOGGER.debug("Find Role by id");
            Optional role = this.roleRepository.findById(scope, name);
            if (!role.isPresent()) {
                throw new RoleNotFoundException(scope, name);
            }
            return this.convert((Role)role.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find a role : {} {}", new Object[]{scope, name, ex});
            throw new TechnicalManagementException("An error occurs while trying to find a role : " + scope + " " + name, ex);
        }
    }

    @Override
    public List<RoleEntity> findAll() {
        try {
            this.LOGGER.debug("Find all Roles");
            return this.roleRepository.findAll().stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all roles", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all roles", ex);
        }
    }

    @Override
    public RoleEntity create(NewRoleEntity roleEntity) {
        try {
            Role role = this.convert(roleEntity);
            if (this.roleRepository.findById(role.getScope(), role.getName()).isPresent()) {
                throw new RoleAlreadyExistsException(role.getScope(), role.getName());
            }
            role.setCreatedAt(new Date());
            role.setUpdatedAt(role.getCreatedAt());
            RoleEntity entity = this.convert(this.roleRepository.create(role));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, role.getScope() + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_CREATED, role.getCreatedAt(), null, role);
            if (entity.isDefaultRole()) {
                this.toggleDefaultRole(this.convert(roleEntity.getScope()), entity.getName());
            }
            return entity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create role {}", (Object)roleEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create role " + roleEntity.getName(), ex);
        }
    }

    private boolean permissionsAreDifferent(Role role1, Role role2) {
        return Arrays.stream(role1.getPermissions()).reduce(Math::addExact).orElse(0) != Arrays.stream(role2.getPermissions()).reduce(Math::addExact).orElse(0);
    }

    private void createOrUpdateSystemRole(SystemRole roleName, RoleScope roleScope, io.gravitee.management.model.permissions.RoleScope permRoleScope, Permission[] permissions) throws TechnicalException {
        Role systemRole = this.createSystemRoleWithoutPermissions(roleName.name(), roleScope, new Date());
        HashMap<String, char[]> perms = new HashMap<String, char[]>();
        for (Permission perm : permissions) {
            perms.put(perm.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
        }
        systemRole.setPermissions(this.convertPermissions(permRoleScope, perms));
        Optional existingRole = this.roleRepository.findById(systemRole.getScope(), systemRole.getName());
        if (existingRole.isPresent() && this.permissionsAreDifferent((Role)existingRole.get(), systemRole)) {
            this.roleRepository.update(systemRole);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, systemRole.getScope() + ":" + systemRole.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, systemRole.getCreatedAt(), existingRole, systemRole);
        } else if (!existingRole.isPresent()) {
            this.roleRepository.create(systemRole);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, systemRole.getScope() + ":" + systemRole.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_CREATED, systemRole.getCreatedAt(), null, systemRole);
        }
    }

    @Override
    public void createOrUpdateSystemRoles() {
        try {
            this.createOrUpdateSystemRole(SystemRole.ADMIN, RoleScope.MANAGEMENT, io.gravitee.management.model.permissions.RoleScope.MANAGEMENT, (Permission[])ManagementPermission.values());
            this.createOrUpdateSystemRole(SystemRole.ADMIN, RoleScope.PORTAL, io.gravitee.management.model.permissions.RoleScope.PORTAL, (Permission[])PortalPermission.values());
            this.createOrUpdateSystemRole(SystemRole.PRIMARY_OWNER, RoleScope.API, io.gravitee.management.model.permissions.RoleScope.API, (Permission[])ApiPermission.values());
            this.createOrUpdateSystemRole(SystemRole.PRIMARY_OWNER, RoleScope.APPLICATION, io.gravitee.management.model.permissions.RoleScope.APPLICATION, (Permission[])ApplicationPermission.values());
            this.createOrUpdateSystemRole(SystemRole.ADMIN, RoleScope.GROUP, io.gravitee.management.model.permissions.RoleScope.GROUP, (Permission[])GroupPermission.values());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create admin roles", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create admin roles ", ex);
        }
    }

    @Override
    public RoleEntity update(UpdateRoleEntity roleEntity) {
        if (this.isReserved(roleEntity.getName())) {
            throw new RoleReservedNameException(roleEntity.getName());
        }
        RoleScope scope = this.convert(roleEntity.getScope());
        try {
            Optional optRole = this.roleRepository.findById(scope, roleEntity.getName());
            if (!optRole.isPresent()) {
                throw new RoleNotFoundException(scope, roleEntity.getName());
            }
            Role role = (Role)optRole.get();
            Role updatedRole = this.convert(roleEntity);
            updatedRole.setCreatedAt(role.getCreatedAt());
            RoleEntity entity = this.convert(this.roleRepository.update(updatedRole));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, role.getScope() + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, updatedRole.getUpdatedAt(), role, updatedRole);
            if (entity.isDefaultRole()) {
                this.toggleDefaultRole(scope, entity.getName());
            }
            return entity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update role {}", (Object)roleEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update role " + roleEntity.getName(), ex);
        }
    }

    @Override
    public void delete(RoleScope scope, String name) {
        if (this.isReserved(name)) {
            throw new RoleReservedNameException(SystemRole.ADMIN.name());
        }
        try {
            Optional optRole = this.roleRepository.findById(scope, name);
            if (!optRole.isPresent()) {
                throw new RoleNotFoundException(scope, name);
            }
            Role role = (Role)optRole.get();
            if (role.isDefaultRole() || role.isSystem()) {
                throw new RoleDeletionForbiddenException(scope, name);
            }
            List<RoleEntity> defaultRoleByScopes = this.findDefaultRoleByScopes(scope);
            if (defaultRoleByScopes.isEmpty()) {
                throw new DefaultRoleNotFoundException(new RoleScope[0]);
            }
            this.membershipService.removeRoleUsage(scope, name, defaultRoleByScopes.get(0).getName());
            this.roleRepository.delete(scope, name);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, role.getScope() + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_DELETED, role.getUpdatedAt(), role, null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete role {}/{}", new Object[]{scope, name, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete role " + scope + "/" + name, ex);
        }
    }

    @Override
    public List<RoleEntity> findByScope(RoleScope scope) {
        try {
            this.LOGGER.debug("Find Roles by scope");
            return this.roleRepository.findByScope(scope).stream().map(this::convert).sorted(Comparator.comparing(RoleEntity::getName)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find roles by scope", ex);
        }
    }

    @Override
    public List<RoleEntity> findDefaultRoleByScopes(RoleScope ... scopes) {
        try {
            this.LOGGER.debug("Find default Roles by scope");
            ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>();
            for (RoleScope scope : scopes) {
                roles.addAll(this.roleRepository.findByScope(scope).stream().filter(Role::isDefaultRole).map(this::convert).collect(Collectors.toList()));
            }
            return roles;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find default roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find default roles by scope", ex);
        }
    }

    @Override
    public boolean hasPermission(Map<String, char[]> userPermissions, Permission permission, RolePermissionAction[] acls) {
        boolean hasPermission = false;
        if (userPermissions != null) {
            Iterator<Map.Entry<String, char[]>> it = userPermissions.entrySet().iterator();
            while (it.hasNext() && !hasPermission) {
                Map.Entry<String, char[]> entry = it.next();
                if (!permission.getName().equals(entry.getKey())) continue;
                String crud = Arrays.toString(entry.getValue());
                for (RolePermissionAction perm : acls) {
                    if (crud.indexOf(perm.getId()) == -1) continue;
                    hasPermission = true;
                }
            }
        }
        return hasPermission;
    }

    private void toggleDefaultRole(RoleScope scope, String newDefaultRoleName) throws TechnicalException {
        List roles = this.roleRepository.findByScope(scope).stream().filter(Role::isDefaultRole).collect(Collectors.toList());
        for (Role role : roles) {
            if (role.getName().equals(newDefaultRoleName)) continue;
            Role previousRole = new Role(role);
            role.setDefaultRole(false);
            role.setUpdatedAt(new Date());
            this.roleRepository.update(role);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, role.getScope() + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, role.getUpdatedAt(), previousRole, role);
        }
    }

    private Role convert(NewRoleEntity roleEntity) {
        Role role = new Role();
        role.setName(this.generateId(roleEntity.getName()));
        role.setDescription(roleEntity.getDescription());
        role.setScope(this.convert(roleEntity.getScope()));
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setPermissions(this.convertPermissions(roleEntity.getScope(), roleEntity.getPermissions()));
        role.setCreatedAt(new Date());
        role.setUpdatedAt(role.getCreatedAt());
        return role;
    }

    private Role convert(UpdateRoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        Role role = new Role();
        role.setName(this.generateId(roleEntity.getName()));
        role.setDescription(roleEntity.getDescription());
        role.setScope(this.convert(roleEntity.getScope()));
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setPermissions(this.convertPermissions(roleEntity.getScope(), roleEntity.getPermissions()));
        role.setUpdatedAt(new Date());
        return role;
    }

    private RoleEntity convert(Role role) {
        if (role == null) {
            return null;
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setName(role.getName());
        roleEntity.setDescription(role.getDescription());
        roleEntity.setScope(this.convert(role.getScope()));
        roleEntity.setDefaultRole(role.isDefaultRole());
        roleEntity.setSystem(role.isSystem());
        roleEntity.setPermissions(this.convertPermissions(roleEntity.getScope(), role.getPermissions()));
        return roleEntity;
    }

    private int[] convertPermissions(io.gravitee.management.model.permissions.RoleScope scope, Map<String, char[]> perms) {
        if (perms == null || perms.isEmpty()) {
            return new int[0];
        }
        int[] result = new int[perms.size()];
        int idx = 0;
        for (Map.Entry<String, char[]> entry : perms.entrySet()) {
            int perm = 0;
            for (char c : entry.getValue()) {
                perm += RolePermissionAction.findById((char)c).getMask();
            }
            result[idx++] = Permission.findByScopeAndName((io.gravitee.management.model.permissions.RoleScope)scope, (String)entry.getKey()).getMask() + perm;
        }
        return result;
    }

    private Map<String, char[]> convertPermissions(io.gravitee.management.model.permissions.RoleScope scope, int[] perms) {
        if (perms == null) {
            return Collections.emptyMap();
        }
        HashMap<String, char[]> result = new HashMap<String, char[]>();
        Stream.of(Permission.findByScope((io.gravitee.management.model.permissions.RoleScope)scope)).forEach(perm -> {
            for (int action : perms) {
                if (action / 100 != perm.getMask() / 100) continue;
                ArrayList<Character> crud = new ArrayList<Character>();
                for (RolePermissionAction rolePermissionAction : RolePermissionAction.values()) {
                    if ((action - perm.getMask() & rolePermissionAction.getMask()) == 0) continue;
                    crud.add(Character.valueOf(rolePermissionAction.getId()));
                }
                result.put(perm.getName(), ArrayUtils.toPrimitive((Character[])crud.toArray(new Character[crud.size()])));
            }
        });
        return result;
    }

    private RoleScope convert(io.gravitee.management.model.permissions.RoleScope scope) {
        if (scope == null) {
            return null;
        }
        return RoleScope.valueOf((String)scope.name());
    }

    private io.gravitee.management.model.permissions.RoleScope convert(RoleScope scope) {
        if (scope == null) {
            return null;
        }
        return io.gravitee.management.model.permissions.RoleScope.valueOf((String)scope.name());
    }

    private String generateId(String name) {
        String id = name.trim().toUpperCase().replaceAll(" +", " ").replaceAll(" ", "_").replaceAll("[^\\w\\s]", "_").replaceAll("-+", "_");
        if (this.isReserved(id)) {
            throw new RoleReservedNameException(id);
        }
        return id;
    }

    private boolean isReserved(String name) {
        for (SystemRole systemRole : SystemRole.values()) {
            if (!systemRole.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Role createSystemRoleWithoutPermissions(String name, RoleScope scope, Date date) {
        this.LOGGER.info("      - <" + scope + "> " + name + " (system)");
        Role systemRole = new Role();
        systemRole.setName(name);
        systemRole.setDescription("System Role. Created by Gravitee.io");
        systemRole.setDefaultRole(false);
        systemRole.setSystem(true);
        systemRole.setScope(scope);
        systemRole.setCreatedAt(date);
        systemRole.setUpdatedAt(date);
        return systemRole;
    }
}

