/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ParameterRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ParameterServiceImpl
extends TransactionalService
implements ParameterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterServiceImpl.class);
    private static final String SEPARATOR = ";";
    public static final String KV_SEPARATOR = "@";
    @Inject
    private ParameterRepository parameterRepository;
    @Inject
    private AuditService auditService;

    @Override
    public boolean findAsBoolean(Key key) {
        List<String> values = this.findAll(key);
        String value = values == null || values.isEmpty() ? key.defaultValue() : values.get(0);
        return Boolean.valueOf(value);
    }

    @Override
    public List<String> findAll(Key key) {
        return this.findAll(key, (String value) -> value, null);
    }

    @Override
    public Map<String, List<String>> findAll(List<Key> keys) {
        return this.findAll(keys, (String value) -> value, null);
    }

    @Override
    public <T> List<T> findAll(Key key, Function<String, T> mapper) {
        return this.findAll(key, mapper, null);
    }

    @Override
    public <T> Map<String, List<T>> findAll(List<Key> keys, Function<String, T> mapper) {
        return this.findAll(keys, mapper, null);
    }

    @Override
    public <T> List<T> findAll(Key key, Function<String, T> mapper, Predicate<String> filter) {
        try {
            Optional optionalParameter = this.parameterRepository.findById((Object)key.key());
            if (optionalParameter.isPresent()) {
                return this.splitValue(((Parameter)optionalParameter.get()).getValue(), mapper, filter);
            }
            return Collections.emptyList();
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to find parameter values with key: " + key;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public <T> Map<String, List<T>> findAll(List<Key> keys, Function<String, T> mapper, Predicate<String> filter) {
        try {
            List parameters = this.parameterRepository.findAll(keys.stream().map(Key::key).collect(Collectors.toList()));
            if (parameters.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap();
            parameters.forEach(p -> result.put(p.getKey(), this.splitValue(p.getValue(), mapper, filter)));
            return result;
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to find parameter values with keys: " + keys;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private <T> List<T> splitValue(String value, Function<String, T> mapper, Predicate<String> filter) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<String> stream = Arrays.stream(value.split(SEPARATOR));
        if (filter != null) {
            stream = stream.filter(filter);
        }
        return stream.map(mapper).collect(Collectors.toList());
    }

    @Override
    public Parameter save(Key key, String value) {
        try {
            Optional optionalParameter = this.parameterRepository.findById((Object)key.key());
            boolean updateMode = optionalParameter.isPresent();
            Parameter parameter = new Parameter();
            parameter.setKey(key.key());
            parameter.setValue(value);
            if (updateMode) {
                if (value == null) {
                    this.parameterRepository.delete((Object)key.key());
                    return null;
                }
                Parameter updatedParameter = (Parameter)this.parameterRepository.update((Object)parameter);
                this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.PARAMETER, updatedParameter.getKey()), (Audit.AuditEvent)Parameter.AuditEvent.PARAMETER_UPDATED, new Date(), optionalParameter.get(), updatedParameter);
                return updatedParameter;
            }
            if (value == null) {
                return null;
            }
            Parameter savedParameter = (Parameter)this.parameterRepository.create((Object)parameter);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.PARAMETER, savedParameter.getKey()), (Audit.AuditEvent)Parameter.AuditEvent.PARAMETER_CREATED, new Date(), null, savedParameter);
            return savedParameter;
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create parameter for key/value: " + key + '/' + value;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public Parameter save(Key key, List<String> values) {
        return this.save(key, values == null ? null : String.join((CharSequence)SEPARATOR, values));
    }

    @Override
    public Parameter save(Key key, Map<String, String> values) {
        return this.save(key, values == null ? null : values.entrySet().stream().map(entry -> (String)entry.getKey() + KV_SEPARATOR + (String)entry.getValue()).collect(Collectors.joining(SEPARATOR)));
    }
}

