/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.notification.NotifierEntity;
import io.gravitee.management.service.NotifierService;
import io.gravitee.management.service.PortalNotificationService;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.notification.ApiHook;
import io.gravitee.management.service.notification.ApplicationHook;
import io.gravitee.management.service.notification.Hook;
import io.gravitee.management.service.notification.PortalHook;
import io.gravitee.management.service.notifiers.EmailNotifierService;
import io.gravitee.management.service.notifiers.WebhookNotifierService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.repository.management.model.PortalNotificationDefaultReferenceId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class NotifierServiceImpl
extends AbstractService
implements NotifierService {
    public static final String DEFAULT_EMAIL_NOTIFIER_ID = "default-email";
    private static final String DEFAULT_WEBHOOK_NOTIFIER_ID = "default-webhook";
    private final Logger LOGGER = LoggerFactory.getLogger(NotifierServiceImpl.class);
    @Autowired
    PortalNotificationConfigRepository portalNotificationConfigRepository;
    @Autowired
    PortalNotificationService portalNotificationService;
    @Autowired
    GenericNotificationConfigRepository genericNotificationConfigRepository;
    @Autowired
    @Lazy
    EmailNotifierService emailNotifierService;
    @Autowired
    @Lazy
    WebhookNotifierService webhookNotifierService;

    @Override
    @Async
    public void trigger(ApiHook hook, String apiId, Map<String, Object> params) {
        this.triggerPortalNotifications(hook, NotificationReferenceType.API, apiId, params);
        this.triggerGenericNotifications(hook, NotificationReferenceType.API, apiId, params);
    }

    @Override
    @Async
    public void trigger(ApplicationHook hook, String applicationId, Map<String, Object> params) {
        this.triggerPortalNotifications(hook, NotificationReferenceType.APPLICATION, applicationId, params);
        this.triggerGenericNotifications(hook, NotificationReferenceType.APPLICATION, applicationId, params);
    }

    @Override
    @Async
    public void trigger(PortalHook hook, Map<String, Object> params) {
        this.triggerPortalNotifications(hook, NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name(), params);
        this.triggerGenericNotifications(hook, NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name(), params);
    }

    private void triggerPortalNotifications(Hook hook, NotificationReferenceType refType, String refId, Map<String, Object> params) {
        try {
            List<String> userIds = this.portalNotificationConfigRepository.findByReferenceAndHook(hook.name(), refType, refId).stream().map(PortalNotificationConfig::getUser).collect(Collectors.toList());
            if (!userIds.isEmpty()) {
                this.portalNotificationService.create(hook, userIds, params);
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error looking for PortalNotificationConfig with {}/{}/{}", new Object[]{hook, refType, refId, e});
        }
    }

    private void triggerGenericNotifications(Hook hook, NotificationReferenceType refType, String refId, Map<String, Object> params) {
        try {
            block10: for (GenericNotificationConfig genericNotificationConfig : this.genericNotificationConfigRepository.findByReferenceAndHook(hook.name(), refType, refId)) {
                switch (genericNotificationConfig.getNotifier()) {
                    case "default-email": {
                        this.emailNotifierService.trigger(hook, genericNotificationConfig, params);
                        continue block10;
                    }
                    case "default-webhook": {
                        this.webhookNotifierService.trigger(hook, genericNotificationConfig, params);
                        continue block10;
                    }
                }
                this.LOGGER.error("Unknown notifier {}", (Object)genericNotificationConfig.getNotifier());
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error looking for GenericNotificationConfig with {}/{}/{}", new Object[]{hook, refType, refId, e});
        }
    }

    @Override
    public List<NotifierEntity> list(NotificationReferenceType referenceType, String referenceId) {
        NotifierEntity emailNotifier = new NotifierEntity();
        emailNotifier.setId(DEFAULT_EMAIL_NOTIFIER_ID);
        emailNotifier.setName("Default Email Notifier");
        emailNotifier.setType("EMAIL");
        NotifierEntity webHookNotifier = new NotifierEntity();
        webHookNotifier.setId(DEFAULT_WEBHOOK_NOTIFIER_ID);
        webHookNotifier.setName("Default Webhook Notifier");
        webHookNotifier.setType("WEBHOOK");
        return Arrays.asList(emailNotifier, webHookNotifier);
    }
}

