/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.management.model.ApiModelEntity;
import io.gravitee.management.model.MessageChannel;
import io.gravitee.management.model.MessageEntity;
import io.gravitee.management.model.MessageRecipientEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.MessageService;
import io.gravitee.management.service.PortalNotificationService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.builder.EmailNotificationBuilder;
import io.gravitee.management.service.exceptions.ApiNotFoundException;
import io.gravitee.management.service.exceptions.MessageEmptyException;
import io.gravitee.management.service.exceptions.MessageRecipientFormatException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.notification.ApiHook;
import io.gravitee.management.service.notification.Hook;
import io.gravitee.management.service.notification.PortalHook;
import io.gravitee.management.service.notifiers.WebNotifierService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.repository.management.model.Subscription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.StringUtils;

@Component
public class MessageServiceImpl
extends AbstractService
implements MessageService {
    private final Logger LOGGER = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    ApiRepository apiRepository;
    @Autowired
    MembershipRepository membershipRepository;
    @Autowired
    SubscriptionRepository subscriptionRepository;
    @Autowired
    PortalNotificationService portalNotificationService;
    @Autowired
    UserService userService;
    @Autowired
    AuditService auditService;
    @Autowired
    EmailService emailService;
    @Autowired
    ApiService apiService;
    @Autowired
    private Configuration freemarkerConfiguration;
    @Autowired
    WebNotifierService webNotifierService;
    @Value(value="${email.from}")
    private String defaultFrom;

    @Override
    public int create(String apiId, MessageEntity message) {
        this.assertMessageNotEmpty(message);
        try {
            Optional optionalApi = this.apiRepository.findById((Object)apiId);
            if (!optionalApi.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            Api api = (Api)optionalApi.get();
            int msgSize = this.send(api, message, this.getRecipientsId(api, message));
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), MessageEvent.MESSAGE_SENT, new Date(), null, message);
            return msgSize;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get create a message", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create a message", ex);
        }
    }

    @Override
    public int create(MessageEntity message) {
        this.assertMessageNotEmpty(message);
        int msgSize = this.send(null, message, this.getRecipientsId(message));
        this.auditService.createPortalAuditLog(Collections.emptyMap(), MessageEvent.MESSAGE_SENT, this.getAuthenticatedUsername(), new Date(), null, message);
        return msgSize;
    }

    private int send(Api api, MessageEntity message, Set<String> recipientsId) {
        switch (message.getChannel()) {
            case MAIL: {
                Set<String> mails = this.getRecipientsEmails(recipientsId);
                if (!mails.isEmpty()) {
                    this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(this.defaultFrom).bcc(mails.toArray(new String[0])).subject(message.getTitle()).template(EmailNotificationBuilder.EmailTemplate.GENERIC_MESSAGE).params(Collections.singletonMap("message", message.getText())).build());
                }
                return mails.size();
            }
            case PORTAL: {
                Enum hook = api == null ? PortalHook.MESSAGE : ApiHook.MESSAGE;
                this.portalNotificationService.create((Hook)((Object)hook), (List<String>)new ArrayList<String>(recipientsId), this.getPortalParams(api, message));
                return recipientsId.size();
            }
            case HTTP: {
                this.webNotifierService.request(HttpMethod.POST, recipientsId.iterator().next(), message.getParams(), this.getPostMessage(api, message), message.isUseSystemProxy());
                return 1;
            }
        }
        return 0;
    }

    @Override
    public Set<String> getRecipientsId(MessageEntity message) {
        if (MessageChannel.HTTP.equals((Object)message.getChannel())) {
            return Collections.singleton(message.getRecipient().getUrl());
        }
        return this.getRecipientsId(null, message);
    }

    @Override
    public Set<String> getRecipientsId(Api api, MessageEntity message) {
        if (message != null && MessageChannel.HTTP.equals((Object)message.getChannel())) {
            return Collections.singleton(message.getRecipient().getUrl());
        }
        this.assertRecipientsNotEmpty(message);
        MessageRecipientEntity recipientEntity = message.getRecipient();
        try {
            HashSet<String> recipientIds = new HashSet<String>();
            if (api == null && RoleScope.MANAGEMENT.name().equals(recipientEntity.getRoleScope())) {
                for (String roleName : recipientEntity.getRoleValues()) {
                    recipientIds.addAll(this.membershipRepository.findByRole(RoleScope.MANAGEMENT, roleName).stream().map(Membership::getUserId).collect(Collectors.toSet()));
                }
            } else if (api != null && RoleScope.APPLICATION.name().equals(recipientEntity.getRoleScope())) {
                List applicationIds = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().apis(Collections.singleton(api.getId())).status(Subscription.Status.ACCEPTED).build()).stream().map(Subscription::getApplication).collect(Collectors.toList());
                for (String roleName : recipientEntity.getRoleValues()) {
                    recipientIds.addAll(this.membershipRepository.findByReferencesAndRole(MembershipReferenceType.APPLICATION, applicationIds, RoleScope.APPLICATION, roleName).stream().map(Membership::getUserId).collect(Collectors.toSet()));
                }
                if (api.getGroups() != null && !api.getGroups().isEmpty()) {
                    for (String roleName : recipientEntity.getRoleValues()) {
                        recipientIds.addAll(this.membershipRepository.findByReferencesAndRole(MembershipReferenceType.GROUP, new ArrayList(api.getGroups()), RoleScope.APPLICATION, roleName).stream().map(Membership::getUserId).collect(Collectors.toSet()));
                    }
                }
            }
            return recipientIds;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get recipients", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to get recipients", ex);
        }
    }

    private Set<String> getRecipientsEmails(Set<String> recipientsId) {
        if (recipientsId.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> emails = this.userService.findByIds(new ArrayList<String>(recipientsId)).stream().filter(userEntity -> !StringUtils.isEmpty((Object)userEntity.getEmail())).map(UserEntity::getEmail).collect(Collectors.toSet());
        return emails;
    }

    private void assertMessageNotEmpty(MessageEntity messageEntity) {
        if (messageEntity == null || StringUtils.isEmpty((Object)messageEntity.getTitle()) && StringUtils.isEmpty((Object)messageEntity.getText())) {
            throw new MessageEmptyException();
        }
    }

    private void assertRecipientsNotEmpty(MessageEntity messageEntity) {
        if (messageEntity == null || messageEntity.getRecipient() == null || messageEntity.getChannel() == null || messageEntity.getRecipient().getRoleScope() == null || messageEntity.getRecipient().getRoleValues() == null || messageEntity.getRecipient().getRoleValues().isEmpty()) {
            throw new MessageRecipientFormatException();
        }
    }

    private Map<String, Object> getPortalParams(Api api, MessageEntity message) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", message.getTitle());
        params.put("message", message.getText());
        if (api != null) {
            Api paramApi = new Api();
            paramApi.setId(api.getId());
            paramApi.setName(api.getName());
            paramApi.setVersion(api.getVersion());
            params.put("api", paramApi);
        }
        return params;
    }

    private String getPostMessage(Api api, MessageEntity message) {
        if (message.getText() == null || api == null) {
            return message.getText();
        }
        try {
            Template template = new Template(new Date().toString(), message.getText(), this.freemarkerConfiguration);
            ApiModelEntity apiEntity = this.apiService.findByIdForTemplates(api.getId());
            HashMap<String, ApiModelEntity> model = new HashMap<String, ApiModelEntity>();
            model.put("api", apiEntity);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, model);
        }
        catch (TemplateException | IOException e) {
            this.LOGGER.error("Unable to apply templating on the message", e);
            throw new TechnicalManagementException("Unable to apply templating on the message", e);
        }
    }

    public static enum MessageEvent implements Audit.AuditEvent
    {
        MESSAGE_SENT;

    }
}

