/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.MediaEntity;
import io.gravitee.management.service.ConfigService;
import io.gravitee.management.service.MediaService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.media.api.MediaRepository;
import io.gravitee.repository.media.model.Media;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MediaServiceImpl
implements MediaService {
    private static final Logger logger = LoggerFactory.getLogger(MediaServiceImpl.class);
    @Autowired
    private MediaRepository mediaRepository;
    @Autowired
    private ConfigService configService;

    @Override
    public String savePortalMedia(MediaEntity mediaEntity) {
        return this.saveApiMedia(null, mediaEntity);
    }

    @Override
    public String saveApiMedia(String api, MediaEntity mediaEntity) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] fileBites = IOUtils.toByteArray((InputStream)mediaEntity.getData());
            byte[] hash = digest.digest(fileBites);
            String hashString = DatatypeConverter.printHexBinary((byte[])hash);
            String id = io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random());
            Optional checkMedia = null;
            checkMedia = api != null ? this.mediaRepository.findByHash(hashString, api, mediaEntity.getType()) : this.mediaRepository.findByHash(hashString, mediaEntity.getType());
            if (checkMedia.isPresent()) {
                return ((Media)checkMedia.get()).getHash();
            }
            Media media = MediaServiceImpl.convert(mediaEntity);
            media.setId(id);
            media.setHash(hashString);
            media.setSize(Long.valueOf(fileBites.length));
            media.setApi(api);
            media.setData(fileBites);
            this.mediaRepository.save(media);
            return hashString;
        }
        catch (TechnicalException | IOException | NoSuchAlgorithmException ex) {
            logger.error("An error occurs while trying to create {}", (Object)mediaEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + mediaEntity, ex);
        }
    }

    @Override
    public MediaEntity findby(String id) {
        Optional mediaData = this.mediaRepository.findByHash(id, "image");
        return mediaData.isPresent() ? MediaServiceImpl.convert((Media)mediaData.get()) : null;
    }

    @Override
    public MediaEntity findby(String id, String api) {
        Optional mediaData = this.mediaRepository.findByHash(id, api, "image");
        return mediaData.isPresent() ? MediaServiceImpl.convert((Media)mediaData.get()) : null;
    }

    @Override
    public Long getMediaMaxSize() {
        return (long)this.configService.getPortalConfig().getPortal().getUploadMedia().getMaxSizeInOctet();
    }

    private static Media convert(MediaEntity imageEntity) {
        Media media = new Media();
        media.setFileName(imageEntity.getFileName());
        media.setSize(Long.valueOf(imageEntity.getSize()));
        media.setType(imageEntity.getType());
        media.setSubType(imageEntity.getSubType());
        return media;
    }

    private static MediaEntity convert(Media media) {
        MediaEntity mediaEntity = new MediaEntity((InputStream)new ByteArrayInputStream(media.getData()), media.getType(), media.getSubType(), media.getFileName(), media.getSize().longValue());
        mediaEntity.setUploadDate(media.getCreatedAt());
        return mediaEntity;
    }
}

