/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.GroupEntity;
import io.gravitee.management.model.GroupEventRuleEntity;
import io.gravitee.management.model.NewGroupEntity;
import io.gravitee.management.model.UpdateGroupEntity;
import io.gravitee.management.model.Visibility;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.permissions.RolePermission;
import io.gravitee.management.model.permissions.RolePermissionAction;
import io.gravitee.management.model.permissions.SystemRole;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.GroupService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.PermissionService;
import io.gravitee.management.service.exceptions.GroupNameAlreadyExistsException;
import io.gravitee.management.service.exceptions.GroupNotFoundException;
import io.gravitee.management.service.exceptions.GroupsNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.GroupEventRule;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupServiceImpl
extends AbstractService
implements GroupService {
    private final Logger logger = LoggerFactory.getLogger(GroupServiceImpl.class);
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private PermissionService permissionService;

    @Override
    public List<GroupEntity> findAll() {
        try {
            this.logger.debug("Find all groups");
            Set all = this.groupRepository.findAll();
            this.logger.debug("Find all groups - DONE");
            List<GroupEntity> groups = all.stream().map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toList());
            if (this.permissionService.hasPermission(RolePermission.MANAGEMENT_GROUP, null, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE)) {
                groups.forEach(groupEntity -> groupEntity.setManageable(true));
            } else {
                List groupIds = this.membershipRepository.findByUserAndReferenceTypeAndRole(this.getAuthenticatedUsername(), MembershipReferenceType.GROUP, RoleScope.GROUP, SystemRole.ADMIN.name()).stream().map(Membership::getReferenceId).collect(Collectors.toList());
                groups.forEach(groupEntity -> groupEntity.setManageable(groupIds.contains(groupEntity.getId())));
            }
            return groups;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find all groups", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all groups", ex);
        }
    }

    @Override
    public List<GroupEntity> findByName(String name) {
        try {
            this.logger.debug("findByUsername : {}", (Object)name);
            if (name == null) {
                return Collections.emptyList();
            }
            List<GroupEntity> groupEntities = this.groupRepository.findAll().stream().filter(group -> group.getName().equals(name)).map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toList());
            this.logger.debug("findByUsername : {} - DONE", (Object)name);
            return groupEntities;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find groups by name", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find groups by name", ex);
        }
    }

    @Override
    public GroupEntity create(NewGroupEntity group) {
        try {
            this.logger.debug("create {}", (Object)group);
            if (!this.findByName(group.getName()).isEmpty()) {
                throw new GroupNameAlreadyExistsException(group.getName());
            }
            Group newGroup = this.map(group);
            newGroup.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
            newGroup.setCreatedAt(new Date());
            newGroup.setUpdatedAt(newGroup.getCreatedAt());
            GroupEntity grp = this.map((Group)this.groupRepository.create((Object)newGroup));
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.GROUP, newGroup.getId()), (Audit.AuditEvent)Group.AuditEvent.GROUP_CREATED, newGroup.getCreatedAt(), null, newGroup);
            this.logger.debug("create {} - DONE", (Object)grp);
            return grp;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to create a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create a group", ex);
        }
    }

    @Override
    public GroupEntity update(String groupId, UpdateGroupEntity group) {
        try {
            this.logger.debug("update {}", (Object)group);
            GroupEntity updatedGroupEntity = this.findById(groupId);
            Group previousGroup = this.map(updatedGroupEntity);
            updatedGroupEntity.setName(group.getName());
            updatedGroupEntity.setUpdatedAt(new Date());
            updatedGroupEntity.setEventRules(group.getEventRules());
            updatedGroupEntity.setRoles(group.getRoles());
            updatedGroupEntity.setMaxInvitation(group.getMaxInvitation());
            updatedGroupEntity.setLockApiRole(group.isLockApiRole());
            updatedGroupEntity.setLockApplicationRole(group.isLockApplicationRole());
            updatedGroupEntity.setSystemInvitation(group.isSystemInvitation());
            updatedGroupEntity.setEmailInvitation(group.isEmailInvitation());
            Group updatedGroup = this.map(updatedGroupEntity);
            GroupEntity grp = this.map((Group)this.groupRepository.update((Object)updatedGroup));
            this.logger.debug("update {} - DONE", (Object)grp);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.GROUP, groupId), (Audit.AuditEvent)Group.AuditEvent.GROUP_UPDATED, updatedGroupEntity.getUpdatedAt(), previousGroup, updatedGroup);
            return this.findById(groupId);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to update a group";
            this.logger.error("An error occurs while trying to update a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to update a group", ex);
        }
    }

    @Override
    public GroupEntity findById(String groupId) {
        try {
            this.logger.debug("findById {}", (Object)groupId);
            Optional group = this.groupRepository.findById((Object)groupId);
            if (!group.isPresent()) {
                throw new GroupNotFoundException(groupId);
            }
            this.logger.debug("findById {} - DONE", group.get());
            GroupEntity groupEntity = this.map((Group)group.get());
            if (this.permissionService.hasPermission(RolePermission.MANAGEMENT_GROUP, null, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE)) {
                groupEntity.setManageable(true);
            } else {
                List groupIds = this.membershipRepository.findByUserAndReferenceTypeAndRole(this.getAuthenticatedUsername(), MembershipReferenceType.GROUP, RoleScope.GROUP, SystemRole.ADMIN.name()).stream().map(Membership::getReferenceId).collect(Collectors.toList());
                groupEntity.setManageable(groupIds.contains(groupEntity.getId()));
            }
            return groupEntity;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find a group", ex);
        }
    }

    @Override
    public Set<GroupEntity> findByIds(Set<String> groupIds) {
        try {
            this.logger.debug("findByIds {}", groupIds);
            Set groups = this.groupRepository.findByIds(groupIds);
            if (groups == null || groups.size() != groupIds.size()) {
                List groupsFound = groups == null ? Collections.emptyList() : groups.stream().map(Group::getId).collect(Collectors.toList());
                HashSet<String> groupIdsNotFound = new HashSet<String>(groupIds);
                groupIdsNotFound.removeAll(groupsFound);
                throw new GroupsNotFoundException(groupIdsNotFound);
            }
            this.logger.debug("findByIds {} - DONE", (Object)groups);
            return groups.stream().map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find groups", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find groups", ex);
        }
    }

    @Override
    public Set<GroupEntity> findByEvent(GroupEvent event) {
        try {
            this.logger.debug("findByEvent : {}", (Object)event);
            Set<GroupEntity> set = this.groupRepository.findAll().stream().filter(g -> g.getEventRules() != null && g.getEventRules().stream().map(GroupEventRule::getEvent).collect(Collectors.toList()).contains(event)).map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toSet());
            this.logger.debug("findByEvent : {} - DONE", set);
            return set;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find groups by event", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find groups by event", ex);
        }
    }

    @Override
    public void delete(String groupId) {
        try {
            this.logger.debug("delete {}", (Object)groupId);
            Optional group = this.groupRepository.findById((Object)groupId);
            if (!group.isPresent()) {
                throw new GroupNotFoundException(groupId);
            }
            this.membershipRepository.findByReferenceAndRole(MembershipReferenceType.GROUP, groupId, null, null).forEach(member -> {
                try {
                    this.membershipRepository.delete(member);
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
                }
            });
            Date updatedDate = new Date();
            this.apiRepository.search(new ApiCriteria.Builder().groups(new String[]{groupId}).build()).forEach(api -> {
                api.getGroups().remove(groupId);
                api.setUpdatedAt(updatedDate);
                try {
                    this.apiRepository.update(api);
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
                }
            });
            this.applicationRepository.findByGroups(Collections.singletonList(groupId), new ApplicationStatus[0]).forEach(application -> {
                application.getGroups().remove(groupId);
                application.setUpdatedAt(updatedDate);
                try {
                    this.applicationRepository.update(application);
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
                }
            });
            this.groupRepository.delete((Object)groupId);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.GROUP, groupId), (Audit.AuditEvent)Group.AuditEvent.GROUP_DELETED, new Date(), group.get(), null);
            this.logger.debug("delete {} - DONE", (Object)groupId);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
        }
    }

    @Override
    public boolean isUserAuthorizedToAccessApiData(ApiEntity api, List<String> excludedGroups, String username) {
        if (username == null) {
            return (excludedGroups == null || excludedGroups.isEmpty()) && Visibility.PUBLIC.equals((Object)api.getVisibility());
        }
        if (excludedGroups != null && !excludedGroups.isEmpty() && this.membershipService.getMember(MembershipReferenceType.API, api.getId(), username, RoleScope.API) == null) {
            Set<String> authorizedGroups = Collections.emptySet();
            if (Visibility.PRIVATE.equals((Object)api.getVisibility()) && api.getGroups() != null && !api.getGroups().isEmpty()) {
                authorizedGroups = new HashSet<String>(api.getGroups());
            }
            if (Visibility.PUBLIC.equals((Object)api.getVisibility())) {
                try {
                    authorizedGroups = this.groupRepository.findAll().stream().map(Group::getId).collect(Collectors.toSet());
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to find all groups", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to find all groups", ex);
                }
            }
            authorizedGroups.removeAll(excludedGroups);
            for (String authorizedGroupId : authorizedGroups) {
                if (this.membershipService.getMember(MembershipReferenceType.GROUP, authorizedGroupId, username, RoleScope.API) == null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isUserAuthorizedToAccessPortalData(List<String> excludedGroups, String username) {
        if (username == null) {
            return excludedGroups == null || excludedGroups.isEmpty();
        }
        if (excludedGroups != null && !excludedGroups.isEmpty()) {
            Set authorizedGroups;
            try {
                authorizedGroups = this.groupRepository.findAll().stream().map(Group::getId).collect(Collectors.toSet());
            }
            catch (TechnicalException ex) {
                this.logger.error("An error occurs while trying to find all groups", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while trying to find all groups", ex);
            }
            authorizedGroups.removeAll(excludedGroups);
            for (String authorizedGroupId : authorizedGroups) {
                if (this.membershipService.getMember(MembershipReferenceType.GROUP, authorizedGroupId, username, RoleScope.API) == null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Set<GroupEntity> findByUser(String user) {
        try {
            return this.findByIds(this.membershipRepository.findByUserAndReferenceType(user, MembershipReferenceType.GROUP).stream().map(Membership::getReferenceId).collect(Collectors.toSet()));
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find all user groups", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all user groups", ex);
        }
    }

    @Override
    public List<ApiEntity> getApis(String groupId) {
        return this.apiRepository.search(new ApiCriteria.Builder().groups(new String[]{groupId}).build(), new ApiFieldExclusionFilter.Builder().excludeDefinition().excludePicture().build()).stream().map((? super T api) -> {
            ApiEntity apiEntity = new ApiEntity();
            apiEntity.setId(api.getId());
            apiEntity.setName(api.getName());
            apiEntity.setVersion(api.getVersion());
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().name()));
            return apiEntity;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ApplicationEntity> getApplications(String groupId) {
        try {
            return this.applicationRepository.findByGroups(Collections.singletonList(groupId), new ApplicationStatus[]{ApplicationStatus.ACTIVE}).stream().map((? super T application) -> {
                ApplicationEntity applicationEntity = new ApplicationEntity();
                applicationEntity.setId(application.getId());
                applicationEntity.setName(application.getName());
                return applicationEntity;
            }).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find all application of group {}", (Object)groupId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all application of group " + groupId, ex);
        }
    }

    private Group map(GroupEntity entity) {
        if (entity == null) {
            return null;
        }
        Group group = new Group();
        group.setId(entity.getId());
        group.setName(entity.getName());
        if (entity.getEventRules() != null && !entity.getEventRules().isEmpty()) {
            ArrayList<GroupEventRule> groupEventRules = new ArrayList<GroupEventRule>();
            for (GroupEventRuleEntity groupEventRuleEntity : entity.getEventRules()) {
                GroupEventRule eventRule = new GroupEventRule();
                eventRule.setEvent(GroupEvent.valueOf((String)groupEventRuleEntity.getEvent()));
                groupEventRules.add(eventRule);
            }
            group.setEventRules(groupEventRules);
        }
        if (entity.getRoles() != null && !entity.getRoles().isEmpty()) {
            HashMap roles = new HashMap();
            for (Map.Entry entry : entity.getRoles().entrySet()) {
                roles.put(RoleScope.valueOf((String)((io.gravitee.management.model.permissions.RoleScope)entry.getKey()).name()).getId(), entry.getValue());
            }
            group.setRoles(roles);
        }
        group.setCreatedAt(entity.getCreatedAt());
        group.setUpdatedAt(entity.getUpdatedAt());
        group.setMaxInvitation(entity.getMaxInvitation());
        group.setLockApiRole(entity.isLockApiRole());
        group.setLockApplicationRole(entity.isLockApplicationRole());
        group.setSystemInvitation(entity.isSystemInvitation());
        group.setEmailInvitation(entity.isEmailInvitation());
        return group;
    }

    private Group map(NewGroupEntity entity) {
        if (entity == null) {
            return null;
        }
        Group group = new Group();
        group.setName(entity.getName());
        if (entity.getEventRules() != null && !entity.getEventRules().isEmpty()) {
            ArrayList<GroupEventRule> groupEventRules = new ArrayList<GroupEventRule>();
            for (GroupEventRuleEntity groupEventRuleEntity : entity.getEventRules()) {
                GroupEventRule eventRule = new GroupEventRule();
                eventRule.setEvent(GroupEvent.valueOf((String)groupEventRuleEntity.getEvent()));
                groupEventRules.add(eventRule);
            }
            group.setEventRules(groupEventRules);
        }
        entity.setMaxInvitation(group.getMaxInvitation());
        entity.setLockApiRole(group.isLockApiRole());
        entity.setLockApplicationRole(group.isLockApplicationRole());
        entity.setSystemInvitation(group.isSystemInvitation());
        entity.setEmailInvitation(group.isEmailInvitation());
        return group;
    }

    private GroupEntity map(Group group) {
        if (group == null) {
            return null;
        }
        GroupEntity entity = new GroupEntity();
        entity.setId(group.getId());
        entity.setName(group.getName());
        if (group.getEventRules() != null && !group.getEventRules().isEmpty()) {
            ArrayList<GroupEventRuleEntity> groupEventRules = new ArrayList<GroupEventRuleEntity>();
            for (GroupEventRule groupEventRule : group.getEventRules()) {
                GroupEventRuleEntity eventRuleEntity = new GroupEventRuleEntity();
                eventRuleEntity.setEvent(groupEventRule.getEvent().name());
                groupEventRules.add(eventRuleEntity);
            }
            entity.setEventRules(groupEventRules);
        }
        if (group.getRoles() != null && !group.getRoles().isEmpty()) {
            HashMap groupRoles = new HashMap();
            for (Map.Entry entry : group.getRoles().entrySet()) {
                groupRoles.put(io.gravitee.management.model.permissions.RoleScope.valueOf((String)RoleScope.valueOf((int)((Integer)entry.getKey())).name()), entry.getValue());
            }
            entity.setRoles(groupRoles);
        }
        entity.setCreatedAt(group.getCreatedAt());
        entity.setUpdatedAt(group.getUpdatedAt());
        entity.setMaxInvitation(group.getMaxInvitation());
        entity.setLockApiRole(group.isLockApiRole());
        entity.setLockApplicationRole(group.isLockApplicationRole());
        entity.setSystemInvitation(group.isSystemInvitation());
        entity.setEmailInvitation(group.isEmailInvitation());
        return entity;
    }
}

