/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.diff.JsonDiff;
import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.audit.AuditEntity;
import io.gravitee.management.model.audit.AuditQuery;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UserNotFoundException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.impl.MetadataServiceImpl;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.AuditCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.Plan;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AuditServiceImpl
extends AbstractService
implements AuditService {
    private final Logger LOGGER = LoggerFactory.getLogger(AuditServiceImpl.class);
    @Autowired
    private AuditRepository auditRepository;
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    @Lazy
    private UserService userService;
    @Autowired
    private ObjectMapper mapper;

    @Override
    public MetadataPage<AuditEntity> search(AuditQuery query) {
        Audit.AuditReferenceType referenceType = query.isManagementLogsOnly() ? Audit.AuditReferenceType.PORTAL : (query.getApiIds() != null && !query.getApiIds().isEmpty() ? Audit.AuditReferenceType.API : (query.getApplicationIds() != null && !query.getApplicationIds().isEmpty() ? Audit.AuditReferenceType.APPLICATION : null));
        AuditCriteria.Builder criteria = new AuditCriteria.Builder().from(query.getFrom()).to(query.getTo());
        if (referenceType != null) {
            List<String> referenceIds;
            switch (referenceType) {
                case API: {
                    referenceIds = query.getApiIds();
                    break;
                }
                case APPLICATION: {
                    referenceIds = query.getApplicationIds();
                    break;
                }
                default: {
                    referenceIds = Collections.singletonList("DEFAULT");
                }
            }
            criteria.references(referenceType, referenceIds);
        }
        if (query.getEvents() != null && !query.getEvents().isEmpty()) {
            criteria.events(query.getEvents());
        }
        io.gravitee.common.data.domain.Page auditPage = this.auditRepository.search(criteria.build(), new PageableBuilder().pageNumber(query.getPage() - 1).pageSize(query.getSize()).build());
        List<AuditEntity> content = auditPage.getContent().stream().map(this::convert).collect(Collectors.toList());
        return new MetadataPage(content, query.getPage(), query.getSize(), auditPage.getTotalElements(), this.getMetadata(content));
    }

    private Map<String, String> getMetadata(List<AuditEntity> content) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (AuditEntity auditEntity : content) {
            String metadataKey = "USER:" + auditEntity.getUser() + ":name";
            try {
                UserEntity user = this.userService.findById(auditEntity.getUser());
                metadata.put(metadataKey, user.getDisplayName());
            }
            catch (TechnicalManagementException e) {
                this.LOGGER.error("Error finding metadata {}", (Object)auditEntity.getUser());
            }
            catch (UserNotFoundException unfe) {
                metadata.put(metadataKey, auditEntity.getUser());
            }
            if (Audit.AuditReferenceType.API.name().equals(auditEntity.getReferenceType())) {
                metadataKey = "API:" + auditEntity.getReferenceId() + ":name";
                if (!metadata.containsKey(metadataKey)) {
                    try {
                        Optional optApi = this.apiRepository.findById((Object)auditEntity.getReferenceId());
                        if (optApi.isPresent()) {
                            metadata.put(metadataKey, ((Api)optApi.get()).getName());
                        }
                    }
                    catch (TechnicalException e) {
                        this.LOGGER.error("Error finding metadata {}", (Object)metadataKey);
                        metadata.put(metadataKey, auditEntity.getReferenceId());
                    }
                }
            } else if (Audit.AuditReferenceType.APPLICATION.name().equals(auditEntity.getReferenceType()) && !metadata.containsKey(metadataKey = "APPLICATION:" + auditEntity.getReferenceId() + ":name")) {
                try {
                    Optional optApp = this.applicationRepository.findById((Object)auditEntity.getReferenceId());
                    if (optApp.isPresent()) {
                        metadata.put(metadataKey, ((Application)optApp.get()).getName());
                    }
                }
                catch (TechnicalException e) {
                    this.LOGGER.error("Error finding metadata {}", (Object)metadataKey);
                    metadata.put(metadataKey, auditEntity.getReferenceId());
                }
            }
            if (auditEntity.getProperties() == null) continue;
            for (Map.Entry property : auditEntity.getProperties().entrySet()) {
                metadataKey = new StringJoiner(":").add((CharSequence)property.getKey()).add((CharSequence)property.getValue()).add("name").toString();
                if (metadata.containsKey(metadataKey)) continue;
                String name = (String)property.getValue();
                try {
                    switch (Audit.AuditProperties.valueOf((String)((String)property.getKey()))) {
                        case API: {
                            Optional optApi = this.apiRepository.findById(property.getValue());
                            if (!optApi.isPresent()) break;
                            name = ((Api)optApi.get()).getName();
                            break;
                        }
                        case APPLICATION: {
                            Optional optApp = this.applicationRepository.findById(property.getValue());
                            if (!optApp.isPresent()) break;
                            name = ((Application)optApp.get()).getName();
                            break;
                        }
                        case PAGE: {
                            Optional optPage = this.pageRepository.findById(property.getValue());
                            if (!optPage.isPresent()) break;
                            name = ((Page)optPage.get()).getName();
                            break;
                        }
                        case PLAN: {
                            Optional optPlan = this.planRepository.findById(property.getValue());
                            if (!optPlan.isPresent()) break;
                            name = ((Plan)optPlan.get()).getName();
                            break;
                        }
                        case METADATA: {
                            MetadataReferenceType refType = Audit.AuditReferenceType.API.name().equals(auditEntity.getReferenceType()) ? MetadataReferenceType.API : (Audit.AuditReferenceType.APPLICATION.name().equals(auditEntity.getReferenceType()) ? MetadataReferenceType.APPLICATION : MetadataReferenceType.DEFAULT);
                            String refId = refType.equals((Object)MetadataReferenceType.DEFAULT) ? MetadataServiceImpl.getDefautReferenceId() : auditEntity.getReferenceId();
                            Optional optMetadata = this.metadataRepository.findById((String)property.getValue(), refId, refType);
                            if (!optMetadata.isPresent()) break;
                            name = ((Metadata)optMetadata.get()).getName();
                            break;
                        }
                        case GROUP: {
                            Optional optGroup = this.groupRepository.findById(property.getValue());
                            if (!optGroup.isPresent()) break;
                            name = ((Group)optGroup.get()).getName();
                            break;
                        }
                        case USER: {
                            try {
                                UserEntity user = this.userService.findById((String)property.getValue());
                                name = user.getDisplayName();
                                break;
                            }
                            catch (UserNotFoundException unfe) {
                                name = (String)property.getValue();
                            }
                        }
                    }
                }
                catch (TechnicalException e) {
                    this.LOGGER.error("Error finding metadata {}", (Object)metadataKey);
                    name = (String)property.getValue();
                }
                metadata.put(metadataKey, name);
            }
        }
        return metadata;
    }

    @Override
    public void createApiAuditLog(String apiId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        this.create(Audit.AuditReferenceType.API, apiId, properties, event, this.getAuthenticatedUsernameOrSystem(), createdAt == null ? new Date() : createdAt, oldValue, newValue);
    }

    @Override
    public void createApplicationAuditLog(String applicationId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        this.createApplicationAuditLog(applicationId, properties, event, this.getAuthenticatedUsernameOrSystem(), createdAt, oldValue, newValue);
    }

    @Override
    public void createApplicationAuditLog(String applicationId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, String userId, Date createdAt, Object oldValue, Object newValue) {
        this.create(Audit.AuditReferenceType.APPLICATION, applicationId, properties, event, userId, createdAt == null ? new Date() : createdAt, oldValue, newValue);
    }

    @Override
    public void createPortalAuditLog(Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        this.createPortalAuditLog(properties, event, this.getAuthenticatedUsernameOrSystem(), createdAt, oldValue, newValue);
    }

    @Override
    public void createPortalAuditLog(Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, String userId, Date createdAt, Object oldValue, Object newValue) {
        this.create(Audit.AuditReferenceType.PORTAL, "DEFAULT", properties, event, userId, createdAt == null ? new Date() : createdAt, oldValue, newValue);
    }

    @Async
    protected void create(Audit.AuditReferenceType referenceType, String referenceId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, String userId, Date createdAt, Object oldValue, Object newValue) {
        Audit audit = new Audit();
        audit.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        audit.setUser(userId);
        audit.setCreatedAt(createdAt);
        if (properties != null) {
            HashMap stringStringMap = new HashMap(properties.size());
            properties.forEach((auditProperties, s) -> stringStringMap.put(auditProperties.name(), s));
            audit.setProperties(stringStringMap);
        }
        audit.setReferenceType(referenceType);
        audit.setReferenceId(referenceId);
        audit.setEvent(event.name());
        ObjectNode oldNode = oldValue == null ? this.mapper.createObjectNode() : ((ObjectNode)this.mapper.convertValue(oldValue, ObjectNode.class)).remove(Arrays.asList("updatedAt", "createdAt"));
        ObjectNode newNode = newValue == null ? this.mapper.createObjectNode() : ((ObjectNode)this.mapper.convertValue(newValue, ObjectNode.class)).remove(Arrays.asList("updatedAt", "createdAt"));
        audit.setPatch(JsonDiff.asJson((JsonNode)oldNode, (JsonNode)newNode).toString());
        try {
            this.auditRepository.create((Object)audit);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error occurs during the creation of an Audit Log {}.", (Throwable)e);
        }
    }

    private AuditEntity convert(Audit audit) {
        AuditEntity auditEntity = new AuditEntity();
        auditEntity.setReferenceType(audit.getReferenceType().name());
        auditEntity.setReferenceId(audit.getReferenceId());
        auditEntity.setEvent(audit.getEvent());
        auditEntity.setProperties(audit.getProperties());
        auditEntity.setUser(audit.getUser());
        auditEntity.setId(audit.getId());
        auditEntity.setPatch(audit.getPatch());
        auditEntity.setCreatedAt(audit.getCreatedAt());
        return auditEntity;
    }

    private String getAuthenticatedUsernameOrSystem() {
        return this.isAuthenticated() ? this.getAuthenticatedUsername() : "system";
    }
}

