/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.management.model.ApiKeyEntity;
import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.GroupEntity;
import io.gravitee.management.model.NewApplicationEntity;
import io.gravitee.management.model.PrimaryOwnerEntity;
import io.gravitee.management.model.SubscriptionEntity;
import io.gravitee.management.model.SubscriptionStatus;
import io.gravitee.management.model.UpdateApplicationEntity;
import io.gravitee.management.model.UpdateSubscriptionEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.application.ApplicationListItem;
import io.gravitee.management.model.application.ApplicationListItemSettings;
import io.gravitee.management.model.application.ApplicationSettings;
import io.gravitee.management.model.application.OAuthClientSettings;
import io.gravitee.management.model.application.SimpleApplicationSettings;
import io.gravitee.management.model.notification.GenericNotificationConfigEntity;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.model.permissions.SystemRole;
import io.gravitee.management.model.subscription.SubscriptionQuery;
import io.gravitee.management.service.ApiKeyService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.GenericNotificationConfigService;
import io.gravitee.management.service.GroupService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.SubscriptionService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.configuration.application.ClientRegistrationService;
import io.gravitee.management.service.exceptions.ApplicationNotFoundException;
import io.gravitee.management.service.exceptions.ClientIdAlreadyExistsException;
import io.gravitee.management.service.exceptions.InvalidApplicationTypeException;
import io.gravitee.management.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.impl.configuration.application.registration.client.register.ClientRegistrationResponse;
import io.gravitee.management.service.notification.ApplicationHook;
import io.gravitee.management.service.notification.HookScope;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationServiceImpl
extends AbstractService
implements ApplicationService {
    private final Logger LOGGER = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private GroupService groupService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private ClientRegistrationService clientRegistrationService;
    @Autowired
    private ParameterService parameterService;
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ApplicationEntity findById(String applicationId) {
        try {
            this.LOGGER.debug("Find application by ID: {}", (Object)applicationId);
            Optional application = this.applicationRepository.findById((Object)applicationId);
            if (application.isPresent()) {
                Optional primaryOwnerMembership = this.membershipRepository.findByReferenceAndRole(MembershipReferenceType.APPLICATION, applicationId, RoleScope.APPLICATION, SystemRole.PRIMARY_OWNER.name()).stream().findFirst();
                if (!primaryOwnerMembership.isPresent()) {
                    this.LOGGER.error("The Application {} doesn't have any primary owner.", (Object)applicationId);
                    throw new TechnicalException("The Application " + applicationId + " doesn't have any primary owner.");
                }
                return this.convert((Application)application.get(), this.userService.findById(((Membership)primaryOwnerMembership.get()).getUserId()));
            }
            throw new ApplicationNotFoundException(applicationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an application using its ID {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an application using its ID " + applicationId, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByUser(String username) {
        try {
            this.LOGGER.debug("Find applications for user {}", (Object)username);
            List appIds = this.membershipRepository.findByUserAndReferenceType(username, MembershipReferenceType.APPLICATION).stream().map(Membership::getReferenceId).collect(Collectors.toList());
            Set<Application> applications = this.applicationRepository.findByIds(appIds).stream().filter(app -> ApplicationStatus.ACTIVE.equals((Object)app.getStatus())).collect(Collectors.toSet());
            List groupIds = this.membershipRepository.findByUserAndReferenceType(username, MembershipReferenceType.GROUP).stream().filter(m -> m.getRoles().keySet().contains(RoleScope.APPLICATION.getId())).map(Membership::getReferenceId).collect(Collectors.toList());
            applications.addAll(this.applicationRepository.findByGroups(groupIds, new ApplicationStatus[]{ApplicationStatus.ACTIVE}));
            if (applications.isEmpty()) {
                return Collections.emptySet();
            }
            return this.convertToList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for user {}", (Object)username, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for user " + username, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByName(String name) {
        this.LOGGER.debug("Find applications by name {}", (Object)name);
        try {
            if (name == null || name.trim().isEmpty()) {
                return Collections.emptySet();
            }
            Set<Application> applications = this.applicationRepository.findByName(name.trim()).stream().filter(app -> ApplicationStatus.ACTIVE.equals((Object)app.getStatus())).collect(Collectors.toSet());
            return this.convertToList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for name {}", (Object)name, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for name " + name, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByGroups(List<String> groupIds) {
        this.LOGGER.debug("Find applications by groups {}", groupIds);
        try {
            return this.convertToList(this.applicationRepository.findByGroups(groupIds, new ApplicationStatus[]{ApplicationStatus.ACTIVE}));
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for groups {}", groupIds, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for groups " + groupIds, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findAll() {
        try {
            this.LOGGER.debug("Find all applications");
            Set applications = this.applicationRepository.findAll(new ApplicationStatus[]{ApplicationStatus.ACTIVE});
            if (applications == null || applications.isEmpty()) {
                return Collections.emptySet();
            }
            return this.convertToList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all applications", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all applications", ex);
        }
    }

    @Override
    public ApplicationEntity create(NewApplicationEntity newApplicationEntity, String userId) {
        try {
            this.LOGGER.debug("Create {} for user {}", (Object)newApplicationEntity, (Object)userId);
            if (newApplicationEntity.getSettings().getApp() != null && newApplicationEntity.getSettings().getoAuthClient() != null) {
                throw new InvalidApplicationTypeException();
            }
            if (newApplicationEntity.getSettings().getApp() == null && newApplicationEntity.getSettings().getoAuthClient() == null) {
                throw new InvalidApplicationTypeException();
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (newApplicationEntity.getSettings().getApp() != null) {
                String clientId = newApplicationEntity.getSettings().getApp().getClientId();
                if (clientId != null && !clientId.trim().isEmpty()) {
                    this.LOGGER.debug("Check that client_id is unique among all applications");
                    Set applications = this.applicationRepository.findAll(new ApplicationStatus[]{ApplicationStatus.ACTIVE});
                    boolean alreadyExistingApp = applications.stream().anyMatch(app -> app.getMetadata() != null && clientId.equals(app.getMetadata().get("client_id")));
                    if (alreadyExistingApp) {
                        this.LOGGER.error("An application already exists with the same client_id");
                        throw new ClientIdAlreadyExistsException(clientId);
                    }
                }
            } else {
                this.checkClientRegistrationEnabled();
                ClientRegistrationResponse registrationResponse = this.clientRegistrationService.register(newApplicationEntity);
                try {
                    metadata.put("client_id", registrationResponse.getClientId());
                    metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            if (newApplicationEntity.getGroups() != null && !newApplicationEntity.getGroups().isEmpty()) {
                this.groupService.findByIds(newApplicationEntity.getGroups());
            }
            Application application = ApplicationServiceImpl.convert(newApplicationEntity);
            application.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
            application.setStatus(ApplicationStatus.ACTIVE);
            metadata.forEach((key, value) -> application.getMetadata().put(key, value));
            Set defaultGroups = this.groupService.findByEvent(GroupEvent.APPLICATION_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
            if (!defaultGroups.isEmpty() && application.getGroups() == null) {
                application.setGroups(defaultGroups);
            } else if (!defaultGroups.isEmpty()) {
                application.getGroups().addAll(defaultGroups);
            }
            application.setCreatedAt(new Date());
            application.setUpdatedAt(application.getCreatedAt());
            Application createdApplication = (Application)this.applicationRepository.create((Object)application);
            this.auditService.createApplicationAuditLog(createdApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_CREATED, this.isAuthenticated() ? this.getAuthenticatedUsername() : userId, createdApplication.getCreatedAt(), null, createdApplication);
            Membership membership = new Membership(userId, createdApplication.getId(), MembershipReferenceType.APPLICATION);
            membership.setRoles(Collections.singletonMap(RoleScope.APPLICATION.getId(), SystemRole.PRIMARY_OWNER.name()));
            membership.setCreatedAt(application.getCreatedAt());
            membership.setUpdatedAt(application.getCreatedAt());
            this.membershipRepository.create(membership);
            UserEntity userEntity = this.userService.findById(userId);
            if (userEntity.getEmail() != null && !userEntity.getEmail().isEmpty()) {
                GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
                notificationConfigEntity.setName("Default Mail Notifications");
                notificationConfigEntity.setReferenceType(HookScope.APPLICATION.name());
                notificationConfigEntity.setReferenceId(createdApplication.getId());
                notificationConfigEntity.setHooks(Arrays.stream(ApplicationHook.values()).map(Enum::name).collect(Collectors.toList()));
                notificationConfigEntity.setNotifier("default-email");
                notificationConfigEntity.setConfig(userEntity.getEmail());
                this.genericNotificationConfigService.create(notificationConfigEntity);
            }
            return this.convert(createdApplication, userEntity);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for user {}", new Object[]{newApplicationEntity, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + newApplicationEntity + " for user " + userId, ex);
        }
    }

    @Override
    public ApplicationEntity update(String applicationId, UpdateApplicationEntity updateApplicationEntity) {
        try {
            Optional optApplicationToUpdate;
            this.LOGGER.debug("Update application {}", (Object)applicationId);
            if (updateApplicationEntity.getGroups() != null && !updateApplicationEntity.getGroups().isEmpty()) {
                this.groupService.findByIds(updateApplicationEntity.getGroups());
            }
            if (!(optApplicationToUpdate = this.applicationRepository.findById((Object)applicationId)).isPresent()) {
                throw new ApplicationNotFoundException(applicationId);
            }
            if (updateApplicationEntity.getSettings().getApp() != null && updateApplicationEntity.getSettings().getoAuthClient() != null) {
                throw new InvalidApplicationTypeException();
            }
            if (updateApplicationEntity.getSettings().getApp() == null && updateApplicationEntity.getSettings().getoAuthClient() == null) {
                throw new InvalidApplicationTypeException();
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (((Application)optApplicationToUpdate.get()).getType() == ApplicationType.SIMPLE && updateApplicationEntity.getSettings().getApp() != null) {
                String clientId = updateApplicationEntity.getSettings().getApp().getClientId();
                if (clientId != null && !clientId.trim().isEmpty()) {
                    this.LOGGER.debug("Check that client_id is unique among all applications");
                    Set applications = this.applicationRepository.findAll(new ApplicationStatus[]{ApplicationStatus.ACTIVE});
                    Optional<Application> byClientId = applications.stream().filter(app -> app.getMetadata() != null && clientId.equals(app.getMetadata().get("client_id"))).findAny();
                    if (byClientId.isPresent() && !byClientId.get().getId().equals(((Application)optApplicationToUpdate.get()).getId())) {
                        this.LOGGER.error("An application already exists with the same client_id");
                        throw new ClientIdAlreadyExistsException(clientId);
                    }
                }
            } else {
                this.checkClientRegistrationEnabled();
                ClientRegistrationResponse registrationResponse = this.clientRegistrationService.update((String)((Application)optApplicationToUpdate.get()).getMetadata().get("registration_payload"), updateApplicationEntity);
                try {
                    metadata.put("client_id", registrationResponse.getClientId());
                    metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            final Application application = ApplicationServiceImpl.convert(updateApplicationEntity);
            application.setId(applicationId);
            application.setStatus(ApplicationStatus.ACTIVE);
            application.setType(((Application)optApplicationToUpdate.get()).getType());
            application.setCreatedAt(((Application)optApplicationToUpdate.get()).getCreatedAt());
            application.setUpdatedAt(new Date());
            metadata.forEach((key, value) -> application.getMetadata().put(key, value));
            Application updatedApplication = (Application)this.applicationRepository.update((Object)application);
            this.auditService.createApplicationAuditLog(updatedApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_UPDATED, updatedApplication.getUpdatedAt(), optApplicationToUpdate.get(), updatedApplication);
            SubscriptionQuery subQuery = new SubscriptionQuery();
            subQuery.setApplication(applicationId);
            subQuery.setStatuses(Collections.singleton(SubscriptionStatus.ACCEPTED));
            this.subscriptionService.search(subQuery).forEach(new Consumer<SubscriptionEntity>(){

                @Override
                public void accept(SubscriptionEntity subscriptionEntity) {
                    UpdateSubscriptionEntity updateSubscriptionEntity = new UpdateSubscriptionEntity();
                    updateSubscriptionEntity.setId(subscriptionEntity.getId());
                    updateSubscriptionEntity.setStartingAt(subscriptionEntity.getStartingAt());
                    updateSubscriptionEntity.setEndingAt(subscriptionEntity.getEndingAt());
                    ApplicationServiceImpl.this.subscriptionService.update(updateSubscriptionEntity, (String)application.getMetadata().get("client_id"));
                }
            });
            return this.convert(Collections.singleton(updatedApplication)).iterator().next();
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update application %s", applicationId), ex);
        }
    }

    private void checkClientRegistrationEnabled() {
        if (!this.parameterService.findAsBoolean(Key.APPLICATION_REGISTRATION_ENABLED)) {
            throw new IllegalStateException("The client registration is disabled");
        }
    }

    @Override
    public void archive(String applicationId) {
        try {
            this.LOGGER.debug("Delete application {}", (Object)applicationId);
            Optional optApplication = this.applicationRepository.findById((Object)applicationId);
            if (!optApplication.isPresent()) {
                throw new ApplicationNotFoundException(applicationId);
            }
            Application application = (Application)optApplication.get();
            Application previousApplication = new Application(application);
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApplicationAndPlan(applicationId, null);
            subscriptions.forEach(subscription -> {
                Set<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscription.getId());
                apiKeys.forEach(apiKey -> {
                    try {
                        this.apiKeyService.delete(apiKey.getKey());
                    }
                    catch (TechnicalManagementException tme) {
                        this.LOGGER.error("An error occurs while deleting API Key {}", (Object)apiKey.getKey(), (Object)tme);
                    }
                });
                try {
                    this.subscriptionService.close(subscription.getId());
                }
                catch (SubscriptionNotClosableException snce) {
                    this.LOGGER.debug("The subscription can not be closed: {}", (Object)snce.getMessage());
                }
            });
            application.setUpdatedAt(new Date());
            application.setStatus(ApplicationStatus.ARCHIVED);
            this.applicationRepository.update((Object)application);
            this.auditService.createApplicationAuditLog(application.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_ARCHIVED, application.getUpdatedAt(), previousApplication, application);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete application %s", applicationId), ex);
        }
    }

    private Set<ApplicationEntity> convert(Set<Application> applications) throws TechnicalException {
        if (applications == null || applications.isEmpty()) {
            return Collections.emptySet();
        }
        Set memberships = this.membershipRepository.findByReferencesAndRole(MembershipReferenceType.APPLICATION, applications.stream().map(Application::getId).collect(Collectors.toList()), RoleScope.APPLICATION, SystemRole.PRIMARY_OWNER.name());
        int poMissing = applications.size() - memberships.size();
        if (poMissing > 0) {
            Set appIds = applications.stream().map(Application::getId).collect(Collectors.toSet());
            Set appMembershipsIds = memberships.stream().map(Membership::getReferenceId).collect(Collectors.toSet());
            appIds.removeAll(appMembershipsIds);
            Optional optionalApplicationsAsString = appIds.stream().reduce((a, b) -> a + " / " + b);
            String applicationsAsString = "?";
            if (optionalApplicationsAsString.isPresent()) {
                applicationsAsString = (String)optionalApplicationsAsString.get();
            }
            this.LOGGER.error("{} applications has no identified primary owners in this list {}.", (Object)poMissing, (Object)applicationsAsString);
            throw new TechnicalManagementException(poMissing + " applications has no identified primary owners in this list " + applicationsAsString + ".");
        }
        HashMap applicationToUser = new HashMap(memberships.size());
        memberships.forEach(membership -> applicationToUser.put(membership.getReferenceId(), membership.getUserId()));
        HashMap userIdToUserEntity = new HashMap(memberships.size());
        this.userService.findByIds(memberships.stream().map(Membership::getUserId).collect(Collectors.toList())).forEach(userEntity -> userIdToUserEntity.put(userEntity.getId(), userEntity));
        return applications.stream().map(publicApplication -> this.convert((Application)publicApplication, (UserEntity)userIdToUserEntity.get(applicationToUser.get(publicApplication.getId())))).collect(Collectors.toSet());
    }

    private Set<ApplicationListItem> convertToList(Set<Application> applications) throws TechnicalException {
        Set<ApplicationEntity> entities = this.convert(applications);
        return entities.stream().map(new Function<ApplicationEntity, ApplicationListItem>(){

            @Override
            public ApplicationListItem apply(ApplicationEntity applicationEntity) {
                ApplicationListItem item = new ApplicationListItem();
                item.setId(applicationEntity.getId());
                item.setName(applicationEntity.getName());
                item.setDescription(applicationEntity.getDescription());
                item.setCreatedAt(applicationEntity.getCreatedAt());
                item.setUpdatedAt(applicationEntity.getUpdatedAt());
                item.setGroups(applicationEntity.getGroups());
                item.setPrimaryOwner(applicationEntity.getPrimaryOwner());
                item.setType(applicationEntity.getType());
                item.setStatus(applicationEntity.getStatus());
                ApplicationListItemSettings settings = new ApplicationListItemSettings();
                if (applicationEntity.getSettings().getApp() != null) {
                    settings.setType(applicationEntity.getSettings().getApp().getType());
                    settings.setClientId(applicationEntity.getSettings().getApp().getClientId());
                } else if (applicationEntity.getSettings().getoAuthClient() != null) {
                    settings.setClientId(applicationEntity.getSettings().getoAuthClient().getClientId());
                }
                item.setSettings(settings);
                return item;
            }
        }).collect(Collectors.toSet());
    }

    private ApplicationEntity convert(Application application, UserEntity primaryOwner) {
        ApplicationEntity applicationEntity = new ApplicationEntity();
        applicationEntity.setId(application.getId());
        applicationEntity.setName(application.getName());
        applicationEntity.setDescription(application.getDescription());
        if (application.getType() != null) {
            applicationEntity.setType(application.getType().name());
        }
        applicationEntity.setStatus(application.getStatus().toString());
        applicationEntity.setGroups(application.getGroups());
        applicationEntity.setCreatedAt(application.getCreatedAt());
        applicationEntity.setUpdatedAt(application.getUpdatedAt());
        if (primaryOwner != null) {
            applicationEntity.setPrimaryOwner(new PrimaryOwnerEntity(primaryOwner));
        }
        ApplicationSettings settings = new ApplicationSettings();
        if (application.getType() == ApplicationType.SIMPLE) {
            SimpleApplicationSettings simpleSettings = new SimpleApplicationSettings();
            if (application.getMetadata() != null) {
                if (application.getMetadata().get("client_id") != null) {
                    simpleSettings.setClientId((String)application.getMetadata().get("client_id"));
                }
                if (application.getMetadata().get("type") != null) {
                    simpleSettings.setType((String)application.getMetadata().get("type"));
                }
            }
            settings.setApp(simpleSettings);
        } else {
            OAuthClientSettings clientSettings = new OAuthClientSettings();
            if (application.getMetadata() != null) {
                try {
                    String registrationPayload = (String)application.getMetadata().get("registration_payload");
                    if (registrationPayload != null) {
                        ClientRegistrationResponse registrationResponse = (ClientRegistrationResponse)this.mapper.readValue(registrationPayload, ClientRegistrationResponse.class);
                        clientSettings.setClientId(registrationResponse.getClientId());
                        clientSettings.setClientSecret(registrationResponse.getClientSecret());
                        clientSettings.setClientUri(registrationResponse.getClientUri());
                        clientSettings.setApplicationType(registrationResponse.getApplicationType());
                        clientSettings.setLogoUri(registrationResponse.getLogoUri());
                        clientSettings.setResponseTypes(registrationResponse.getResponseTypes());
                        clientSettings.setRedirectUris(registrationResponse.getRedirectUris());
                        clientSettings.setGrantTypes(registrationResponse.getGrantTypes());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            settings.setoAuthClient(clientSettings);
        }
        applicationEntity.setSettings(settings);
        return applicationEntity;
    }

    private static Application convert(NewApplicationEntity newApplicationEntity) {
        Application application = new Application();
        application.setName(newApplicationEntity.getName().trim());
        application.setDescription(newApplicationEntity.getDescription().trim());
        application.setGroups(newApplicationEntity.getGroups());
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (newApplicationEntity.getSettings().getApp() != null) {
            application.setType(ApplicationType.SIMPLE);
            if (newApplicationEntity.getSettings().getApp().getClientId() != null) {
                metadata.put("client_id", newApplicationEntity.getSettings().getApp().getClientId());
            }
            if (newApplicationEntity.getSettings().getApp().getType() != null) {
                metadata.put("type", newApplicationEntity.getSettings().getApp().getType());
            }
        } else {
            application.setType(ApplicationType.valueOf((String)newApplicationEntity.getSettings().getoAuthClient().getApplicationType().toUpperCase()));
        }
        application.setMetadata(metadata);
        return application;
    }

    private static Application convert(UpdateApplicationEntity updateApplicationEntity) {
        Application application = new Application();
        application.setName(updateApplicationEntity.getName().trim());
        application.setDescription(updateApplicationEntity.getDescription().trim());
        application.setGroups(updateApplicationEntity.getGroups());
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (updateApplicationEntity.getSettings().getApp() != null) {
            if (updateApplicationEntity.getSettings().getApp().getClientId() != null) {
                metadata.put("client_id", updateApplicationEntity.getSettings().getApp().getClientId());
            }
            if (updateApplicationEntity.getSettings().getApp().getType() != null) {
                metadata.put("type", updateApplicationEntity.getSettings().getApp().getType());
            }
        }
        application.setMetadata(metadata);
        return application;
    }
}

