/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.TenantEntity;
import io.gravitee.management.model.analytics.HistogramAnalytics;
import io.gravitee.management.model.analytics.HitsAnalytics;
import io.gravitee.management.model.analytics.Timestamp;
import io.gravitee.management.model.analytics.TopHitsAnalytics;
import io.gravitee.management.model.analytics.query.CountQuery;
import io.gravitee.management.model.analytics.query.DateHistogramQuery;
import io.gravitee.management.model.analytics.query.GroupByQuery;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.service.AnalyticsService;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.TenantService;
import io.gravitee.management.service.exceptions.ApiNotFoundException;
import io.gravitee.management.service.exceptions.ApplicationNotFoundException;
import io.gravitee.management.service.exceptions.PlanNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.TenantNotFoundException;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.analytics.api.AnalyticsRepository;
import io.gravitee.repository.analytics.query.AggregationType;
import io.gravitee.repository.analytics.query.DateHistogramQueryBuilder;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.Order;
import io.gravitee.repository.analytics.query.Query;
import io.gravitee.repository.analytics.query.QueryBuilders;
import io.gravitee.repository.analytics.query.SortBuilder;
import io.gravitee.repository.analytics.query.SortType;
import io.gravitee.repository.analytics.query.count.CountQueryBuilder;
import io.gravitee.repository.analytics.query.count.CountResponse;
import io.gravitee.repository.analytics.query.groupby.GroupByQueryBuilder;
import io.gravitee.repository.analytics.query.groupby.GroupByResponse;
import io.gravitee.repository.analytics.query.response.histogram.Bucket;
import io.gravitee.repository.analytics.query.response.histogram.Data;
import io.gravitee.repository.analytics.query.response.histogram.DateHistogramResponse;
import io.gravitee.repository.management.model.ApplicationStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsServiceImpl
implements AnalyticsService {
    private final Logger logger = LoggerFactory.getLogger(AnalyticsServiceImpl.class);
    private static final String APPLICATION_KEYLESS = "1";
    @Autowired
    private AnalyticsRepository analyticsRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private PlanService planService;
    @Autowired
    private TenantService tenantService;

    @Override
    public HitsAnalytics execute(CountQuery query) {
        try {
            CountResponse response = (CountResponse)this.analyticsRepository.query((Query)((CountQueryBuilder)((CountQueryBuilder)((CountQueryBuilder)QueryBuilders.count().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).build());
            return this.convert(response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    @Override
    public HistogramAnalytics execute(DateHistogramQuery query) {
        try {
            DateHistogramQueryBuilder queryBuilder = (DateHistogramQueryBuilder)((DateHistogramQueryBuilder)((DateHistogramQueryBuilder)QueryBuilders.dateHistogram().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier());
            if (query.getAggregations() != null) {
                query.getAggregations().stream().forEach(aggregation -> queryBuilder.aggregation(AggregationType.valueOf((String)aggregation.type().name()), aggregation.field()));
            }
            DateHistogramResponse response = (DateHistogramResponse)this.analyticsRepository.query((Query)queryBuilder.build());
            return this.convert(response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    @Override
    public TopHitsAnalytics execute(GroupByQuery query) {
        try {
            GroupByQueryBuilder queryBuilder = ((GroupByQueryBuilder)((GroupByQueryBuilder)((GroupByQueryBuilder)QueryBuilders.groupBy().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).field(query.getField());
            if (query.getGroups() != null) {
                query.getGroups().forEach((arg_0, arg_1) -> ((GroupByQueryBuilder)queryBuilder).range(arg_0, arg_1));
            }
            if (query.getOrder() != null) {
                GroupByQuery.Order order = query.getOrder();
                queryBuilder.sort(SortBuilder.on((String)order.getField(), (Order)(order.isOrder() ? Order.ASC : Order.DESC), (SortType)(order.getType() == null ? SortType.AVG : SortType.valueOf((String)order.getType().toUpperCase()))));
            }
            GroupByResponse response = (GroupByResponse)this.analyticsRepository.query((Query)queryBuilder.build());
            return this.convert(response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to calculate analytics", ae);
        }
    }

    private HistogramAnalytics convert(DateHistogramResponse histogramResponse) {
        HistogramAnalytics analytics = new HistogramAnalytics();
        List timestamps = histogramResponse.timestamps();
        if (timestamps != null && timestamps.size() > 1) {
            long from = (Long)timestamps.get(0);
            long interval = (Long)timestamps.get(1) - from;
            long to = (Long)timestamps.get(timestamps.size() - 1);
            analytics.setTimestamp(new Timestamp(Long.valueOf(from), Long.valueOf(to), Long.valueOf(interval)));
            ArrayList<io.gravitee.management.model.analytics.Bucket> buckets = new ArrayList<io.gravitee.management.model.analytics.Bucket>(histogramResponse.values().size());
            for (Bucket bucket : histogramResponse.values()) {
                io.gravitee.management.model.analytics.Bucket analyticsBucket = this.convertBucket(histogramResponse.timestamps(), from, interval, bucket);
                buckets.add(analyticsBucket);
            }
            analytics.setValues(buckets);
        }
        return analytics;
    }

    private io.gravitee.management.model.analytics.Bucket convertBucket(List<Long> timestamps, long from, long interval, Bucket bucket) {
        HashMap metadata;
        io.gravitee.management.model.analytics.Bucket analyticsBucket = new io.gravitee.management.model.analytics.Bucket();
        analyticsBucket.setName(bucket.name());
        analyticsBucket.setField(bucket.field());
        ArrayList<io.gravitee.management.model.analytics.Bucket> childBuckets = new ArrayList<io.gravitee.management.model.analytics.Bucket>();
        for (Bucket bucket2 : bucket.buckets()) {
            childBuckets.add(this.convertBucket(timestamps, from, interval, bucket2));
        }
        if (analyticsBucket.getField().equals("application")) {
            metadata = new HashMap();
            bucket.data().keySet().stream().forEach(app -> metadata.put(app, this.getApplicationMetadata((String)app)));
            analyticsBucket.setMetadata(metadata);
        } else if (analyticsBucket.getField().equals("api")) {
            metadata = new HashMap();
            bucket.data().keySet().stream().forEach(api -> metadata.put(api, this.getAPIMetadata((String)api)));
            analyticsBucket.setMetadata(metadata);
        } else if (analyticsBucket.getField().equals("tenant")) {
            metadata = new HashMap();
            bucket.data().keySet().stream().forEach(tenant -> metadata.put(tenant, this.getTenantMetadata((String)tenant)));
            analyticsBucket.setMetadata(metadata);
        }
        for (Map.Entry entry : bucket.data().entrySet()) {
            io.gravitee.management.model.analytics.Bucket analyticsDataBucket = new io.gravitee.management.model.analytics.Bucket();
            analyticsDataBucket.setName((String)entry.getKey());
            Number[] values = new Number[timestamps.size()];
            for (int i = 0; i < timestamps.size(); ++i) {
                values[i] = 0;
            }
            for (Data data : (List)entry.getValue()) {
                values[(int)((data.timestamp() - from) / interval)] = data.value();
            }
            analyticsDataBucket.setData(values);
            childBuckets.add(analyticsDataBucket);
        }
        analyticsBucket.setBuckets(childBuckets);
        return analyticsBucket;
    }

    private HitsAnalytics convert(CountResponse countResponse) {
        HitsAnalytics hitsAnalytics = new HitsAnalytics();
        hitsAnalytics.setHits(countResponse.getCount());
        return hitsAnalytics;
    }

    private TopHitsAnalytics convert(GroupByResponse groupByResponse) {
        TopHitsAnalytics topHitsAnalytics = new TopHitsAnalytics();
        topHitsAnalytics.setValues((Map)groupByResponse.values().stream().collect(Collectors.toMap(GroupByResponse.Bucket::name, GroupByResponse.Bucket::value, (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
        }, LinkedHashMap::new)));
        String fieldName = groupByResponse.getField();
        if (fieldName != null && !fieldName.isEmpty()) {
            HashMap<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
            if (topHitsAnalytics.getValues() != null) {
                block14: for (String key : topHitsAnalytics.getValues().keySet()) {
                    switch (fieldName) {
                        case "api": {
                            metadata.put(key, this.getAPIMetadata(key));
                            continue block14;
                        }
                        case "application": {
                            metadata.put(key, this.getApplicationMetadata(key));
                            continue block14;
                        }
                        case "plan": {
                            metadata.put(key, this.getPlanMetadata(key));
                            continue block14;
                        }
                        case "tenant": {
                            metadata.put(key, this.getTenantMetadata(key));
                            continue block14;
                        }
                        case "geoip.country_iso_code": {
                            metadata.put(key, this.getCountryName(key));
                            continue block14;
                        }
                    }
                    metadata.put(key, this.getGenericMetadata(key));
                }
            }
            topHitsAnalytics.setMetadata(metadata);
        }
        return topHitsAnalytics;
    }

    private Map<String, String> getAPIMetadata(String api) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            ApiEntity apiEntity = this.apiService.findById(api);
            metadata.put("name", apiEntity.getName());
            metadata.put("version", apiEntity.getVersion());
        }
        catch (ApiNotFoundException anfe) {
            metadata.put("name", "Deleted API");
            metadata.put("deleted", "true");
        }
        return metadata;
    }

    private Map<String, String> getApplicationMetadata(String application) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            ApplicationEntity applicationEntity = this.applicationService.findById(application);
            metadata.put("name", applicationEntity.getName());
            if (ApplicationStatus.ARCHIVED.toString().equals(applicationEntity.getStatus())) {
                metadata.put("deleted", "true");
            }
        }
        catch (ApplicationNotFoundException anfe) {
            metadata.put("deleted", "true");
            if (application.equals(APPLICATION_KEYLESS)) {
                metadata.put("name", "Unknown application (keyless)");
            }
            metadata.put("name", "Deleted application");
        }
        return metadata;
    }

    private Map<String, String> getPlanMetadata(String plan) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            PlanEntity planEntity = this.planService.findById(plan);
            metadata.put("name", planEntity.getName());
        }
        catch (PlanNotFoundException anfe) {
            metadata.put("deleted", "true");
        }
        return metadata;
    }

    private Map<String, String> getTenantMetadata(String tenant) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            TenantEntity tenantEntity = this.tenantService.findById(tenant);
            metadata.put("name", tenantEntity.getName());
        }
        catch (TenantNotFoundException tnfe) {
            metadata.put("deleted", "true");
        }
        return metadata;
    }

    private Map<String, String> getCountryName(String country_iso) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", new Locale("", country_iso).getDisplayCountry(Locale.UK));
        return metadata;
    }

    private Map<String, String> getGenericMetadata(String value) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", value);
        return metadata;
    }
}

