/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.alert.impl;

import io.gravitee.alert.api.service.AlertTrigger;
import io.gravitee.alert.api.trigger.Trigger;
import io.gravitee.management.model.alert.AlertEntity;
import io.gravitee.management.model.alert.AlertReferenceType;
import io.gravitee.management.model.alert.AlertType;
import io.gravitee.management.service.AlertService;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.alert.AlertTriggerService;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.notifier.api.Notification;
import io.gravitee.plugin.alert.AlertEngineService;
import io.vertx.core.json.JsonObject;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class AlertTriggerServiceImpl
extends AbstractService
implements AlertTrigger,
AlertTriggerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertTriggerServiceImpl.class);
    private static final String CONDITION_FORMAT = ".type == \"%s\" and .props.%s == \"%s\"";
    private static final String PLAN_CONDITION_FORMAT = " and .props.Plan == \"%s\"";
    private static final String THRESHOLD_CONDITION_FORMAT = " and .props.\"%s\" >= %.2f";
    @Autowired
    private AlertService alertService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private AlertEngineService alertEngineService;
    @Autowired
    private ConfigurableEnvironment environment;
    @Value(value="${notifiers.email.subject:[Gravitee.io] %s}")
    private String subject;
    @Value(value="${notifiers.email.host}")
    private String host;
    @Value(value="${notifiers.email.port}")
    private String port;
    @Value(value="${notifiers.email.username:#{null}}")
    private String username;
    @Value(value="${notifiers.email.password:#{null}}")
    private String password;
    @Value(value="${notifiers.email.from}")
    private String defaultFrom;
    @Value(value="${notifiers.email.starttls.enabled:false}")
    private boolean startTLSEnabled;
    @Value(value="${notifiers.email.ssl.trustAll:false}")
    private boolean sslTrustAll;
    @Value(value="${notifiers.email.ssl.keyStore:#{null}}")
    private String sslKeyStore;
    @Value(value="${notifiers.email.ssl.keyStorePassword:#{null}}")
    private String sslKeyStorePassword;
    @Value(value="${alerts.enabled:false}")
    private boolean alertEnabled;

    public void triggerAll() {
        this.alertService.findAll().stream().filter(AlertEntity::isEnabled).forEach(this::trigger);
    }

    @Override
    public void trigger(AlertEntity alert) {
        if (this.alertEnabled) {
            String ownerEmail = this.getOwnerEmail(alert);
            if (ownerEmail == null) {
                LOGGER.warn("Alert cannot be sent cause the owner of the {} '{}' has no configured email", (Object)alert.getReferenceType(), (Object)alert.getReferenceId());
            } else {
                Trigger.Builder builder = new Trigger.Builder();
                String portalUrl = this.environment.getProperty("portalURL");
                if (portalUrl != null && portalUrl.endsWith("/")) {
                    portalUrl = portalUrl.substring(0, portalUrl.length() - 1);
                }
                if (portalUrl != null) {
                    String href = AlertType.HEALTH_CHECK.equals((Object)alert.getType()) ? portalUrl + String.format("/#!/management/apis/%s/healthcheck/", alert.getReferenceId()) : portalUrl + String.format("/#!/management/%ss/%s/analytics", alert.getReferenceType().name().toLowerCase(), alert.getReferenceId());
                    builder.link("View details", href);
                }
                String condition = String.format(CONDITION_FORMAT, alert.getType(), alert.getReferenceType(), alert.getReferenceId());
                if (alert.getPlan() != null) {
                    condition = condition + String.format(PLAN_CONDITION_FORMAT, alert.getPlan());
                }
                if (alert.getMetricType() != null) {
                    condition = condition + String.format(Locale.US, THRESHOLD_CONDITION_FORMAT, alert.getMetricType().eventProperty(), alert.getThreshold());
                }
                Notification notification = new Notification();
                notification.setType("email");
                notification.setDestination(ownerEmail);
                String triggerName = alert.getDescription() == null ? alert.getName() : alert.getDescription();
                JsonObject configuration = new JsonObject();
                configuration.put("subject", String.format(this.subject, "Alert: " + triggerName));
                configuration.put("from", this.defaultFrom);
                configuration.put("host", this.host);
                configuration.put("port", this.port);
                configuration.put("username", this.username);
                configuration.put("password", this.password);
                configuration.put("startTLSEnabled", Boolean.valueOf(this.startTLSEnabled));
                configuration.put("sslTrustAll", Boolean.valueOf(this.sslTrustAll));
                configuration.put("sslKeyStore", this.sslKeyStore);
                configuration.put("sslKeyStorePassword", this.sslKeyStorePassword);
                Trigger.Builder triggerBuilder = builder.id(alert.getId()).name(triggerName).condition(condition).eventType(alert.getType().name()).context(alert.getReferenceType().name(), alert.getReferenceId()).scopeProperty(AlertReferenceType.API.equals((Object)alert.getReferenceType()) ? AlertReferenceType.APPLICATION.name() : AlertReferenceType.API.name()).notification(ownerEmail, "email", configuration.encodePrettily()).notifyOnce(AlertType.REQUEST.equals((Object)alert.getType()));
                if (alert.getPlan() != null) {
                    triggerBuilder.context("PLAN", alert.getPlan());
                    triggerBuilder.scopeProperty("PLAN");
                }
                this.alertEngineService.send(triggerBuilder.build()).exceptionally(t -> {
                    LOGGER.error("Failed to send message trigger!", t);
                    return null;
                });
            }
        }
    }

    @Override
    public void disable(AlertEntity alert) {
        if (this.alertEnabled) {
            Trigger trigger = new Trigger.Builder().id(alert.getId()).enabled(false).build();
            this.alertEngineService.send(trigger).exceptionally(t -> {
                LOGGER.error("Failed to send message trigger disable!", t);
                return null;
            });
        }
    }

    private String getOwnerEmail(AlertEntity alert) {
        switch (alert.getReferenceType()) {
            case API: {
                return this.apiService.findById(alert.getReferenceId()).getPrimaryOwner().getEmail();
            }
            case APPLICATION: {
                return this.applicationService.findById(alert.getReferenceId()).getPrimaryOwner().getEmail();
            }
        }
        return null;
    }
}

