/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service;

import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.GroupEntity;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.UserMembership;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.pagedresult.Metadata;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface MembershipService {
    public MemberEntity getMember(MembershipReferenceType var1, String var2, String var3, RoleScope var4);

    public RoleEntity getRole(MembershipReferenceType var1, String var2, String var3, RoleScope var4);

    public Set<RoleEntity> getRoles(MembershipReferenceType var1, Set<String> var2, String var3, RoleScope var4);

    public Set<MemberEntity> getMembers(MembershipReferenceType var1, String var2, RoleScope var3);

    public Set<MemberEntity> getMembers(MembershipReferenceType var1, String var2, RoleScope var3, String var4);

    public MemberEntity addOrUpdateMember(MembershipReference var1, MembershipUser var2, MembershipRole var3);

    public void deleteMember(MembershipReferenceType var1, String var2, String var3);

    public void transferApiOwnership(String var1, MembershipUser var2, RoleEntity var3);

    public void transferApplicationOwnership(String var1, MembershipUser var2, RoleEntity var3);

    public Map<String, char[]> getMemberPermissions(ApiEntity var1, String var2);

    public Map<String, char[]> getMemberPermissions(ApplicationEntity var1, String var2);

    public Map<String, char[]> getMemberPermissions(GroupEntity var1, String var2);

    public boolean removeRole(MembershipReferenceType var1, String var2, String var3, RoleScope var4);

    public void removeRoleUsage(RoleScope var1, String var2, String var3);

    public void removeUser(String var1);

    public List<UserMembership> findUserMembership(String var1, MembershipReferenceType var2);

    public Metadata findUserMembershipMetadata(List<UserMembership> var1, MembershipReferenceType var2);

    public int getNumberOfMembers(MembershipReferenceType var1, String var2, RoleScope var3);

    public static class MembershipRole {
        private final RoleScope scope;
        private final String name;

        public MembershipRole(RoleScope scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public RoleScope getScope() {
            return this.scope;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MembershipRole that = (MembershipRole)o;
            if (this.scope != that.scope) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.scope.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }

    public static class MembershipUser {
        private final String id;
        private final String reference;

        public MembershipUser(String id, String reference) {
            this.id = id;
            this.reference = reference;
        }

        public String getId() {
            return this.id;
        }

        public String getReference() {
            return this.reference;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MembershipUser that = (MembershipUser)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            return this.reference != null ? this.reference.equals(that.reference) : that.reference == null;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.reference != null ? this.reference.hashCode() : 0);
            return result;
        }
    }

    public static class MembershipReference {
        private final MembershipReferenceType type;
        private final String id;

        public MembershipReference(MembershipReferenceType type, String id) {
            this.type = type;
            this.id = id;
        }

        public MembershipReferenceType getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MembershipReference that = (MembershipReference)o;
            if (this.type != that.type) {
                return false;
            }
            return this.id.equals(that.id);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }
}

