/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.notifiers.impl;

import io.gravitee.management.model.ApiModelEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.builder.EmailNotificationBuilder;
import io.gravitee.management.service.notification.ApiHook;
import io.gravitee.management.service.notification.ApplicationHook;
import io.gravitee.management.service.notification.Hook;
import io.gravitee.management.service.notification.PortalHook;
import io.gravitee.management.service.notifiers.EmailNotifierService;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailNotifierServiceImpl
implements EmailNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(EmailNotifierServiceImpl.class);
    @Autowired
    EmailService emailService;

    @Override
    public void trigger(Hook hook, GenericNotificationConfig genericNotificationConfig, Map<String, Object> params) {
        String[] mails;
        if (genericNotificationConfig == null || genericNotificationConfig.getConfig() == null || genericNotificationConfig.getConfig().isEmpty()) {
            this.LOGGER.error("Email Notifier configuration is empty");
            return;
        }
        EmailNotificationBuilder.EmailTemplate emailTemplate = this.getEmailTemplate(hook);
        if (emailTemplate == null) {
            this.LOGGER.error("Email template not found for hook {}", (Object)hook);
            return;
        }
        for (String mail : mails = genericNotificationConfig.getConfig().split(",|;|\\s")) {
            if (mail.isEmpty()) continue;
            this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(mail).subject(this.getEmailSubject(hook, params)).template(emailTemplate).params(params).build());
        }
    }

    private EmailNotificationBuilder.EmailTemplate getEmailTemplate(Hook hook) {
        if (hook == null) {
            return null;
        }
        if (hook.equals(ApiHook.APIKEY_REVOKED)) {
            return EmailNotificationBuilder.EmailTemplate.REVOKE_API_KEY;
        }
        if (hook.equals(ApiHook.APIKEY_RENEWED)) {
            return EmailNotificationBuilder.EmailTemplate.RENEWED_API_KEY;
        }
        if (hook.equals(ApiHook.APIKEY_EXPIRED)) {
            return EmailNotificationBuilder.EmailTemplate.EXPIRE_API_KEY;
        }
        if (hook.equals(ApiHook.SUBSCRIPTION_ACCEPTED) || hook.equals(ApiHook.SUBSCRIPTION_NEW)) {
            return EmailNotificationBuilder.EmailTemplate.NEW_SUBSCRIPTION;
        }
        if (hook.equals(ApiHook.SUBSCRIPTION_CLOSED)) {
            return EmailNotificationBuilder.EmailTemplate.CLOSE_SUBSCRIPTION;
        }
        if (hook.equals(ApiHook.SUBSCRIPTION_REJECTED)) {
            return EmailNotificationBuilder.EmailTemplate.REJECT_SUBSCRIPTION;
        }
        if (hook.equals(ApiHook.SUBSCRIPTION_PAUSED)) {
            return EmailNotificationBuilder.EmailTemplate.PAUSE_SUBSCRIPTION;
        }
        if (hook.equals(ApiHook.SUBSCRIPTION_RESUMED)) {
            return EmailNotificationBuilder.EmailTemplate.RESUME_SUBSCRIPTION;
        }
        if (hook.equals(ApiHook.SUBSCRIPTION_TRANSFERRED)) {
            return EmailNotificationBuilder.EmailTemplate.TRANSFER_SUBSCRIPTION;
        }
        if (hook.equals(ApiHook.NEW_SUPPORT_TICKET)) {
            return EmailNotificationBuilder.EmailTemplate.SUPPORT_TICKET_NOTIFICATION;
        }
        if (hook.equals(ApiHook.API_STOPPED)) {
            return EmailNotificationBuilder.EmailTemplate.API_STOPPED;
        }
        if (hook.equals(ApiHook.API_STARTED)) {
            return EmailNotificationBuilder.EmailTemplate.API_STARTED;
        }
        if (hook.equals(ApiHook.NEW_RATING)) {
            return EmailNotificationBuilder.EmailTemplate.NEW_RATING;
        }
        if (hook.equals(ApiHook.NEW_RATING_ANSWER)) {
            return EmailNotificationBuilder.EmailTemplate.NEW_RATING_ANSWER;
        }
        if (hook.equals(ApplicationHook.SUBSCRIPTION_NEW)) {
            return EmailNotificationBuilder.EmailTemplate.SUBSCRIPTION_CREATED;
        }
        if (hook.equals(ApplicationHook.SUBSCRIPTION_ACCEPTED)) {
            return EmailNotificationBuilder.EmailTemplate.APPROVE_SUBSCRIPTION;
        }
        if (hook.equals(ApplicationHook.SUBSCRIPTION_REJECTED)) {
            return EmailNotificationBuilder.EmailTemplate.REJECT_SUBSCRIPTION;
        }
        if (hook.equals(ApplicationHook.SUBSCRIPTION_CLOSED)) {
            return EmailNotificationBuilder.EmailTemplate.CLOSE_SUBSCRIPTION;
        }
        if (hook.equals(ApplicationHook.SUBSCRIPTION_PAUSED)) {
            return EmailNotificationBuilder.EmailTemplate.PAUSE_SUBSCRIPTION;
        }
        if (hook.equals(ApplicationHook.SUBSCRIPTION_RESUMED)) {
            return EmailNotificationBuilder.EmailTemplate.RESUME_SUBSCRIPTION;
        }
        if (hook.equals(ApplicationHook.SUBSCRIPTION_TRANSFERRED)) {
            return EmailNotificationBuilder.EmailTemplate.TRANSFER_SUBSCRIPTION;
        }
        if (hook.equals(ApplicationHook.NEW_SUPPORT_TICKET)) {
            return EmailNotificationBuilder.EmailTemplate.SUPPORT_TICKET_NOTIFICATION;
        }
        if (hook.equals(PortalHook.USER_REGISTERED)) {
            return EmailNotificationBuilder.EmailTemplate.USER_REGISTERED;
        }
        if (hook.equals(PortalHook.USER_CREATED)) {
            return EmailNotificationBuilder.EmailTemplate.USER_CREATED;
        }
        if (hook.equals(PortalHook.PASSWORD_RESET)) {
            return EmailNotificationBuilder.EmailTemplate.PASSWORD_RESET;
        }
        if (hook.equals(PortalHook.USER_FIRST_LOGIN)) {
            return EmailNotificationBuilder.EmailTemplate.USER_FIRST_LOGIN;
        }
        if (hook.equals(PortalHook.NEW_SUPPORT_TICKET)) {
            return EmailNotificationBuilder.EmailTemplate.SUPPORT_TICKET_NOTIFICATION;
        }
        return null;
    }

    private String getEmailSubject(Hook hook, Map<String, Object> params) {
        if (hook.equals(ApiHook.APIKEY_REVOKED) && params.containsKey("api")) {
            Object api = params.get("api");
            if (api != null) {
                String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                return "API key revoked for API " + apiName;
            }
        } else {
            if (hook.equals(ApiHook.APIKEY_EXPIRED)) {
                return "API key expiration!";
            }
            if (hook.equals(ApiHook.APIKEY_RENEWED)) {
                return "API key renewed";
            }
            if (hook.equals(ApiHook.SUBSCRIPTION_ACCEPTED) || hook.equals(ApiHook.SUBSCRIPTION_NEW)) {
                Object api = params.get("api");
                Object plan = params.get("plan");
                if (api != null && plan != null) {
                    String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                    return "New subscription for " + apiName + " with plan " + ((PlanEntity)plan).getName();
                }
            } else {
                if (hook.equals(ApiHook.SUBSCRIPTION_CLOSED)) {
                    return "Subscription closed";
                }
                if (hook.equals(ApiHook.SUBSCRIPTION_REJECTED)) {
                    return "Subscription rejected";
                }
                if (hook.equals(ApiHook.SUBSCRIPTION_PAUSED)) {
                    Object api = params.get("api");
                    Object plan = params.get("plan");
                    if (api != null && plan != null) {
                        String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                        return "Subscription for " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been paused";
                    }
                } else if (hook.equals(ApiHook.SUBSCRIPTION_RESUMED)) {
                    Object api = params.get("api");
                    Object plan = params.get("plan");
                    if (api != null && plan != null) {
                        String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                        return "Subscription for " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been resumed";
                    }
                } else if (hook.equals(ApiHook.SUBSCRIPTION_TRANSFERRED)) {
                    Object api = params.get("api");
                    Object plan = params.get("plan");
                    if (api != null && plan != null) {
                        String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                        return "Subscription for " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been transferred";
                    }
                } else {
                    if (hook.equals(ApiHook.NEW_SUPPORT_TICKET)) {
                        return "New Support Ticket";
                    }
                    if (hook.equals(ApiHook.API_STOPPED)) {
                        return "API Stopped";
                    }
                    if (hook.equals(ApiHook.API_STARTED)) {
                        return "API Started";
                    }
                    if (hook.equals(ApiHook.NEW_RATING)) {
                        return "New Rating";
                    }
                    if (hook.equals(ApiHook.NEW_RATING_ANSWER)) {
                        return "New Rating Answer";
                    }
                    if (hook.equals(ApplicationHook.SUBSCRIPTION_NEW)) {
                        Object api = params.get("api");
                        Object plan = params.get("plan");
                        if (api != null && plan != null) {
                            String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                            return "New subscription to " + apiName + " with plan " + ((PlanEntity)plan).getName();
                        }
                    } else if (hook.equals(ApplicationHook.SUBSCRIPTION_ACCEPTED)) {
                        Object api = params.get("api");
                        Object plan = params.get("plan");
                        if (api != null && plan != null) {
                            String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                            return "Your subscription to " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been approved";
                        }
                    } else if (hook.equals(ApplicationHook.SUBSCRIPTION_REJECTED)) {
                        Object api = params.get("api");
                        Object plan = params.get("plan");
                        if (api != null && plan != null) {
                            String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                            return "Your subscription to " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been rejected";
                        }
                    } else if (hook.equals(ApplicationHook.SUBSCRIPTION_CLOSED)) {
                        Object api = params.get("api");
                        Object plan = params.get("plan");
                        if (api != null && plan != null) {
                            String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                            return "Your subscription to " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been closed";
                        }
                    } else if (hook.equals(ApplicationHook.SUBSCRIPTION_PAUSED)) {
                        Object api = params.get("api");
                        Object plan = params.get("plan");
                        if (api != null && plan != null) {
                            String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                            return "Your subscription to " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been paused";
                        }
                    } else if (hook.equals(ApplicationHook.SUBSCRIPTION_RESUMED)) {
                        Object api = params.get("api");
                        Object plan = params.get("plan");
                        if (api != null && plan != null) {
                            String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                            return "Your subscription to " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been resumed";
                        }
                    } else if (hook.equals(ApplicationHook.SUBSCRIPTION_TRANSFERRED)) {
                        Object api = params.get("api");
                        Object plan = params.get("plan");
                        if (api != null && plan != null) {
                            String apiName = api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName();
                            return "Your subscription to " + apiName + " with plan " + ((PlanEntity)plan).getName() + " has been transferred";
                        }
                    } else {
                        if (hook.equals(ApplicationHook.NEW_SUPPORT_TICKET)) {
                            return "New Support Ticket by " + params.get("username");
                        }
                        if (hook.equals(PortalHook.USER_REGISTERED)) {
                            return "User registration - " + params.get("username");
                        }
                        if (hook.equals(PortalHook.USER_CREATED)) {
                            return "User creation - " + params.get("username");
                        }
                        if (hook.equals(PortalHook.PASSWORD_RESET)) {
                            return "Password reset - " + params.get("username");
                        }
                        if (hook.equals(PortalHook.USER_FIRST_LOGIN)) {
                            return "First login - " + params.get("username");
                        }
                        if (hook.equals(PortalHook.NEW_SUPPORT_TICKET)) {
                            return "New Support Ticket by " + params.get("username");
                        }
                    }
                }
            }
        }
        return null;
    }
}

