/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.management.model.GroupEntity;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.PlanStatus;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.documentation.PageQuery;
import io.gravitee.management.service.GroupService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.PageService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.UserService;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;

public abstract class ApiSerializer
extends StdSerializer<ApiEntity> {
    public static String METADATA_EXPORT_VERSION = "exportVersion";
    public static String METADATA_FILTERED_FIELDS_LIST = "filteredFieldsList";
    protected ApplicationContext applicationContext;

    protected ApiSerializer(Class<ApiEntity> t) {
        super(t);
    }

    public abstract Version version();

    public boolean canHandle(ApiEntity apiEntity) {
        return this.version().getVersion().equals(apiEntity.getMetadata().get(METADATA_EXPORT_VERSION));
    }

    public void serialize(ApiEntity apiEntity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List filteredFieldsList;
        jsonGenerator.writeStartObject();
        if (apiEntity.getName() != null) {
            jsonGenerator.writeObjectField("name", (Object)apiEntity.getName());
        }
        if (apiEntity.getVersion() != null) {
            jsonGenerator.writeObjectField("version", (Object)apiEntity.getVersion());
        }
        if (apiEntity.getDescription() != null) {
            jsonGenerator.writeObjectField("description", (Object)apiEntity.getDescription());
        }
        if (apiEntity.getVisibility() != null) {
            jsonGenerator.writeObjectField("visibility", (Object)apiEntity.getVisibility());
        }
        if (apiEntity.getTags() != null && !apiEntity.getTags().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("tags");
            for (String string : apiEntity.getTags()) {
                jsonGenerator.writeObject((Object)string);
            }
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getPicture() != null) {
            jsonGenerator.writeObjectField("picture", (Object)apiEntity.getPicture());
        }
        if (apiEntity.getPaths() != null) {
            jsonGenerator.writeObjectFieldStart("paths");
            for (Map.Entry entry : apiEntity.getPaths().entrySet()) {
                jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        if (apiEntity.getServices() != null && !apiEntity.getServices().isEmpty()) {
            jsonGenerator.writeObjectField("services", (Object)apiEntity.getServices());
        }
        if (apiEntity.getResources() != null) {
            jsonGenerator.writeArrayFieldStart("resources");
            for (Resource resource : apiEntity.getResources()) {
                jsonGenerator.writeObject((Object)resource);
            }
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getProperties() != null && apiEntity.getProperties().getValues() != null) {
            jsonGenerator.writeObjectField("properties", (Object)apiEntity.getProperties());
        }
        if (apiEntity.getViews() != null && !apiEntity.getViews().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("views");
            for (String string : apiEntity.getViews()) {
                jsonGenerator.writeObject((Object)string);
            }
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getLabels() != null && !apiEntity.getLabels().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("labels");
            for (String string : apiEntity.getLabels()) {
                jsonGenerator.writeObject((Object)string);
            }
            jsonGenerator.writeEndArray();
        }
        if (!(filteredFieldsList = (List)apiEntity.getMetadata().get(METADATA_FILTERED_FIELDS_LIST)).contains("groups") && apiEntity.getGroups() != null && !apiEntity.getGroups().isEmpty()) {
            Set<GroupEntity> set = ((GroupService)this.applicationContext.getBean(GroupService.class)).findByIds(apiEntity.getGroups());
            jsonGenerator.writeObjectField("groups", set.stream().map(GroupEntity::getName).collect(Collectors.toSet()));
        }
        if (!filteredFieldsList.contains("members")) {
            Set<MemberEntity> set = ((MembershipService)this.applicationContext.getBean(MembershipService.class)).getMembers(MembershipReferenceType.API, apiEntity.getId(), RoleScope.API);
            ArrayList members = new ArrayList(set == null ? 0 : set.size());
            if (set != null) {
                set.forEach(m -> {
                    UserEntity userEntity = ((UserService)this.applicationContext.getBean(UserService.class)).findById(m.getId());
                    if (userEntity != null) {
                        Member member = new Member();
                        member.setRole(m.getRole());
                        member.setSource(userEntity.getSource());
                        member.setSourceId(userEntity.getSourceId());
                        members.add(member);
                    }
                });
            }
            jsonGenerator.writeObjectField("members", members);
        }
        if (!filteredFieldsList.contains("pages")) {
            List<PageEntity> list = ((PageService)this.applicationContext.getBean(PageService.class)).search(new PageQuery.Builder().api(apiEntity.getId()).build());
            if (list != null) {
                list.forEach(f -> f.setId(null));
            }
            jsonGenerator.writeObjectField("pages", list == null ? Collections.emptyList() : list);
        }
        if (!filteredFieldsList.contains("plans")) {
            Set<PlanEntity> set = ((PlanService)this.applicationContext.getBean(PlanService.class)).findByApi(apiEntity.getId());
            Set plansToAdd = set == null ? Collections.emptySet() : set.stream().filter(p -> !PlanStatus.CLOSED.equals((Object)p.getStatus())).collect(Collectors.toSet());
            jsonGenerator.writeObjectField("plans", plansToAdd);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    class Member {
        private String username;
        private String source;
        private String sourceId;
        private String role;

        Member() {
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }

    public static enum Version {
        DEFAULT("default"),
        V_1_15("1.15");

        private final String version;

        private Version(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

