/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.jackson.ser.api.ApiSerializer;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Api1_15VersionSerializer
extends ApiSerializer {
    public Api1_15VersionSerializer() {
        super(ApiEntity.class);
    }

    @Override
    public void serialize(ApiEntity apiEntity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List filteredFieldsList;
        super.serialize(apiEntity, jsonGenerator, serializerProvider);
        if (apiEntity.getProxy() != null) {
            jsonGenerator.writeObjectFieldStart("proxy");
            jsonGenerator.writeObjectField("context_path", (Object)apiEntity.getProxy().getContextPath());
            jsonGenerator.writeObjectField("strip_context_path", (Object)apiEntity.getProxy().isStripContextPath());
            if (apiEntity.getProxy().getLogging() == null) {
                jsonGenerator.writeObjectField("loggingMode", (Object)LoggingMode.NONE);
            } else {
                jsonGenerator.writeObjectField("loggingMode", (Object)apiEntity.getProxy().getLogging().getMode());
            }
            jsonGenerator.writeObjectField("endpoints", apiEntity.getProxy().getGroups().stream().map(endpointGroup -> endpointGroup.getEndpoints()).flatMap(Collection::stream).collect(Collectors.toList()));
            jsonGenerator.writeObjectField("load_balancing", (Object)((EndpointGroup)apiEntity.getProxy().getGroups().iterator().next()).getLoadBalancer());
            if (apiEntity.getProxy().getFailover() != null) {
                jsonGenerator.writeObjectField("failover", (Object)apiEntity.getProxy().getFailover());
            }
            if (apiEntity.getProxy().getCors() != null) {
                jsonGenerator.writeObjectField("cors", (Object)apiEntity.getProxy().getCors());
            }
            jsonGenerator.writeEndObject();
        }
        if (!(filteredFieldsList = (List)apiEntity.getMetadata().get(METADATA_FILTERED_FIELDS_LIST)).contains("members")) {
            Set<MemberEntity> memberEntities = ((MembershipService)this.applicationContext.getBean(MembershipService.class)).getMembers(MembershipReferenceType.API, apiEntity.getId(), RoleScope.API);
            ArrayList members = new ArrayList(memberEntities == null ? 0 : memberEntities.size());
            if (memberEntities != null) {
                memberEntities.forEach(m -> {
                    UserEntity userEntity = ((UserService)this.applicationContext.getBean(UserService.class)).findById(m.getId());
                    if (userEntity != null) {
                        ApiSerializer.Member member = new ApiSerializer.Member();
                        member.setUsername(userEntity.getSourceId());
                        member.setRole(m.getRole());
                        members.add(member);
                    }
                });
            }
            jsonGenerator.writeObjectField("members", members);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public ApiSerializer.Version version() {
        return ApiSerializer.Version.V_1_15;
    }
}

